
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ListUsers
    Retrieves IDs for users currently subscribed to a presence channel.
*/


var ListUsers = function(session) {
    /*
        Create a new instance of the ListUsers Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Pusher/Users/ListUsers"
    ListUsers.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListUsersResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListUsersInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListUsers
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListUsersInputSet = function() {
    ListUsersInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The application ID provided by Pusher.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The authenticaion key provided by Pusher.)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The authentication secret provided by Pusher.)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the ChannelName input for this Choreo. ((required, string) The name of the channel that the users are subscribed to.)
        */
        this.set_ChannelName = function(value) {
            this.setInput("ChannelName", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListUsers Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListUsersResultSet = function(resultStream) {
    ListUsersResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Pusher.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListUsers, choreography.Choreography);
util.inherits(ListUsersInputSet, choreography.InputSet);
util.inherits(ListUsersResultSet, choreography.ResultSet);
exports.ListUsers = ListUsers;

