
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    RetentionData
    Gets cohort analysis.
*/


var RetentionData = function(session) {
    /*
        Create a new instance of the RetentionData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Retention/RetentionData"
    RetentionData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetentionDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetentionDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetentionData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetentionDataInputSet = function() {
    RetentionDataInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the BornEvent input for this Choreo. ((conditional, string) The first event a user must do to be counted in a birth retention cohort. Required when retention_type is 'birth'.)
        */
        this.set_BornEvent = function(value) {
            this.setInput("BornEvent", value);
        }

        /*
        Set the value of the BornWhere input for this Choreo. ((optional, string) An expression to filter born_events by. See Choreo description for examples.)
        */
        this.set_BornWhere = function(value) {
            this.setInput("BornWhere", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((optional, string) The event to generate returning counts for.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to begin generating cohorts from. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the Interval input for this Choreo. ((optional, integer) The number of days you want your results bucketed into.The default value is 1 or specified by unit.)
        */
        this.set_Interval = function(value) {
            this.setInput("Interval", value);
        }

        /*
        Set the value of the IntervalCount input for this Choreo. ((optional, integer) The number of intervals you want. Defaults to 1.)
        */
        this.set_IntervalCount = function(value) {
            this.setInput("IntervalCount", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) Return the top limit segmentation values. This parameter is ignored if the On input is not specified.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the On input for this Choreo. ((optional, string) The property expression to segment the second event on. See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the RetentionType input for this Choreo. ((conditional, string) The type of retention. Valid values are: birth (the default) or compounded.)
        */
        this.set_RetentionType = function(value) {
            this.setInput("RetentionType", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to stop generating cohorts from. This date is inclusive.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) This is an alternate way of specifying interval. Valid values are: day, week, or month.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., properties["Signed Up"]). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetentionData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetentionDataResultSet = function(resultStream) {
    RetentionDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetentionData, choreography.Choreography);
util.inherits(RetentionDataInputSet, choreography.InputSet);
util.inherits(RetentionDataResultSet, choreography.ResultSet);
exports.RetentionData = RetentionData;

