
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CompanyShare
    Posts shared comment on a company page.
*/


var CompanyShare = function(session) {
    /*
        Create a new instance of the CompanyShare Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/CompanyShare"
    CompanyShare.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CompanyShareResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CompanyShareInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CompanyShare
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CompanyShareInputSet = function() {
    CompanyShareInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the Comment input for this Choreo. ((conditional, string) A comment by the member to associated with the share. If this is not provided, you must specify the SubmittedURL.)
        */
        this.set_Comment = function(value) {
            this.setInput("Comment", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the Description input for this Choreo. ((optional, string) The description of the content being shared.)
        */
        this.set_Description = function(value) {
            this.setInput("Description", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the SharedTargetCode input for this Choreo. ((optional, string) A shared target code used to ensure that the shared content reaches a specific audience.)
        */
        this.set_SharedTargetCode = function(value) {
            this.setInput("SharedTargetCode", value);
        }

        /*
        Set the value of the SharedTargetValue input for this Choreo. ((optional, string) The name of the shared target used to ensure that the shared content reaches a specific audience.)
        */
        this.set_SharedTargetValue = function(value) {
            this.setInput("SharedTargetValue", value);
        }

        /*
        Set the value of the SubmittedImageURL input for this Choreo. ((optional, string) A fully qualified URL to a thumbnail image to accompany the shared content.)
        */
        this.set_SubmittedImageURL = function(value) {
            this.setInput("SubmittedImageURL", value);
        }

        /*
        Set the value of the SubmittedURL input for this Choreo. ((optional, string) A fully qualified URL for the content being shared.)
        */
        this.set_SubmittedURL = function(value) {
            this.setInput("SubmittedURL", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the content being shared.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Visibility input for this Choreo. ((required, string) The visibility setting of the share. Valid values are: anyone, connections-only.)
        */
        this.set_Visibility = function(value) {
            this.setInput("Visibility", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CompanyShare Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CompanyShareResultSet = function(resultStream) {
    CompanyShareResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CompanyShare, choreography.Choreography);
util.inherits(CompanyShareInputSet, choreography.InputSet);
util.inherits(CompanyShareResultSet, choreography.ResultSet);
exports.CompanyShare = CompanyShare;


/*
    GetComments
    Returns all comments for a specific company update.
*/


var GetComments = function(session) {
    /*
        Create a new instance of the GetComments Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetComments"
    GetComments.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCommentsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCommentsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetComments
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCommentsInputSet = function() {
    GetCommentsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the UpdateKey input for this Choreo. ((required, string) The key of the update to retrieve comments for.)
        */
        this.set_UpdateKey = function(value) {
            this.setInput("UpdateKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetComments Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCommentsResultSet = function(resultStream) {
    GetCommentsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetComments, choreography.Choreography);
util.inherits(GetCommentsInputSet, choreography.InputSet);
util.inherits(GetCommentsResultSet, choreography.ResultSet);
exports.GetComments = GetComments;


/*
    GetCompanyProfileByID
    Returns profile information about a specified company.
*/


var GetCompanyProfileByID = function(session) {
    /*
        Create a new instance of the GetCompanyProfileByID Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetCompanyProfileByID"
    GetCompanyProfileByID.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCompanyProfileByIDResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCompanyProfileByIDInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCompanyProfileByID
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCompanyProfileByIDInputSet = function() {
    GetCompanyProfileByIDInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the FieldSelector input for this Choreo. ((optional, string) A comma-separated list of additional field names to return (e.g., id,name,description). See Choreo notes for more details.)
        */
        this.set_FieldSelector = function(value) {
            this.setInput("FieldSelector", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCompanyProfileByID Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCompanyProfileByIDResultSet = function(resultStream) {
    GetCompanyProfileByIDResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetCompanyProfileByID, choreography.Choreography);
util.inherits(GetCompanyProfileByIDInputSet, choreography.InputSet);
util.inherits(GetCompanyProfileByIDResultSet, choreography.ResultSet);
exports.GetCompanyProfileByID = GetCompanyProfileByID;


/*
    GetCompanyUpdate
    Returns a specific update event from the LinkedIn company page.
*/


var GetCompanyUpdate = function(session) {
    /*
        Create a new instance of the GetCompanyUpdate Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetCompanyUpdate"
    GetCompanyUpdate.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCompanyUpdateResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCompanyUpdateInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCompanyUpdate
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCompanyUpdateInputSet = function() {
    GetCompanyUpdateInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the UpdateKey input for this Choreo. ((required, string) The key of the update to return.)
        */
        this.set_UpdateKey = function(value) {
            this.setInput("UpdateKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCompanyUpdate Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCompanyUpdateResultSet = function(resultStream) {
    GetCompanyUpdateResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetCompanyUpdate, choreography.Choreography);
util.inherits(GetCompanyUpdateInputSet, choreography.InputSet);
util.inherits(GetCompanyUpdateResultSet, choreography.ResultSet);
exports.GetCompanyUpdate = GetCompanyUpdate;


/*
    GetCompanyUpdates
    Returns a list of update events from the LinkedIn company page.
*/


var GetCompanyUpdates = function(session) {
    /*
        Create a new instance of the GetCompanyUpdates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetCompanyUpdates"
    GetCompanyUpdates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCompanyUpdatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCompanyUpdatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCompanyUpdates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCompanyUpdatesInputSet = function() {
    GetCompanyUpdatesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the Count input for this Choreo. ((optional, integer) The number of results to return in the response.)
        */
        this.set_Count = function(value) {
            this.setInput("Count", value);
        }

        /*
        Set the value of the EventType input for this Choreo. ((required, string) Filter the results to only return updates of the specified event type. Valid values are: job-posting, new-product, status-update.)
        */
        this.set_EventType = function(value) {
            this.setInput("EventType", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the Start input for this Choreo. ((optional, integer) The page index to return. Used in combination with the Count input to page through results.)
        */
        this.set_Start = function(value) {
            this.setInput("Start", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCompanyUpdates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCompanyUpdatesResultSet = function(resultStream) {
    GetCompanyUpdatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetCompanyUpdates, choreography.Choreography);
util.inherits(GetCompanyUpdatesInputSet, choreography.InputSet);
util.inherits(GetCompanyUpdatesResultSet, choreography.ResultSet);
exports.GetCompanyUpdates = GetCompanyUpdates;


/*
    GetFollowers
    Returns a company's followers, by segment.
*/


var GetFollowers = function(session) {
    /*
        Create a new instance of the GetFollowers Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetFollowers"
    GetFollowers.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetFollowersResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetFollowersInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetFollowers
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetFollowersInputSet = function() {
    GetFollowersInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the CompanySizes input for this Choreo. ((optional, string) Used to segment by a particular company size targeting code. See Choreo notes for more details.)
        */
        this.set_CompanySizes = function(value) {
            this.setInput("CompanySizes", value);
        }

        /*
        Set the value of the GeographicArea input for this Choreo. ((optional, string) Used to segment by a particular geographic area. See Choreo notes for more details.)
        */
        this.set_GeographicArea = function(value) {
            this.setInput("GeographicArea", value);
        }

        /*
        Set the value of the Industries input for this Choreo. ((optional, string) Used to segment by member industry. See Choreo notes for more details.)
        */
        this.set_Industries = function(value) {
            this.setInput("Industries", value);
        }

        /*
        Set the value of the JobFunction input for this Choreo. ((optional, string) Used to segment by member job function targeting code. See Choreo notes for more details.)
        */
        this.set_JobFunction = function(value) {
            this.setInput("JobFunction", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the SeniorityLevel input for this Choreo. ((optional, string) Used to segment by member seniority level targeting code. See Choreo notes for more details.)
        */
        this.set_SeniorityLevel = function(value) {
            this.setInput("SeniorityLevel", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetFollowers Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetFollowersResultSet = function(resultStream) {
    GetFollowersResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetFollowers, choreography.Choreography);
util.inherits(GetFollowersInputSet, choreography.InputSet);
util.inherits(GetFollowersResultSet, choreography.ResultSet);
exports.GetFollowers = GetFollowers;


/*
    GetHistoricalFollowers
    Returns a company's followers, by date range.
*/


var GetHistoricalFollowers = function(session) {
    /*
        Create a new instance of the GetHistoricalFollowers Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetHistoricalFollowers"
    GetHistoricalFollowers.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetHistoricalFollowersResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetHistoricalFollowersInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetHistoricalFollowers
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetHistoricalFollowersInputSet = function() {
    GetHistoricalFollowersInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the EndTimestamp input for this Choreo. ((optional, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.)
        */
        this.set_EndTimestamp = function(value) {
            this.setInput("EndTimestamp", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the StartTimestamp input for this Choreo. ((required, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.)
        */
        this.set_StartTimestamp = function(value) {
            this.setInput("StartTimestamp", value);
        }

        /*
        Set the value of the TimeGranularity input for this Choreo. ((required, string) Granularity of statistics. Valid values are: day, month.)
        */
        this.set_TimeGranularity = function(value) {
            this.setInput("TimeGranularity", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetHistoricalFollowers Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetHistoricalFollowersResultSet = function(resultStream) {
    GetHistoricalFollowersResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetHistoricalFollowers, choreography.Choreography);
util.inherits(GetHistoricalFollowersInputSet, choreography.InputSet);
util.inherits(GetHistoricalFollowersResultSet, choreography.ResultSet);
exports.GetHistoricalFollowers = GetHistoricalFollowers;


/*
    GetHistoricalUpdates
    Returns impression and engagement data on company shares for a given company page.
*/


var GetHistoricalUpdates = function(session) {
    /*
        Create a new instance of the GetHistoricalUpdates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetHistoricalUpdates"
    GetHistoricalUpdates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetHistoricalUpdatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetHistoricalUpdatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetHistoricalUpdates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetHistoricalUpdatesInputSet = function() {
    GetHistoricalUpdatesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the EndTimestamp input for this Choreo. ((optional, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.)
        */
        this.set_EndTimestamp = function(value) {
            this.setInput("EndTimestamp", value);
        }

        /*
        Set the value of the FieldSelector input for this Choreo. ((optional, string) A comma separated list of additional fields to return.)
        */
        this.set_FieldSelector = function(value) {
            this.setInput("FieldSelector", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the StartTimestamp input for this Choreo. ((required, date) The starting timestamp of when the stats search should begin (milliseconds since epoch). The current time will be used if a timestamp is not provided.)
        */
        this.set_StartTimestamp = function(value) {
            this.setInput("StartTimestamp", value);
        }

        /*
        Set the value of the TimeGranularity input for this Choreo. ((required, string) Granularity of statistics. Valid values are: day, month.)
        */
        this.set_TimeGranularity = function(value) {
            this.setInput("TimeGranularity", value);
        }

        /*
        Set the value of the UpdateKey input for this Choreo. ((optional, string) Optionally provide an update key value to return statistics for a specific company update.)
        */
        this.set_UpdateKey = function(value) {
            this.setInput("UpdateKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetHistoricalUpdates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetHistoricalUpdatesResultSet = function(resultStream) {
    GetHistoricalUpdatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetHistoricalUpdates, choreography.Choreography);
util.inherits(GetHistoricalUpdatesInputSet, choreography.InputSet);
util.inherits(GetHistoricalUpdatesResultSet, choreography.ResultSet);
exports.GetHistoricalUpdates = GetHistoricalUpdates;


/*
    GetLikes
    Returns all likes for a specific company update.
*/


var GetLikes = function(session) {
    /*
        Create a new instance of the GetLikes Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetLikes"
    GetLikes.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLikesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLikesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLikes
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLikesInputSet = function() {
    GetLikesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the UpdateKey input for this Choreo. ((required, string) The key of the update to return likes for.)
        */
        this.set_UpdateKey = function(value) {
            this.setInput("UpdateKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLikes Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLikesResultSet = function(resultStream) {
    GetLikesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLikes, choreography.Choreography);
util.inherits(GetLikesInputSet, choreography.InputSet);
util.inherits(GetLikesResultSet, choreography.ResultSet);
exports.GetLikes = GetLikes;


/*
    GetStatistics
    Returns general statistics for a company.
*/


var GetStatistics = function(session) {
    /*
        Create a new instance of the GetStatistics Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/GetStatistics"
    GetStatistics.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetStatisticsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetStatisticsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetStatistics
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetStatisticsInputSet = function() {
    GetStatisticsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetStatistics Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetStatisticsResultSet = function(resultStream) {
    GetStatisticsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetStatistics, choreography.Choreography);
util.inherits(GetStatisticsInputSet, choreography.InputSet);
util.inherits(GetStatisticsResultSet, choreography.ResultSet);
exports.GetStatistics = GetStatistics;


/*
    IsAdmin
    Returns a simple boolean value that indicates whether the currently authenticated user is configured to be an administrator of the specified company.
*/


var IsAdmin = function(session) {
    /*
        Create a new instance of the IsAdmin Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/IsAdmin"
    IsAdmin.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new IsAdminResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new IsAdminInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the IsAdmin
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var IsAdminInputSet = function() {
    IsAdminInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the IsAdmin Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var IsAdminResultSet = function(resultStream) {
    IsAdminResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(IsAdmin, choreography.Choreography);
util.inherits(IsAdminInputSet, choreography.InputSet);
util.inherits(IsAdminResultSet, choreography.ResultSet);
exports.IsAdmin = IsAdmin;


/*
    IsSharingEnabled
    Returns a simple boolean value that indicates whether the specified company has sharing enabled or disabled.
*/


var IsSharingEnabled = function(session) {
    /*
        Create a new instance of the IsSharingEnabled Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/IsSharingEnabled"
    IsSharingEnabled.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new IsSharingEnabledResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new IsSharingEnabledInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the IsSharingEnabled
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var IsSharingEnabledInputSet = function() {
    IsSharingEnabledInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the CompanyID input for this Choreo. ((required, integer) A LinkedIn assigned ID associated with the company.)
        */
        this.set_CompanyID = function(value) {
            this.setInput("CompanyID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the IsSharingEnabled Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var IsSharingEnabledResultSet = function(resultStream) {
    IsSharingEnabledResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(IsSharingEnabled, choreography.Choreography);
util.inherits(IsSharingEnabledInputSet, choreography.InputSet);
util.inherits(IsSharingEnabledResultSet, choreography.ResultSet);
exports.IsSharingEnabled = IsSharingEnabled;


/*
    ListCompanies
    Returns a list of all of the companies that the authenticated user is currently configured to be an administrator of.
*/


var ListCompanies = function(session) {
    /*
        Create a new instance of the ListCompanies Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/LinkedIn/Companies/ListCompanies"
    ListCompanies.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListCompaniesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListCompaniesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListCompanies
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListCompaniesInputSet = function() {
    ListCompaniesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by LinkedIn (AKA the Client ID).)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process (AKA the OAuth User Token).)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process (AKA the OAuth User Secret).)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the Count input for this Choreo. ((optional, integer) The number of results to return in the response.)
        */
        this.set_Count = function(value) {
            this.setInput("Count", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SecretKey input for this Choreo. ((required, string) The Secret Key provided by LinkedIn (AKA the Client Secret).)
        */
        this.set_SecretKey = function(value) {
            this.setInput("SecretKey", value);
        }

        /*
        Set the value of the Start input for this Choreo. ((optional, integer) The page index to return. Used in combination with the Count input to page through results.)
        */
        this.set_Start = function(value) {
            this.setInput("Start", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListCompanies Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListCompaniesResultSet = function(resultStream) {
    ListCompaniesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from LinkedIn.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListCompanies, choreography.Choreography);
util.inherits(ListCompaniesInputSet, choreography.InputSet);
util.inherits(ListCompaniesResultSet, choreography.ResultSet);
exports.ListCompanies = ListCompanies;

