
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ClearStoredHistory
    Clears the history ID stored in your Temboo account when executing the GetNextMessage Choreo.
*/


var ClearStoredHistory = function(session) {
    /*
        Create a new instance of the ClearStoredHistory Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/ClearStoredHistory"
    ClearStoredHistory.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ClearStoredHistoryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ClearStoredHistoryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ClearStoredHistory
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ClearStoredHistoryInputSet = function() {
    ClearStoredHistoryInputSet.super_.call(this);
        /*
        Set the value of the LabelID input for this Choreo. ((optional, string) The Label ID associated with the stored history ID that should be deleted.)
        */
        this.set_LabelID = function(value) {
            this.setInput("LabelID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ClearStoredHistory Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ClearStoredHistoryResultSet = function(resultStream) {
    ClearStoredHistoryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Deleted" output from this Choreo execution. ((boolean) Returns true when the history ID is successfully deleted.)
        */
        this.get_Deleted = function() {
            return this.getResult("Deleted");
        }
}

util.inherits(ClearStoredHistory, choreography.Choreography);
util.inherits(ClearStoredHistoryInputSet, choreography.InputSet);
util.inherits(ClearStoredHistoryResultSet, choreography.ResultSet);
exports.ClearStoredHistory = ClearStoredHistory;


/*
    DeleteMessage
    Permanently deletes a specified message.
*/


var DeleteMessage = function(session) {
    /*
        Create a new instance of the DeleteMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/DeleteMessage"
    DeleteMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteMessageInputSet = function() {
    DeleteMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to delete.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteMessageResultSet = function(resultStream) {
    DeleteMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "ResponseStatusCode" output from this Choreo execution. ((integer) The response status code returned from Google. A 204 is expected for a successful delete operation.)
        */
        this.get_ResponseStatusCode = function() {
            return this.getResult("ResponseStatusCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google. An empty response is expected for a successful delete operation.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteMessage, choreography.Choreography);
util.inherits(DeleteMessageInputSet, choreography.InputSet);
util.inherits(DeleteMessageResultSet, choreography.ResultSet);
exports.DeleteMessage = DeleteMessage;


/*
    GetLatestMessage
    Retrieves the latest email from a user's inbox.
*/


var GetLatestMessage = function(session) {
    /*
        Create a new instance of the GetLatestMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/GetLatestMessage"
    GetLatestMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLatestMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLatestMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLatestMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLatestMessageInputSet = function() {
    GetLatestMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the EncodeMessage input for this Choreo. ((optional, boolean) When set to "true" (the default), the message Body will be Base64 encoded.)
        */
        this.set_EncodeMessage = function(value) {
            this.setInput("EncodeMessage", value);
        }

        /*
        Set the value of the IncludeSpamTrash input for this Choreo. ((optional, boolean) Set to "true" to include messages from SPAM and TRASH in the results. Defaults to "false".)
        */
        this.set_IncludeSpamTrash = function(value) {
            this.setInput("IncludeSpamTrash", value);
        }

        /*
        Set the value of the LabelID input for this Choreo. ((optional, string) Returns messages with a label matching this ID.)
        */
        this.set_LabelID = function(value) {
            this.setInput("LabelID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the StartHistoryID input for this Choreo. ((optional, string) Returns history records after the specified marker. The history ID is returned by this Choreo after retrieving a message.)
        */
        this.set_StartHistoryID = function(value) {
            this.setInput("StartHistoryID", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLatestMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLatestMessageResultSet = function(resultStream) {
    GetLatestMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Body" output from this Choreo execution. ((string) The message body.)
        */
        this.get_Body = function() {
            return this.getResult("Body");
        }
        /*
        Retrieve the value for the "From" output from this Choreo execution. ((string) The sender address.)
        */
        this.get_From = function() {
            return this.getResult("From");
        }
        /*
        Retrieve the value for the "HistoryID" output from this Choreo execution. ((string) The history ID. This can be passed to the StartHistoryID input to retrieve only mail received after this marker.)
        */
        this.get_HistoryID = function() {
            return this.getResult("HistoryID");
        }
        /*
        Retrieve the value for the "MessageID" output from this Choreo execution. ((string) The ID of the message.)
        */
        this.get_MessageID = function() {
            return this.getResult("MessageID");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Snippet" output from this Choreo execution. ((string) The email body snippet.)
        */
        this.get_Snippet = function() {
            return this.getResult("Snippet");
        }
        /*
        Retrieve the value for the "Subject" output from this Choreo execution. ((string) The message subject.)
        */
        this.get_Subject = function() {
            return this.getResult("Subject");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLatestMessage, choreography.Choreography);
util.inherits(GetLatestMessageInputSet, choreography.InputSet);
util.inherits(GetLatestMessageResultSet, choreography.ResultSet);
exports.GetLatestMessage = GetLatestMessage;


/*
    GetMessage
    Retrieves an individual message from a user's mailbox.
*/


var GetMessage = function(session) {
    /*
        Create a new instance of the GetMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/GetMessage"
    GetMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetMessageInputSet = function() {
    GetMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((optional, boolean) Specifies the format of the message returned. Valid values are: full (the default), minimal, and raw. See Choreo notes for more details about these formats.)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to retrieve.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetMessageResultSet = function(resultStream) {
    GetMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetMessage, choreography.Choreography);
util.inherits(GetMessageInputSet, choreography.InputSet);
util.inherits(GetMessageResultSet, choreography.ResultSet);
exports.GetMessage = GetMessage;


/*
    GetNextMessage
    Retrieves the next email from a user's inbox.
*/


var GetNextMessage = function(session) {
    /*
        Create a new instance of the GetNextMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/GetNextMessage"
    GetNextMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetNextMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetNextMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetNextMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetNextMessageInputSet = function() {
    GetNextMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the EncodeMessage input for this Choreo. ((optional, boolean) When set to "true" (the default), the message Body will be Base64 encoded.)
        */
        this.set_EncodeMessage = function(value) {
            this.setInput("EncodeMessage", value);
        }

        /*
        Set the value of the LabelID input for this Choreo. ((conditional, string) Returns messages with a label matching this ID (e.g., INBOX, UNREAD, Label_1, etc.))
        */
        this.set_LabelID = function(value) {
            this.setInput("LabelID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetNextMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetNextMessageResultSet = function(resultStream) {
    GetNextMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Body" output from this Choreo execution. ((string) The message body.)
        */
        this.get_Body = function() {
            return this.getResult("Body");
        }
        /*
        Retrieve the value for the "From" output from this Choreo execution. ((string) The sender address.)
        */
        this.get_From = function() {
            return this.getResult("From");
        }
        /*
        Retrieve the value for the "MessageID" output from this Choreo execution. ((string) The ID of the message.)
        */
        this.get_MessageID = function() {
            return this.getResult("MessageID");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "ResponseStatusCode" output from this Choreo execution. ((integer) The response code returned from Google. A 200 is expected for a successful request. A 404 indicates that the stored history id has become invalid or expired. See Choreo notes for more details.)
        */
        this.get_ResponseStatusCode = function() {
            return this.getResult("ResponseStatusCode");
        }
        /*
        Retrieve the value for the "Snippet" output from this Choreo execution. ((string) The email body snippet.)
        */
        this.get_Snippet = function() {
            return this.getResult("Snippet");
        }
        /*
        Retrieve the value for the "Subject" output from this Choreo execution. ((string) The message subject.)
        */
        this.get_Subject = function() {
            return this.getResult("Subject");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetNextMessage, choreography.Choreography);
util.inherits(GetNextMessageInputSet, choreography.InputSet);
util.inherits(GetNextMessageResultSet, choreography.ResultSet);
exports.GetNextMessage = GetNextMessage;


/*
    InsertMessage
    Directly inserts a message into a user's mailbox. Does not send a message.
*/


var InsertMessage = function(session) {
    /*
        Create a new instance of the InsertMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/InsertMessage"
    InsertMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new InsertMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new InsertMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the InsertMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var InsertMessageInputSet = function() {
    InsertMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AttachmentContentType input for this Choreo. ((optional, string) The Content-Type of the attachment. This is required when providing AttachmentFileContent (e.g., image/jpeg, text/plain, etc).)
        */
        this.set_AttachmentContentType = function(value) {
            this.setInput("AttachmentContentType", value);
        }

        /*
        Set the value of the AttachmentFileContent input for this Choreo. ((optional, string) The Base64 encoded file content for the attachment. You must specify the AttachmentFileContentType when including an attachment.)
        */
        this.set_AttachmentFileContent = function(value) {
            this.setInput("AttachmentFileContent", value);
        }

        /*
        Set the value of the AttachmentFileName input for this Choreo. ((optional, string) The file name of the attachment.)
        */
        this.set_AttachmentFileName = function(value) {
            this.setInput("AttachmentFileName", value);
        }

        /*
        Set the value of the BCC input for this Choreo. ((optional, string) The address and name (optional) that should be bcc'd e.g., Dan <dan@temboo.com>.)
        */
        this.set_BCC = function(value) {
            this.setInput("BCC", value);
        }

        /*
        Set the value of the CC input for this Choreo. ((optional, string) The address and name (optional) that should be cc'd e.g., Dan <dan@temboo.com>.)
        */
        this.set_CC = function(value) {
            this.setInput("CC", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) The address and name (optional) that the email is being sent from e.g., Dan <dan@temboo.com>.)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the LabelIDs input for this Choreo. ((optional, json) An array of Gmail labels to apply to this message (e.g., ["SENT", "INBOX", "UNREAD"].)
        */
        this.set_LabelIDs = function(value) {
            this.setInput("LabelIDs", value);
        }

        /*
        Set the value of the MessageBody input for this Choreo. ((required, string) The text for the message body of the email.)
        */
        this.set_MessageBody = function(value) {
            this.setInput("MessageBody", value);
        }

        /*
        Set the value of the MessageBodyContentType input for this Choreo. ((optional, string) The Content-Type of the message body. Defaults to "text/plain; charset=UTF-8".)
        */
        this.set_MessageBodyContentType = function(value) {
            this.setInput("MessageBodyContentType", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the ReplyTo input for this Choreo. ((optional, string) An email address to set as the Reply-To address.)
        */
        this.set_ReplyTo = function(value) {
            this.setInput("ReplyTo", value);
        }

        /*
        Set the value of the Subject input for this Choreo. ((required, string) The email subject.)
        */
        this.set_Subject = function(value) {
            this.setInput("Subject", value);
        }

        /*
        Set the value of the ThreadID input for this Choreo. ((optional, string) The ID of the thread the message belongs to.)
        */
        this.set_ThreadID = function(value) {
            this.setInput("ThreadID", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) The address and name (optional) that the email is being sent to e.g., Dan <dan@temboo.com>.)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the InsertMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var InsertMessageResultSet = function(resultStream) {
    InsertMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(InsertMessage, choreography.Choreography);
util.inherits(InsertMessageInputSet, choreography.InputSet);
util.inherits(InsertMessageResultSet, choreography.ResultSet);
exports.InsertMessage = InsertMessage;


/*
    ListMessages
    Lists the messages in the user's mailbox.
*/


var ListMessages = function(session) {
    /*
        Create a new instance of the ListMessages Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/ListMessages"
    ListMessages.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListMessagesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListMessagesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListMessages
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListMessagesInputSet = function() {
    ListMessagesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the IncludeSpamTrash input for this Choreo. ((optional, boolean) Set to "true" to include messages from SPAM and TRASH in the results. Defaults to "false".)
        */
        this.set_IncludeSpamTrash = function(value) {
            this.setInput("IncludeSpamTrash", value);
        }

        /*
        Set the value of the LabelIDs input for this Choreo. ((optional, json) A JSON array containing labels to filter by. When specified, only messages with labels that match are returned.)
        */
        this.set_LabelIDs = function(value) {
            this.setInput("LabelIDs", value);
        }

        /*
        Set the value of the MaxResults input for this Choreo. ((optional, integer) The maximum number of results to return.)
        */
        this.set_MaxResults = function(value) {
            this.setInput("MaxResults", value);
        }

        /*
        Set the value of the PageToken input for this Choreo. ((optional, string) The "nextPageToken" found in the response which is used to page through results.)
        */
        this.set_PageToken = function(value) {
            this.setInput("PageToken", value);
        }

        /*
        Set the value of the Query input for this Choreo. ((optional, string) Filters messages that match the specified query. Supports the same query format as the Gmail search box. For example, "from:someuser@example.com rfc822msgid: is:unread".)
        */
        this.set_Query = function(value) {
            this.setInput("Query", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListMessages Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListMessagesResultSet = function(resultStream) {
    ListMessagesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListMessages, choreography.Choreography);
util.inherits(ListMessagesInputSet, choreography.InputSet);
util.inherits(ListMessagesResultSet, choreography.ResultSet);
exports.ListMessages = ListMessages;


/*
    ModifyMessage
    Modifies the labels for a specific message.
*/


var ModifyMessage = function(session) {
    /*
        Create a new instance of the ModifyMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/ModifyMessage"
    ModifyMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ModifyMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ModifyMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ModifyMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ModifyMessageInputSet = function() {
    ModifyMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AddLabelIDs input for this Choreo. ((conditional, json) An array of label IDs to apply to the message.)
        */
        this.set_AddLabelIDs = function(value) {
            this.setInput("AddLabelIDs", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to modify.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the RemoveLabelIDs input for this Choreo. ((conditional, json) An array of label IDs to remove from the message.)
        */
        this.set_RemoveLabelIDs = function(value) {
            this.setInput("RemoveLabelIDs", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ModifyMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ModifyMessageResultSet = function(resultStream) {
    ModifyMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ModifyMessage, choreography.Choreography);
util.inherits(ModifyMessageInputSet, choreography.InputSet);
util.inherits(ModifyMessageResultSet, choreography.ResultSet);
exports.ModifyMessage = ModifyMessage;


/*
    SendMessage
    Sends an email to the recipients specified in the To, CC, and BCC parameters.
*/


var SendMessage = function(session) {
    /*
        Create a new instance of the SendMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/SendMessage"
    SendMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SendMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SendMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SendMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SendMessageInputSet = function() {
    SendMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AttachmentContentType input for this Choreo. ((optional, string) The Content-Type of the attachment. This is required when providing AttachmentFileContent (e.g., image/jpeg, text/plain, etc).)
        */
        this.set_AttachmentContentType = function(value) {
            this.setInput("AttachmentContentType", value);
        }

        /*
        Set the value of the AttachmentFileContent input for this Choreo. ((optional, string) The Base64 encoded file content for the attachment. You must specify the AttachmentFileContentType when including an attachment.)
        */
        this.set_AttachmentFileContent = function(value) {
            this.setInput("AttachmentFileContent", value);
        }

        /*
        Set the value of the AttachmentFileName input for this Choreo. ((optional, string) The file name of the attachment.)
        */
        this.set_AttachmentFileName = function(value) {
            this.setInput("AttachmentFileName", value);
        }

        /*
        Set the value of the BCC input for this Choreo. ((optional, string) The address and name (optional) that should be bcc'd e.g., Dan <dan@temboo.com>.)
        */
        this.set_BCC = function(value) {
            this.setInput("BCC", value);
        }

        /*
        Set the value of the CC input for this Choreo. ((optional, string) The address and name (optional) that should be cc'd e.g., Dan <dan@temboo.com>.)
        */
        this.set_CC = function(value) {
            this.setInput("CC", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) The address and name (optional) that the email is being sent from e.g., Dan <dan@temboo.com>.)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the MessageBody input for this Choreo. ((required, string) The text for the message body of the email.)
        */
        this.set_MessageBody = function(value) {
            this.setInput("MessageBody", value);
        }

        /*
        Set the value of the MessageBodyContentType input for this Choreo. ((optional, string) The Content-Type of the message body. Defaults to "text/plain; charset=UTF-8".)
        */
        this.set_MessageBodyContentType = function(value) {
            this.setInput("MessageBodyContentType", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the ReplyTo input for this Choreo. ((optional, string) An email address to set as the Reply-To address.)
        */
        this.set_ReplyTo = function(value) {
            this.setInput("ReplyTo", value);
        }

        /*
        Set the value of the Subject input for this Choreo. ((required, string) The email subject.)
        */
        this.set_Subject = function(value) {
            this.setInput("Subject", value);
        }

        /*
        Set the value of the ThreadID input for this Choreo. ((optional, string) The ID of the thread the message belongs to.)
        */
        this.set_ThreadID = function(value) {
            this.setInput("ThreadID", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) The address and name (optional) that the email is being sent to e.g., Dan <dan@temboo.com>.)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SendMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SendMessageResultSet = function(resultStream) {
    SendMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SendMessage, choreography.Choreography);
util.inherits(SendMessageInputSet, choreography.InputSet);
util.inherits(SendMessageResultSet, choreography.ResultSet);
exports.SendMessage = SendMessage;


/*
    TrashMessage
    Moves a specific message to the trash.
*/


var TrashMessage = function(session) {
    /*
        Create a new instance of the TrashMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/TrashMessage"
    TrashMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TrashMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TrashMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TrashMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TrashMessageInputSet = function() {
    TrashMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to move to the trash.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TrashMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TrashMessageResultSet = function(resultStream) {
    TrashMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TrashMessage, choreography.Choreography);
util.inherits(TrashMessageInputSet, choreography.InputSet);
util.inherits(TrashMessageResultSet, choreography.ResultSet);
exports.TrashMessage = TrashMessage;


/*
    UnTrashMessage
    Moves a specific message out of the trash.
*/


var UnTrashMessage = function(session) {
    /*
        Create a new instance of the UnTrashMessage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Messages/UnTrashMessage"
    UnTrashMessage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UnTrashMessageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UnTrashMessageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UnTrashMessage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UnTrashMessageInputSet = function() {
    UnTrashMessageInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Used to specify fields to include in a partial response. This can be used to reduce the amount of data returned. See Choreo notes for syntax rules.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to restore.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The ID of the acting user. Defaults to "me" indicating the user associated with the Access Token or Refresh Token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UnTrashMessage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UnTrashMessageResultSet = function(resultStream) {
    UnTrashMessageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UnTrashMessage, choreography.Choreography);
util.inherits(UnTrashMessageInputSet, choreography.InputSet);
util.inherits(UnTrashMessageResultSet, choreography.ResultSet);
exports.UnTrashMessage = UnTrashMessage;

