
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddAlarm
    Creates an alarm entry for a given device.
*/


var AddAlarm = function(session) {
    /*
        Create a new instance of the AddAlarm Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Fitbit/Devices/AddAlarm"
    AddAlarm.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddAlarmResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddAlarmInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddAlarm
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddAlarmInputSet = function() {
    AddAlarmInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the ConsumerKey input for this Choreo. ((required, string) The Consumer Key provided by Fitbit.)
        */
        this.set_ConsumerKey = function(value) {
            this.setInput("ConsumerKey", value);
        }

        /*
        Set the value of the ConsumerSecret input for this Choreo. ((required, string) The Consumer Secret provided by Fitbit.)
        */
        this.set_ConsumerSecret = function(value) {
            this.setInput("ConsumerSecret", value);
        }

        /*
        Set the value of the DeviceID input for this Choreo. ((required, string) The id of the device you would like to manage the alarm on.)
        */
        this.set_DeviceID = function(value) {
            this.setInput("DeviceID", value);
        }

        /*
        Set the value of the Enabled input for this Choreo. ((required, boolean) Indicates whether or not the alarm is enabled. Valid values are: true and false.)
        */
        this.set_Enabled = function(value) {
            this.setInput("Enabled", value);
        }

        /*
        Set the value of the Label input for this Choreo. ((optional, string) A label for the alarm.)
        */
        this.set_Label = function(value) {
            this.setInput("Label", value);
        }

        /*
        Set the value of the Recurring input for this Choreo. ((required, boolean) Specifies if this is a one-time or recurring alarm. Valid values are: true or false. When adding a recurring alarm, the WeekDays input is required.)
        */
        this.set_Recurring = function(value) {
            this.setInput("Recurring", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that you want the response to be in: xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SnoozeCount input for this Choreo. ((optional, integer) The maximum snooze count.)
        */
        this.set_SnoozeCount = function(value) {
            this.setInput("SnoozeCount", value);
        }

        /*
        Set the value of the SnoozeLength input for this Choreo. ((optional, integer) The number of minutes in between alarms when using the snooze option.)
        */
        this.set_SnoozeLength = function(value) {
            this.setInput("SnoozeLength", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((required, string) The time of the alarm in the format XX:XX+XX:XX (the hour, minute, and time offset from UTC). This will be converted to the timezone of the user's profile.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

        /*
        Set the value of the Vibe input for this Choreo. ((optional, string) The vibe pattern. Currently this only has one accepted value: DEFAULT.)
        */
        this.set_Vibe = function(value) {
            this.setInput("Vibe", value);
        }

        /*
        Set the value of the WeekDays input for this Choreo. ((required, string) Specifies the days of the week that the alarm is active. Required when specifying a "recurring" alarm. Multiple days can be specified in a comma-separated list (e.g., MONDAY,TUESDAY,WEDNESDAY).)
        */
        this.set_WeekDays = function(value) {
            this.setInput("WeekDays", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddAlarm Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddAlarmResultSet = function(resultStream) {
    AddAlarmResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Fitbit.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddAlarm, choreography.Choreography);
util.inherits(AddAlarmInputSet, choreography.InputSet);
util.inherits(AddAlarmResultSet, choreography.ResultSet);
exports.AddAlarm = AddAlarm;


/*
    DeleteAlarm
    Deletes an alarm entry for a given device.
*/


var DeleteAlarm = function(session) {
    /*
        Create a new instance of the DeleteAlarm Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Fitbit/Devices/DeleteAlarm"
    DeleteAlarm.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteAlarmResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteAlarmInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteAlarm
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteAlarmInputSet = function() {
    DeleteAlarmInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AlarmID input for this Choreo. ((required, string) The ID of the alarm to delete.)
        */
        this.set_AlarmID = function(value) {
            this.setInput("AlarmID", value);
        }

        /*
        Set the value of the ConsumerKey input for this Choreo. ((required, string) The Consumer Key provided by Fitbit.)
        */
        this.set_ConsumerKey = function(value) {
            this.setInput("ConsumerKey", value);
        }

        /*
        Set the value of the ConsumerSecret input for this Choreo. ((required, string) The Consumer Secret provided by Fitbit.)
        */
        this.set_ConsumerSecret = function(value) {
            this.setInput("ConsumerSecret", value);
        }

        /*
        Set the value of the DeviceID input for this Choreo. ((required, string) The id of the device you would like to manage the alarm on.)
        */
        this.set_DeviceID = function(value) {
            this.setInput("DeviceID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that you want the response to be in: xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteAlarm Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteAlarmResultSet = function(resultStream) {
    DeleteAlarmResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Fitbit.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteAlarm, choreography.Choreography);
util.inherits(DeleteAlarmInputSet, choreography.InputSet);
util.inherits(DeleteAlarmResultSet, choreography.ResultSet);
exports.DeleteAlarm = DeleteAlarm;


/*
    GetAlarms
    Retrieves the list of Fitbit device alarms for a specific device.
*/


var GetAlarms = function(session) {
    /*
        Create a new instance of the GetAlarms Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Fitbit/Devices/GetAlarms"
    GetAlarms.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetAlarmsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetAlarmsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetAlarms
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetAlarmsInputSet = function() {
    GetAlarmsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the ConsumerKey input for this Choreo. ((required, string) The Consumer Key provided by Fitbit.)
        */
        this.set_ConsumerKey = function(value) {
            this.setInput("ConsumerKey", value);
        }

        /*
        Set the value of the ConsumerSecret input for this Choreo. ((required, string) The Consumer Secret provided by Fitbit.)
        */
        this.set_ConsumerSecret = function(value) {
            this.setInput("ConsumerSecret", value);
        }

        /*
        Set the value of the DeviceID input for this Choreo. ((required, string) The id of the device you would like to manage the alarm on.)
        */
        this.set_DeviceID = function(value) {
            this.setInput("DeviceID", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that you want the response to be in: xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetAlarms Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetAlarmsResultSet = function(resultStream) {
    GetAlarmsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Fitbit.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetAlarms, choreography.Choreography);
util.inherits(GetAlarmsInputSet, choreography.InputSet);
util.inherits(GetAlarmsResultSet, choreography.ResultSet);
exports.GetAlarms = GetAlarms;


/*
    GetDevices
    Retrieves the list of Fitbit devices for a user.
*/


var GetDevices = function(session) {
    /*
        Create a new instance of the GetDevices Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Fitbit/Devices/GetDevices"
    GetDevices.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetDevicesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetDevicesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetDevices
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetDevicesInputSet = function() {
    GetDevicesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the ConsumerKey input for this Choreo. ((required, string) The Consumer Key provided by Fitbit.)
        */
        this.set_ConsumerKey = function(value) {
            this.setInput("ConsumerKey", value);
        }

        /*
        Set the value of the ConsumerSecret input for this Choreo. ((required, string) The Consumer Secret provided by Fitbit.)
        */
        this.set_ConsumerSecret = function(value) {
            this.setInput("ConsumerSecret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that you want the response to be in: xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetDevices Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetDevicesResultSet = function(resultStream) {
    GetDevicesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Fitbit.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetDevices, choreography.Choreography);
util.inherits(GetDevicesInputSet, choreography.InputSet);
util.inherits(GetDevicesResultSet, choreography.ResultSet);
exports.GetDevices = GetDevices;


/*
    UpdateAlarm
    Updates an existing alarm entry for a given device.
*/


var UpdateAlarm = function(session) {
    /*
        Create a new instance of the UpdateAlarm Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Fitbit/Devices/UpdateAlarm"
    UpdateAlarm.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateAlarmResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateAlarmInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateAlarm
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateAlarmInputSet = function() {
    UpdateAlarmInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AlarmID input for this Choreo. ((required, string) The ID of the alarm to update.)
        */
        this.set_AlarmID = function(value) {
            this.setInput("AlarmID", value);
        }

        /*
        Set the value of the ConsumerKey input for this Choreo. ((required, string) The Consumer Key provided by Fitbit.)
        */
        this.set_ConsumerKey = function(value) {
            this.setInput("ConsumerKey", value);
        }

        /*
        Set the value of the ConsumerSecret input for this Choreo. ((required, string) The Consumer Secret provided by Fitbit.)
        */
        this.set_ConsumerSecret = function(value) {
            this.setInput("ConsumerSecret", value);
        }

        /*
        Set the value of the DeviceID input for this Choreo. ((required, string) The id of the device you would like to manage the alarm on.)
        */
        this.set_DeviceID = function(value) {
            this.setInput("DeviceID", value);
        }

        /*
        Set the value of the Enabled input for this Choreo. ((required, boolean) Indicates whether or not the alarm is enabled. Valid values are: true and false.)
        */
        this.set_Enabled = function(value) {
            this.setInput("Enabled", value);
        }

        /*
        Set the value of the Label input for this Choreo. ((optional, string) A label for the alarm.)
        */
        this.set_Label = function(value) {
            this.setInput("Label", value);
        }

        /*
        Set the value of the Recurring input for this Choreo. ((required, boolean) Specifies if this is a one-time or recurring alarm. Valid values are: true or false. When adding a recurring alarm, the WeekDays input is required.)
        */
        this.set_Recurring = function(value) {
            this.setInput("Recurring", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that you want the response to be in: xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SnoozeCount input for this Choreo. ((required, integer) The maximum snooze count.)
        */
        this.set_SnoozeCount = function(value) {
            this.setInput("SnoozeCount", value);
        }

        /*
        Set the value of the SnoozeLength input for this Choreo. ((required, integer) The number of minutes in between alarms when using the snooze option.)
        */
        this.set_SnoozeLength = function(value) {
            this.setInput("SnoozeLength", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((required, string) The time of the alarm in the format XX:XX+XX:XX (the hour, minute, and time offset from UTC). This will be converted to the timezone of the user's profile.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The user's encoded id. Defaults to "-" (dash) which will return data for the user associated with the token credentials provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

        /*
        Set the value of the Vibe input for this Choreo. ((optional, string) The vibe pattern. Currently this only has one accepted value: DEFAULT.)
        */
        this.set_Vibe = function(value) {
            this.setInput("Vibe", value);
        }

        /*
        Set the value of the WeekDays input for this Choreo. ((required, string) Specifies the days of the week that the alarm is active. Required when specifying a "recurring" alarm. Multiple days can be specified in a comma-separated list (e.g., MONDAY,TUESDAY,WEDNESDAY).)
        */
        this.set_WeekDays = function(value) {
            this.setInput("WeekDays", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateAlarm Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateAlarmResultSet = function(resultStream) {
    UpdateAlarmResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Fitbit.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateAlarm, choreography.Choreography);
util.inherits(UpdateAlarmInputSet, choreography.InputSet);
util.inherits(UpdateAlarmResultSet, choreography.ResultSet);
exports.UpdateAlarm = UpdateAlarm;

