
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddressValidation
    Validates a given address.
*/


var AddressValidation = function(session) {
    /*
        Create a new instance of the AddressValidation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/Validation/AddressValidation"
    AddressValidation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddressValidationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddressValidationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddressValidation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddressValidationInputSet = function() {
    AddressValidationInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the City input for this Choreo. ((conditional, string) The name of the city or town.)
        */
        this.set_City = function(value) {
            this.setInput("City", value);
        }

        /*
        Set the value of the ClientReferenceID input for this Choreo. ((optional, string) A reference id provided by the client.)
        */
        this.set_ClientReferenceID = function(value) {
            this.setInput("ClientReferenceID", value);
        }

        /*
        Set the value of the CompanyName input for this Choreo. ((optional, string) Identifies the company associated with the location.)
        */
        this.set_CompanyName = function(value) {
            this.setInput("CompanyName", value);
        }

        /*
        Set the value of the CountryCode input for this Choreo. ((conditional, string) The country code associated with the address being validated (e.g., US).)
        */
        this.set_CountryCode = function(value) {
            this.setInput("CountryCode", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the PhoneNumber input for this Choreo. ((optional, string) Identifies the phone number associated with the contact being validated.)
        */
        this.set_PhoneNumber = function(value) {
            this.setInput("PhoneNumber", value);
        }

        /*
        Set the value of the PostalCode input for this Choreo. ((conditional, string) The postal code associated with the address being validated.)
        */
        this.set_PostalCode = function(value) {
            this.setInput("PostalCode", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the State input for this Choreo. ((conditional, string) Identifying abbreviation for US state, Canada province (e.g., NY).)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Street input for this Choreo. ((conditional, string) The street number and street name (e.g., 350 5th Ave).)
        */
        this.set_Street = function(value) {
            this.setInput("Street", value);
        }

        /*
        Set the value of the UrbanizationCode input for this Choreo. ((optional, string) Relevant only to addresses in Puerto Rico.)
        */
        this.set_UrbanizationCode = function(value) {
            this.setInput("UrbanizationCode", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddressValidation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddressValidationResultSet = function(resultStream) {
    AddressValidationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddressValidation, choreography.Choreography);
util.inherits(AddressValidationInputSet, choreography.InputSet);
util.inherits(AddressValidationResultSet, choreography.ResultSet);
exports.AddressValidation = AddressValidation;

