
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    TrackByNumber
    Retrieves shipment information for a specified tracking number.
*/


var TrackByNumber = function(session) {
    /*
        Create a new instance of the TrackByNumber Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/TrackingAndVisibility/TrackByNumber"
    TrackByNumber.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TrackByNumberResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TrackByNumberInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TrackByNumber
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TrackByNumberInputSet = function() {
    TrackByNumberInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the TrackingNumber input for this Choreo. ((required, string) The tracking number for the shipment.)
        */
        this.set_TrackingNumber = function(value) {
            this.setInput("TrackingNumber", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TrackByNumber Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TrackByNumberResultSet = function(resultStream) {
    TrackByNumberResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TrackByNumber, choreography.Choreography);
util.inherits(TrackByNumberInputSet, choreography.InputSet);
util.inherits(TrackByNumberResultSet, choreography.ResultSet);
exports.TrackByNumber = TrackByNumber;


/*
    TrackByReference
    Retrieves shipment information for a specified reference number.
*/


var TrackByReference = function(session) {
    /*
        Create a new instance of the TrackByReference Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/TrackingAndVisibility/TrackByReference"
    TrackByReference.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TrackByReferenceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TrackByReferenceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TrackByReference
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TrackByReferenceInputSet = function() {
    TrackByReferenceInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the City input for this Choreo. ((optional, string) The destination city.)
        */
        this.set_City = function(value) {
            this.setInput("City", value);
        }

        /*
        Set the value of the CountryCode input for this Choreo. ((conditional, string) The country code associated with the shipment destination (e.g., US). Required unless specifying the ShipmentAccountNumber.)
        */
        this.set_CountryCode = function(value) {
            this.setInput("CountryCode", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the OperatingCompany input for this Choreo. ((required, string) Identification for a fedex operating company (e.g.,  fedex_express, fedex_freight, fedex_ground). See Choreo notes for allowed values.)
        */
        this.set_OperatingCompany = function(value) {
            this.setInput("OperatingCompany", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the PostalCode input for this Choreo. ((conditional, string) The postal code associated with the shipment destination. Required unless specifying the ShipmentAccountNumber.)
        */
        this.set_PostalCode = function(value) {
            this.setInput("PostalCode", value);
        }

        /*
        Set the value of the Reference input for this Choreo. ((required, string) A reference number for tracking the shipment.)
        */
        this.set_Reference = function(value) {
            this.setInput("Reference", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the ShipDateRangeBegin input for this Choreo. ((optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.)
        */
        this.set_ShipDateRangeBegin = function(value) {
            this.setInput("ShipDateRangeBegin", value);
        }

        /*
        Set the value of the ShipDateRangeEnd input for this Choreo. ((optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.)
        */
        this.set_ShipDateRangeEnd = function(value) {
            this.setInput("ShipDateRangeEnd", value);
        }

        /*
        Set the value of the ShipmentAccountNumber input for this Choreo. ((conditional, string) The shipment account number. Required unless specifying the PostalCode and CountryCode.)
        */
        this.set_ShipmentAccountNumber = function(value) {
            this.setInput("ShipmentAccountNumber", value);
        }

        /*
        Set the value of the State input for this Choreo. ((optional, string) Identifying abbreviation for US state, Canada province of the shipment destination (e.g., NY).)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Street input for this Choreo. ((optional, string) The street number and street name for the shipment destination (e.g., 350 5th Ave).)
        */
        this.set_Street = function(value) {
            this.setInput("Street", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TrackByReference Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TrackByReferenceResultSet = function(resultStream) {
    TrackByReferenceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TrackByReference, choreography.Choreography);
util.inherits(TrackByReferenceInputSet, choreography.InputSet);
util.inherits(TrackByReferenceResultSet, choreography.ResultSet);
exports.TrackByReference = TrackByReference;

