
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    SearchLocationsByAddress
    Searches for FedEx locations near a given address.
*/


var SearchLocationsByAddress = function(session) {
    /*
        Create a new instance of the SearchLocationsByAddress Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/Locations/SearchLocationsByAddress"
    SearchLocationsByAddress.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SearchLocationsByAddressResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SearchLocationsByAddressInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SearchLocationsByAddress
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SearchLocationsByAddressInputSet = function() {
    SearchLocationsByAddressInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the City input for this Choreo. ((required, string) The city associated with the location being searched.)
        */
        this.set_City = function(value) {
            this.setInput("City", value);
        }

        /*
        Set the value of the CountryCode input for this Choreo. ((required, string) The country code associated with the location being searched (e.g., US).)
        */
        this.set_CountryCode = function(value) {
            this.setInput("CountryCode", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the PostalCode input for this Choreo. ((required, string) The postal code associated with the location being searched.)
        */
        this.set_PostalCode = function(value) {
            this.setInput("PostalCode", value);
        }

        /*
        Set the value of the RadiusDistance input for this Choreo. ((optional, decimal) Specifies value of the radius around the address to search for FedEx locations. Note that RadiusUnits applies to this value. Defaults to 10 miles.)
        */
        this.set_RadiusDistance = function(value) {
            this.setInput("RadiusDistance", value);
        }

        /*
        Set the value of the RadiusUnits input for this Choreo. ((optional, string) Specifies the unit of measure for the RadiusDistance value. Valid values are mi (the default) and km.)
        */
        this.set_RadiusUnits = function(value) {
            this.setInput("RadiusUnits", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SortBy input for this Choreo. ((optional, string) Specifies the criterion to be used to sort the location details. Valid values are: distance (the default), latest_express_dropoff_time, latest_ground_dropoff_time, location_type.)
        */
        this.set_SortBy = function(value) {
            this.setInput("SortBy", value);
        }

        /*
        Set the value of the SortOrder input for this Choreo. ((optional, string) Specifies sort order of the location details. Valid values are: lowest_to_highest (the default) and highest_to_lowest.)
        */
        this.set_SortOrder = function(value) {
            this.setInput("SortOrder", value);
        }

        /*
        Set the value of the State input for this Choreo. ((required, string) Identifying abbreviation for US state, Canada province (e.g., NY).)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Street input for this Choreo. ((required, string) The street number and street name (e.g., 350 5th Ave).)
        */
        this.set_Street = function(value) {
            this.setInput("Street", value);
        }

        /*
        Set the value of the SupportedServices input for this Choreo. ((optional, string) Specifies the types of services supported by a FedEx location for redirect to hold. Valid values are: fedex_express, fedex_ground, fedex_ground_home_delivery.)
        */
        this.set_SupportedServices = function(value) {
            this.setInput("SupportedServices", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SearchLocationsByAddress Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SearchLocationsByAddressResultSet = function(resultStream) {
    SearchLocationsByAddressResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SearchLocationsByAddress, choreography.Choreography);
util.inherits(SearchLocationsByAddressInputSet, choreography.InputSet);
util.inherits(SearchLocationsByAddressResultSet, choreography.ResultSet);
exports.SearchLocationsByAddress = SearchLocationsByAddress;

