
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CopyFileOrFolder
    Copies a file or folder to a new location in the Dropbox tree.
*/


var CopyFileOrFolder = function(session) {
    /*
        Create a new instance of the CopyFileOrFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/CopyFileOrFolder"
    CopyFileOrFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CopyFileOrFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CopyFileOrFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CopyFileOrFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CopyFileOrFolderInputSet = function() {
    CopyFileOrFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the FromCopyRef input for this Choreo. ((conditional, string) Specifies a CopyRef previously generated by running the CreateCopyRef choreo. If you specify this value, you must leave FromPath empty.)
        */
        this.set_FromCopyRef = function(value) {
            this.setInput("FromCopyRef", value);
        }

        /*
        Set the value of the FromPath input for this Choreo. ((conditional, string) Specifies the file or folder to be copied. If you specify this value, you must leave the FromCopyRef blank.)
        */
        this.set_FromPath = function(value) {
            this.setInput("FromPath", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

        /*
        Set the value of the ToPath input for this Choreo. ((required, string) Specifies the destination path, including the new name for the file or folder.)
        */
        this.set_ToPath = function(value) {
            this.setInput("ToPath", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CopyFileOrFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CopyFileOrFolderResultSet = function(resultStream) {
    CopyFileOrFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CopyFileOrFolder, choreography.Choreography);
util.inherits(CopyFileOrFolderInputSet, choreography.InputSet);
util.inherits(CopyFileOrFolderResultSet, choreography.ResultSet);
exports.CopyFileOrFolder = CopyFileOrFolder;


/*
    CreateFolder
    Creates a Dropbox folder.
*/


var CreateFolder = function(session) {
    /*
        Create a new instance of the CreateFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/CreateFolder"
    CreateFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateFolderInputSet = function() {
    CreateFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the NewFolderName input for this Choreo. ((required, string) The name of the new folder to create. A path with a root folder is also valid (i.e. /RootFolder/NewFolderName).)
        */
        this.set_NewFolderName = function(value) {
            this.setInput("NewFolderName", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateFolderResultSet = function(resultStream) {
    CreateFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateFolder, choreography.Choreography);
util.inherits(CreateFolderInputSet, choreography.InputSet);
util.inherits(CreateFolderResultSet, choreography.ResultSet);
exports.CreateFolder = CreateFolder;


/*
    DeleteFileOrFolder
    Deletes a Dropbox file or folder that you specify.
*/


var DeleteFileOrFolder = function(session) {
    /*
        Create a new instance of the DeleteFileOrFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/DeleteFileOrFolder"
    DeleteFileOrFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteFileOrFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteFileOrFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteFileOrFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteFileOrFolderInputSet = function() {
    DeleteFileOrFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path to the file or folder you want to delete (i.e. /RootFolder/SubFolder/FileToDelete.txt).)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteFileOrFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteFileOrFolderResultSet = function(resultStream) {
    DeleteFileOrFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteFileOrFolder, choreography.Choreography);
util.inherits(DeleteFileOrFolderInputSet, choreography.InputSet);
util.inherits(DeleteFileOrFolderResultSet, choreography.ResultSet);
exports.DeleteFileOrFolder = DeleteFileOrFolder;


/*
    MoveFileOrFolder
    Moves a file or folder to a new location in the Dropbox tree.
*/


var MoveFileOrFolder = function(session) {
    /*
        Create a new instance of the MoveFileOrFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/MoveFileOrFolder"
    MoveFileOrFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new MoveFileOrFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new MoveFileOrFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the MoveFileOrFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var MoveFileOrFolderInputSet = function() {
    MoveFileOrFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the FromPath input for this Choreo. ((required, string) Specifies the file or folder to be copied.)
        */
        this.set_FromPath = function(value) {
            this.setInput("FromPath", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

        /*
        Set the value of the ToPath input for this Choreo. ((required, string) Specifies the destination path, including the new name for the file or folder.)
        */
        this.set_ToPath = function(value) {
            this.setInput("ToPath", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the MoveFileOrFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var MoveFileOrFolderResultSet = function(resultStream) {
    MoveFileOrFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(MoveFileOrFolder, choreography.Choreography);
util.inherits(MoveFileOrFolderInputSet, choreography.InputSet);
util.inherits(MoveFileOrFolderResultSet, choreography.ResultSet);
exports.MoveFileOrFolder = MoveFileOrFolder;


/*
    ZipFile
    Creates a zipped version of the specified Dropbox file and returns a shareable link to the new compressed file.
*/


var ZipFile = function(session) {
    /*
        Create a new instance of the ZipFile Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/ZipFile"
    ZipFile.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ZipFileResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ZipFileInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ZipFile
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ZipFileInputSet = function() {
    ZipFileInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The name of the Dropbox file you want to zip.)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the Folder input for this Choreo. ((conditional, string) The name of the folder that contains the file you want to zip. A path to a sub-folder is also valid (i.e. RootFolder/SubFolder). Not required if the file is at the root level.)
        */
        this.set_Folder = function(value) {
            this.setInput("Folder", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

        /*
        Set the value of the ZipFileLocation input for this Choreo. ((optional, string) The name of the folder to put the new zip file in.A path to a sub-folder is also valid (i.e. RootFolder/SubFolder).  When not specified, the zip file will be put in the root folder.)
        */
        this.set_ZipFileLocation = function(value) {
            this.setInput("ZipFileLocation", value);
        }

        /*
        Set the value of the ZipFileName input for this Choreo. ((optional, string) The name of the zip file that will be created. If not specified, the original file name will be used with a .zip extension.)
        */
        this.set_ZipFileName = function(value) {
            this.setInput("ZipFileName", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ZipFile Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ZipFileResultSet = function(resultStream) {
    ZipFileResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The shared link for the new zip file.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
}

util.inherits(ZipFile, choreography.Choreography);
util.inherits(ZipFileInputSet, choreography.InputSet);
util.inherits(ZipFileResultSet, choreography.ResultSet);
exports.ZipFile = ZipFile;


/*
    ZipFolder
    Creates a zip file containing all files within the specified folder and returns a shareable link to the new compressed file.
*/


var ZipFolder = function(session) {
    /*
        Create a new instance of the ZipFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/FileOperations/ZipFolder"
    ZipFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ZipFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ZipFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ZipFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ZipFolderInputSet = function() {
    ZipFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccessTokenSecret input for this Choreo. ((required, string) The Access Token Secret retrieved during the OAuth process.)
        */
        this.set_AccessTokenSecret = function(value) {
            this.setInput("AccessTokenSecret", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the Folder input for this Choreo. ((required, string) The name of the folder that contains the files you want to retrieve and zip. A path to a sub-folder is also valid (i.e. RootFolder/SubFolder).)
        */
        this.set_Folder = function(value) {
            this.setInput("Folder", value);
        }

        /*
        Set the value of the Root input for this Choreo. ((optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).)
        */
        this.set_Root = function(value) {
            this.setInput("Root", value);
        }

        /*
        Set the value of the ZipFileLocation input for this Choreo. ((optional, string) The name of the folder to put the new zip file in. A path to a sub-folder is also valid (i.e. RootFolder/SubFolder). When not specified, the zip file will be put in the root folder.)
        */
        this.set_ZipFileLocation = function(value) {
            this.setInput("ZipFileLocation", value);
        }

        /*
        Set the value of the ZipFileName input for this Choreo. ((optional, string) The name of the zip file that will be created. If not specified, the original folder name containing the files to zip will be used with a .zip extension.)
        */
        this.set_ZipFileName = function(value) {
            this.setInput("ZipFileName", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ZipFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ZipFolderResultSet = function(resultStream) {
    ZipFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ()
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ZipFolder, choreography.Choreography);
util.inherits(ZipFolderInputSet, choreography.InputSet);
util.inherits(ZipFolderResultSet, choreography.ResultSet);
exports.ZipFolder = ZipFolder;

