
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Query
    Searches a user's Box account for items that match a specified keyword.
*/


var Query = function(session) {
    /*
        Create a new instance of the Query Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Box/Search/Query"
    Query.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new QueryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new QueryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Query
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var QueryInputSet = function() {
    QueryInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token retrieved during the OAuth2 process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AncestorFolderIDs input for this Choreo. ((optional, string) A comma-seperated list of folder IDs which are used to filter your search.)
        */
        this.set_AncestorFolderIDs = function(value) {
            this.setInput("AncestorFolderIDs", value);
        }

        /*
        Set the value of the AsUser input for this Choreo. ((optional, string) The ID of the user. Only used for enterprise administrators to make API calls for their managed users.)
        */
        this.set_AsUser = function(value) {
            this.setInput("AsUser", value);
        }

        /*
        Set the value of the ContentTypes input for this Choreo. ((optional, string) A comma-seperated list of content types used to filter your search.  Acceptable types are: name, description, file_content, comments, and tags.)
        */
        this.set_ContentTypes = function(value) {
            this.setInput("ContentTypes", value);
        }

        /*
        Set the value of the CreatedAtRange input for this Choreo. ((optional, date) A comma-seperated date range in ISO-8601 (2012-11-02T11:43:14-07:00) format used to filter your search.  Acceptable values are "from-date, to-date", "from-date, " and ", to-date".)
        */
        this.set_CreatedAtRange = function(value) {
            this.setInput("CreatedAtRange", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the FileExtensions input for this Choreo. ((optional, string) A comma-seperated list of extension types used to filter your search (e.g., pdf, png doc).)
        */
        this.set_FileExtensions = function(value) {
            this.setInput("FileExtensions", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of search results to return. Defaults to 30.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the MDFilters input for this Choreo. ((optional, string) Filters for a specific metadata template. Visit the metadata search documentation for more information (See Choreo notes for more details).)
        */
        this.set_MDFilters = function(value) {
            this.setInput("MDFilters", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) The search result at which to start the response. Defaults to 0.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the OwnerUserIDs input for this Choreo. ((optional, string) A comma-seperated list of owner IDs which are used to filter your search.)
        */
        this.set_OwnerUserIDs = function(value) {
            this.setInput("OwnerUserIDs", value);
        }

        /*
        Set the value of the Query input for this Choreo. ((required, string) The string to search for; can be matched against item names, descriptions, text content of a file, and other fields of the different item types.)
        */
        this.set_Query = function(value) {
            this.setInput("Query", value);
        }

        /*
        Set the value of the Scope input for this Choreo. ((optional, string) The scope for which you want to limit your search to. Can be user_content for a search limited to only the current user or enterprise_content for the entire enterprise.)
        */
        this.set_Scope = function(value) {
            this.setInput("Scope", value);
        }

        /*
        Set the value of the SizeRange input for this Choreo. ((optional, string) Filter by a file size range. Specify the file size range in bytes separated by a comma (e.g., 50, 100).)
        */
        this.set_SizeRange = function(value) {
            this.setInput("SizeRange", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The type you want to return in your search. Can be file, folder, or web_link.)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

        /*
        Set the value of the UpdatedAtRange input for this Choreo. ((optional, date) A comma-seperated date range in ISO-8601 (2012-11-02T11:43:14-07:00) format used to filter your search.  Acceptable values are "from-date, to-date", "from-date, " and ", to-date".)
        */
        this.set_UpdatedAtRange = function(value) {
            this.setInput("UpdatedAtRange", value);
        }

        /*
        Set the value of the VaultFile input for this Choreo. ((optional, vault file) The path to a vault file that you want to upload. Required unless using the FileContents input.)
        */

}

/*
A ResultSet with methods tailored to the values returned by the Query Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var QueryResultSet = function(resultStream) {
    QueryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Box.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Query, choreography.Choreography);
util.inherits(QueryInputSet, choreography.InputSet);
util.inherits(QueryResultSet, choreography.ResultSet);
exports.Query = Query;

