
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetPriceEstimates
    Returns an estimated price range for each product offered at a given location.
*/


var GetPriceEstimates = function(session) {
    /*
        Create a new instance of the GetPriceEstimates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Uber/Estimates/GetPriceEstimates"
    GetPriceEstimates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetPriceEstimatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetPriceEstimatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetPriceEstimates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetPriceEstimatesInputSet = function() {
    GetPriceEstimatesInputSet.super_.call(this);
        /*
        Set the value of the EndLatitude input for this Choreo. ((required, decimal) The latitude coordinate for the destination e.g., 40.650729.)
        */
        this.set_EndLatitude = function(value) {
            this.setInput("EndLatitude", value);
        }

        /*
        Set the value of the EndLongitude input for this Choreo. ((required, decimal) The longitude coordinate for the destination e.g., -74.009536.)
        */
        this.set_EndLongitude = function(value) {
            this.setInput("EndLongitude", value);
        }

        /*
        Set the value of the ServerToken input for this Choreo. ((required, string) The Sever Token provided by Uber.)
        */
        this.set_ServerToken = function(value) {
            this.setInput("ServerToken", value);
        }

        /*
        Set the value of the StartLatitude input for this Choreo. ((required, decimal) The latitude coordinate for the starting location e.g., 40.71863.)
        */
        this.set_StartLatitude = function(value) {
            this.setInput("StartLatitude", value);
        }

        /*
        Set the value of the StartLongitude input for this Choreo. ((required, decimal) The longitude coordinate for the starting location e.g., -74.005584.)
        */
        this.set_StartLongitude = function(value) {
            this.setInput("StartLongitude", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetPriceEstimates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetPriceEstimatesResultSet = function(resultStream) {
    GetPriceEstimatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Uber.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetPriceEstimates, choreography.Choreography);
util.inherits(GetPriceEstimatesInputSet, choreography.InputSet);
util.inherits(GetPriceEstimatesResultSet, choreography.ResultSet);
exports.GetPriceEstimates = GetPriceEstimates;


/*
    GetTimeEstimates
    Returns ETAs for all products offered at a given location.
*/


var GetTimeEstimates = function(session) {
    /*
        Create a new instance of the GetTimeEstimates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Uber/Estimates/GetTimeEstimates"
    GetTimeEstimates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTimeEstimatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTimeEstimatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTimeEstimates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTimeEstimatesInputSet = function() {
    GetTimeEstimatesInputSet.super_.call(this);
        /*
        Set the value of the CustomerID input for this Choreo. ((optional, string) The ID of a customer to be used for experience customization.)
        */
        this.set_CustomerID = function(value) {
            this.setInput("CustomerID", value);
        }

        /*
        Set the value of the ProductID input for this Choreo. ((optional, string) An ID representing a specific product for a given latitude and longitude.)
        */
        this.set_ProductID = function(value) {
            this.setInput("ProductID", value);
        }

        /*
        Set the value of the ServerToken input for this Choreo. ((required, string) The Sever Token provided by Uber.)
        */
        this.set_ServerToken = function(value) {
            this.setInput("ServerToken", value);
        }

        /*
        Set the value of the StartLatitude input for this Choreo. ((required, decimal) The latitude coordinate for the starting location e.g., 40.71863.)
        */
        this.set_StartLatitude = function(value) {
            this.setInput("StartLatitude", value);
        }

        /*
        Set the value of the StartLongitude input for this Choreo. ((required, decimal) The longitude coordinate for the starting location e.g., -74.005584.)
        */
        this.set_StartLongitude = function(value) {
            this.setInput("StartLongitude", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTimeEstimates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTimeEstimatesResultSet = function(resultStream) {
    GetTimeEstimatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Uber.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetTimeEstimates, choreography.Choreography);
util.inherits(GetTimeEstimatesInputSet, choreography.InputSet);
util.inherits(GetTimeEstimatesResultSet, choreography.ResultSet);
exports.GetTimeEstimates = GetTimeEstimates;

