
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetChannel
    Retrieves information for a specific channel.
*/


var GetChannel = function(session) {
    /*
        Create a new instance of the GetChannel Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Pusher/Channels/GetChannel"
    GetChannel.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetChannelResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetChannelInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetChannel
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetChannelInputSet = function() {
    GetChannelInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The application ID provided by Pusher.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The authenticaion key provided by Pusher.)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The authentication secret provided by Pusher.)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the ChannelName input for this Choreo. ((required, string) The name of the channel to retrieve.)
        */
        this.set_ChannelName = function(value) {
            this.setInput("ChannelName", value);
        }

        /*
        Set the value of the Info input for this Choreo. ((optional, string) A comma separated list of attributes which should be returned for the channel (e.g., user_count, subscription_count). Note that the user_count attribute is only applicable for presence channels.)
        */
        this.set_Info = function(value) {
            this.setInput("Info", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetChannel Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetChannelResultSet = function(resultStream) {
    GetChannelResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Pusher.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetChannel, choreography.Choreography);
util.inherits(GetChannelInputSet, choreography.InputSet);
util.inherits(GetChannelResultSet, choreography.ResultSet);
exports.GetChannel = GetChannel;


/*
    ListChannels
    Retrieves information for occupied channels.
*/


var ListChannels = function(session) {
    /*
        Create a new instance of the ListChannels Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Pusher/Channels/ListChannels"
    ListChannels.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListChannelsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListChannelsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListChannels
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListChannelsInputSet = function() {
    ListChannelsInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The application ID provided by Pusher.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The authenticaion key provided by Pusher.)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The authentication secret provided by Pusher.)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the FilterByPrefix input for this Choreo. ((optional, string) Filter the returned channels by a specific prefix (e.g. "presence-").)
        */
        this.set_FilterByPrefix = function(value) {
            this.setInput("FilterByPrefix", value);
        }

        /*
        Set the value of the Info input for this Choreo. ((optional, string) A comma separated list of attributes which should be returned for each channel (e.g., user_count). Note that the user_count attribute is only applicable for presence channels.)
        */
        this.set_Info = function(value) {
            this.setInput("Info", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListChannels Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListChannelsResultSet = function(resultStream) {
    ListChannelsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Pusher.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListChannels, choreography.Choreography);
util.inherits(ListChannelsInputSet, choreography.InputSet);
util.inherits(ListChannelsResultSet, choreography.ResultSet);
exports.ListChannels = ListChannels;

