
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ConfigureGraph
    Creates, modifies, or styles a graph.
*/


var ConfigureGraph = function(session) {
    /*
        Create a new instance of the ConfigureGraph Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/ConfigureGraph"
    ConfigureGraph.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ConfigureGraphResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ConfigureGraphInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ConfigureGraph
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ConfigureGraphInputSet = function() {
    ConfigureGraphInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the FileOption input for this Choreo. ((required, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details.)
        */
        this.set_FileOption = function(value) {
            this.setInput("FileOption", value);
        }

        /*
        Set the value of the GraphArguments input for this Choreo. ((conditional, json) The data and/or styling arguments. Typically, this is in the form of a JSON array where x and y are represented as arrays of numbers or strings. See Choreo description for more details.)
        */
        this.set_GraphArguments = function(value) {
            this.setInput("GraphArguments", value);
        }

        /*
        Set the value of the Layout input for this Choreo. ((optional, json) A key-value paired JSON object that describes the layout of the plot (e.g., {"title": "Sensor Data"}).)
        */
        this.set_Layout = function(value) {
            this.setInput("Layout", value);
        }

        /*
        Set the value of the Origin input for this Choreo. ((optional, string) Specifies the type of call and the type of data in the Arguments parameter. Valid values are: plot (the default), style, or layout.)
        */
        this.set_Origin = function(value) {
            this.setInput("Origin", value);
        }

        /*
        Set the value of the Style input for this Choreo. ((optional, json) A JSON object describing the style of the graph (e.g., {"type": "bar"}). This can be applied to every single trace (default) or to the traces specified in the optional Traces input.)
        */
        this.set_Style = function(value) {
            this.setInput("Style", value);
        }

        /*
        Set the value of the Traces input for this Choreo. ((optional, json) Specifies the indices that the Style input object should be applied to. This should be formatted as a JSON array.)
        */
        this.set_Traces = function(value) {
            this.setInput("Traces", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ConfigureGraph Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ConfigureGraphResultSet = function(resultStream) {
    ConfigureGraphResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ConfigureGraph, choreography.Choreography);
util.inherits(ConfigureGraphInputSet, choreography.InputSet);
util.inherits(ConfigureGraphResultSet, choreography.ResultSet);
exports.ConfigureGraph = ConfigureGraph;


/*
    ExtendBarGraph
    Extends the specified bar graph by plotting a single addition point.
*/


var ExtendBarGraph = function(session) {
    /*
        Create a new instance of the ExtendBarGraph Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/ExtendBarGraph"
    ExtendBarGraph.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ExtendBarGraphResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ExtendBarGraphInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ExtendBarGraph
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ExtendBarGraphInputSet = function() {
    ExtendBarGraphInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValue input for this Choreo. ((required, any) The "x" coordinate value to be plotted on the graph.)
        */
        this.set_XValue = function(value) {
            this.setInput("XValue", value);
        }

        /*
        Set the value of the YValue input for this Choreo. ((required, any) The "y" coordinate value to be plotted on the graph.)
        */
        this.set_YValue = function(value) {
            this.setInput("YValue", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ExtendBarGraph Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ExtendBarGraphResultSet = function(resultStream) {
    ExtendBarGraphResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ExtendBarGraph, choreography.Choreography);
util.inherits(ExtendBarGraphInputSet, choreography.InputSet);
util.inherits(ExtendBarGraphResultSet, choreography.ResultSet);
exports.ExtendBarGraph = ExtendBarGraph;


/*
    ExtendLineGraph
    Extends the specified line graph by plotting a single addition point.
*/


var ExtendLineGraph = function(session) {
    /*
        Create a new instance of the ExtendLineGraph Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/ExtendLineGraph"
    ExtendLineGraph.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ExtendLineGraphResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ExtendLineGraphInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ExtendLineGraph
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ExtendLineGraphInputSet = function() {
    ExtendLineGraphInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValue input for this Choreo. ((required, any) The "x" coordinate value to be plotted on the graph.)
        */
        this.set_XValue = function(value) {
            this.setInput("XValue", value);
        }

        /*
        Set the value of the YValue input for this Choreo. ((required, any) The "y" coordinate value to be plotted on the graph.)
        */
        this.set_YValue = function(value) {
            this.setInput("YValue", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ExtendLineGraph Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ExtendLineGraphResultSet = function(resultStream) {
    ExtendLineGraphResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ExtendLineGraph, choreography.Choreography);
util.inherits(ExtendLineGraphInputSet, choreography.InputSet);
util.inherits(ExtendLineGraphResultSet, choreography.ResultSet);
exports.ExtendLineGraph = ExtendLineGraph;


/*
    ExtendTimeSeries
    Extends the specified time series graph by plotting a single addition point.
*/


var ExtendTimeSeries = function(session) {
    /*
        Create a new instance of the ExtendTimeSeries Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/ExtendTimeSeries"
    ExtendTimeSeries.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ExtendTimeSeriesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ExtendTimeSeriesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ExtendTimeSeries
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ExtendTimeSeriesInputSet = function() {
    ExtendTimeSeriesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) If a value is not passed to the Timestamp input, the current is generated for you. When using this feature, you can indicate the desired time zone using this input. The default TimeZone is UTC.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValue input for this Choreo. ((conditional, date) The "x" coordinate timestamp to be plotted on the graph in the format YYYY-MM-DD HH:MM:SS. If not provided, this defaults to NOW().)
        */
        this.set_XValue = function(value) {
            this.setInput("XValue", value);
        }

        /*
        Set the value of the YValue input for this Choreo. ((required, string) The "y" coordinate value associated with the specified timestamp.)
        */
        this.set_YValue = function(value) {
            this.setInput("YValue", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ExtendTimeSeries Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ExtendTimeSeriesResultSet = function(resultStream) {
    ExtendTimeSeriesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ExtendTimeSeries, choreography.Choreography);
util.inherits(ExtendTimeSeriesInputSet, choreography.InputSet);
util.inherits(ExtendTimeSeriesResultSet, choreography.ResultSet);
exports.ExtendTimeSeries = ExtendTimeSeries;


/*
    PlotBarGraph
    Plots an array of points on a bar graph.
*/


var PlotBarGraph = function(session) {
    /*
        Create a new instance of the PlotBarGraph Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/PlotBarGraph"
    PlotBarGraph.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PlotBarGraphResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PlotBarGraphInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PlotBarGraph
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PlotBarGraphInputSet = function() {
    PlotBarGraphInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the FileOption input for this Choreo. ((optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".)
        */
        this.set_FileOption = function(value) {
            this.setInput("FileOption", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValues input for this Choreo. ((required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.)
        */
        this.set_XValues = function(value) {
            this.setInput("XValues", value);
        }

        /*
        Set the value of the YValues input for this Choreo. ((required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.)
        */
        this.set_YValues = function(value) {
            this.setInput("YValues", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PlotBarGraph Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PlotBarGraphResultSet = function(resultStream) {
    PlotBarGraphResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PlotBarGraph, choreography.Choreography);
util.inherits(PlotBarGraphInputSet, choreography.InputSet);
util.inherits(PlotBarGraphResultSet, choreography.ResultSet);
exports.PlotBarGraph = PlotBarGraph;


/*
    PlotLineGraph
    Plots an array of points on a line graph.
*/


var PlotLineGraph = function(session) {
    /*
        Create a new instance of the PlotLineGraph Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/PlotLineGraph"
    PlotLineGraph.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PlotLineGraphResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PlotLineGraphInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PlotLineGraph
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PlotLineGraphInputSet = function() {
    PlotLineGraphInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the FileOption input for this Choreo. ((optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".)
        */
        this.set_FileOption = function(value) {
            this.setInput("FileOption", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValues input for this Choreo. ((required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.)
        */
        this.set_XValues = function(value) {
            this.setInput("XValues", value);
        }

        /*
        Set the value of the YValues input for this Choreo. ((required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.)
        */
        this.set_YValues = function(value) {
            this.setInput("YValues", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PlotLineGraph Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PlotLineGraphResultSet = function(resultStream) {
    PlotLineGraphResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PlotLineGraph, choreography.Choreography);
util.inherits(PlotLineGraphInputSet, choreography.InputSet);
util.inherits(PlotLineGraphResultSet, choreography.ResultSet);
exports.PlotLineGraph = PlotLineGraph;


/*
    PlotTimeSeries
    Plots an array of time series data on a graph.
*/


var PlotTimeSeries = function(session) {
    /*
        Create a new instance of the PlotTimeSeries Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Plotly/PlotTimeSeries"
    PlotTimeSeries.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PlotTimeSeriesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PlotTimeSeriesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PlotTimeSeries
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PlotTimeSeriesInputSet = function() {
    PlotTimeSeriesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Plotly.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the FileName input for this Choreo. ((required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).)
        */
        this.set_FileName = function(value) {
            this.setInput("FileName", value);
        }

        /*
        Set the value of the FileOption input for this Choreo. ((optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".)
        */
        this.set_FileOption = function(value) {
            this.setInput("FileOption", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) The title of the graph.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) A valid Plotly username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the WorldReadable input for this Choreo. ((optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.)
        */
        this.set_WorldReadable = function(value) {
            this.setInput("WorldReadable", value);
        }

        /*
        Set the value of the XValues input for this Choreo. ((required, json) A JSON array of timestamps representing the "x" coordinates to be plotted on the graph. Timestamps should be formatted as YYYY-MM-DD HH:MM:SS.)
        */
        this.set_XValues = function(value) {
            this.setInput("XValues", value);
        }

        /*
        Set the value of the YValues input for this Choreo. ((required, json) A  JSON array of values representing the "y" coordinates associated with the specified timestamps.)
        */
        this.set_YValues = function(value) {
            this.setInput("YValues", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PlotTimeSeries Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PlotTimeSeriesResultSet = function(resultStream) {
    PlotTimeSeriesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URL" output from this Choreo execution. ((string) The Plotly URL for the graph.)
        */
        this.get_URL = function() {
            return this.getResult("URL");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Plotly)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PlotTimeSeries, choreography.Choreography);
util.inherits(PlotTimeSeriesInputSet, choreography.InputSet);
util.inherits(PlotTimeSeriesResultSet, choreography.ResultSet);
exports.PlotTimeSeries = PlotTimeSeries;

