
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AcknowledgeEvent
    Updates the state of an incident to "acknowleged", and allows you to log data to an incident log.
*/


var AcknowledgeEvent = function(session) {
    /*
        Create a new instance of the AcknowledgeEvent Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Events/AcknowledgeEvent"
    AcknowledgeEvent.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AcknowledgeEventResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AcknowledgeEventInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AcknowledgeEvent
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AcknowledgeEventInputSet = function() {
    AcknowledgeEventInputSet.super_.call(this);
        /*
        Set the value of the Description input for this Choreo. ((optional, string) A short description that will appear in the incident's log associated with this event.)
        */
        this.set_Description = function(value) {
            this.setInput("Description", value);
        }

        /*
        Set the value of the Details input for this Choreo. ((optional, json) A JSON object containing any data you'd like included in the incident log.)
        */
        this.set_Details = function(value) {
            this.setInput("Details", value);
        }

        /*
        Set the value of the IncidentKey input for this Choreo. ((required, string) Identifies the incident to acknowledge.)
        */
        this.set_IncidentKey = function(value) {
            this.setInput("IncidentKey", value);
        }

        /*
        Set the value of the ServiceKey input for this Choreo. ((required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.)
        */
        this.set_ServiceKey = function(value) {
            this.setInput("ServiceKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AcknowledgeEvent Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AcknowledgeEventResultSet = function(resultStream) {
    AcknowledgeEventResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AcknowledgeEvent, choreography.Choreography);
util.inherits(AcknowledgeEventInputSet, choreography.InputSet);
util.inherits(AcknowledgeEventResultSet, choreography.ResultSet);
exports.AcknowledgeEvent = AcknowledgeEvent;


/*
    ResolveEvent
    Updates the state of an incident to "resolved", and allows you to log data to an incident log.
*/


var ResolveEvent = function(session) {
    /*
        Create a new instance of the ResolveEvent Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Events/ResolveEvent"
    ResolveEvent.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ResolveEventResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ResolveEventInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ResolveEvent
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ResolveEventInputSet = function() {
    ResolveEventInputSet.super_.call(this);
        /*
        Set the value of the Description input for this Choreo. ((optional, string) A short description that will appear in the incident's log associated with this event.)
        */
        this.set_Description = function(value) {
            this.setInput("Description", value);
        }

        /*
        Set the value of the Details input for this Choreo. ((optional, json) A JSON object containing any data you'd like included in the incident log.)
        */
        this.set_Details = function(value) {
            this.setInput("Details", value);
        }

        /*
        Set the value of the IncidentKey input for this Choreo. ((required, string) Identifies the incident to resolve.)
        */
        this.set_IncidentKey = function(value) {
            this.setInput("IncidentKey", value);
        }

        /*
        Set the value of the ServiceKey input for this Choreo. ((required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.)
        */
        this.set_ServiceKey = function(value) {
            this.setInput("ServiceKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ResolveEvent Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ResolveEventResultSet = function(resultStream) {
    ResolveEventResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ResolveEvent, choreography.Choreography);
util.inherits(ResolveEventInputSet, choreography.InputSet);
util.inherits(ResolveEventResultSet, choreography.ResultSet);
exports.ResolveEvent = ResolveEvent;


/*
    TriggerEvent
    Triggers an event that will open a new incident or log an entry to an existing incident.
*/


var TriggerEvent = function(session) {
    /*
        Create a new instance of the TriggerEvent Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Events/TriggerEvent"
    TriggerEvent.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TriggerEventResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TriggerEventInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TriggerEvent
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TriggerEventInputSet = function() {
    TriggerEventInputSet.super_.call(this);
        /*
        Set the value of the Description input for this Choreo. ((required, string) A short description of the problem that led to this trigger. The maximum length is 1024 characters.)
        */
        this.set_Description = function(value) {
            this.setInput("Description", value);
        }

        /*
        Set the value of the Details input for this Choreo. ((required, json) A JSON object containing the data you'd like included in the incident log.)
        */
        this.set_Details = function(value) {
            this.setInput("Details", value);
        }

        /*
        Set the value of the IncidentKey input for this Choreo. ((optional, string) Identifies the incident to which this trigger event should be applied. If there's no open incident with this key, a new one will be created.)
        */
        this.set_IncidentKey = function(value) {
            this.setInput("IncidentKey", value);
        }

        /*
        Set the value of the ServiceKey input for this Choreo. ((required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.)
        */
        this.set_ServiceKey = function(value) {
            this.setInput("ServiceKey", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TriggerEvent Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TriggerEventResultSet = function(resultStream) {
    TriggerEventResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TriggerEvent, choreography.Choreography);
util.inherits(TriggerEventInputSet, choreography.InputSet);
util.inherits(TriggerEventResultSet, choreography.ResultSet);
exports.TriggerEvent = TriggerEvent;

