
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    PropertyData
    Gets unique, total, or average data for of a single event and property over the last N days, weeks, or months.
*/


var PropertyData = function(session) {
    /*
        Create a new instance of the PropertyData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Properties/PropertyData"
    PropertyData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PropertyDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PropertyDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PropertyData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PropertyDataInputSet = function() {
    PropertyDataInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The name of the event that you wish to get data for.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Interval input for this Choreo. ((required, integer) The time interval to return. This relates to the value provided for Unit.)
        */
        this.set_Interval = function(value) {
            this.setInput("Interval", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of values to return. Defaults to 255.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the PropertyName input for this Choreo. ((required, string) The name of the property you would like to get data for.)
        */
        this.set_PropertyName = function(value) {
            this.setInput("PropertyName", value);
        }

        /*
        Set the value of the PropertyValues input for this Choreo. ((optional, json) A JSON array containing property values that you wish to retrieve.)
        */
        this.set_PropertyValues = function(value) {
            this.setInput("PropertyValues", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and csv.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((required, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((required, string) The granularity of the data to return. Valid values are: minute, hour, day, week, or month.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PropertyData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PropertyDataResultSet = function(resultStream) {
    PropertyDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PropertyData, choreography.Choreography);
util.inherits(PropertyDataInputSet, choreography.InputSet);
util.inherits(PropertyDataResultSet, choreography.ResultSet);
exports.PropertyData = PropertyData;


/*
    TopProperties
    Gets the top property names for an event.
*/


var TopProperties = function(session) {
    /*
        Create a new instance of the TopProperties Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Properties/TopProperties"
    TopProperties.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TopPropertiesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TopPropertiesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TopProperties
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TopPropertiesInputSet = function() {
    TopPropertiesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The name of the event that you wish to get data for.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of properties to return. Defaults to 10.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TopProperties Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TopPropertiesResultSet = function(resultStream) {
    TopPropertiesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TopProperties, choreography.Choreography);
util.inherits(TopPropertiesInputSet, choreography.InputSet);
util.inherits(TopPropertiesResultSet, choreography.ResultSet);
exports.TopProperties = TopProperties;


/*
    TopValues
    Gets the top values for a property.
*/


var TopValues = function(session) {
    /*
        Create a new instance of the TopValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Properties/TopValues"
    TopValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TopValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TopValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TopValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TopValuesInputSet = function() {
    TopValuesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The name of the event that you wish to get data for.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of values to return. Defaults to 255.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the PropertyName input for this Choreo. ((required, string) The name of the property you would like to get data for.)
        */
        this.set_PropertyName = function(value) {
            this.setInput("PropertyName", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TopValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TopValuesResultSet = function(resultStream) {
    TopValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TopValues, choreography.Choreography);
util.inherits(TopValuesInputSet, choreography.InputSet);
util.inherits(TopValuesResultSet, choreography.ResultSet);
exports.TopValues = TopValues;

