
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Engage
    Queries Mixpanel for data about people.
*/


var Engage = function(session) {
    /*
        Create a new instance of the Engage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/People/Engage"
    Engage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new EngageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new EngageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Engage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var EngageInputSet = function() {
    EngageInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Page input for this Choreo. ((optional, integer) Which page of the results to retrieve. Pages start at zero. If the "page" parameter is provided, the session_id parameter must also be provided.)
        */
        this.set_Page = function(value) {
            this.setInput("Page", value);
        }

        /*
        Set the value of the SessionID input for this Choreo. ((optional, string) A string id provided in the results of a previous query. Using a session_id speeds up api response, and allows paging through results.)
        */
        this.set_SessionID = function(value) {
            this.setInput("SessionID", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter people by (e.g., properties["time"]). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Engage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var EngageResultSet = function(resultStream) {
    EngageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Engage, choreography.Choreography);
util.inherits(EngageInputSet, choreography.InputSet);
util.inherits(EngageResultSet, choreography.ResultSet);
exports.Engage = Engage;

