
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddWorksheet
    Adds a new worksheet to the workbook.
*/


var AddWorksheet = function(session) {
    /*
        Create a new instance of the AddWorksheet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Worksheet/AddWorksheet"
    AddWorksheet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddWorksheetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddWorksheetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddWorksheet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddWorksheetInputSet = function() {
    AddWorksheetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name of the new worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddWorksheet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddWorksheetResultSet = function(resultStream) {
    AddWorksheetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddWorksheet, choreography.Choreography);
util.inherits(AddWorksheetInputSet, choreography.InputSet);
util.inherits(AddWorksheetResultSet, choreography.ResultSet);
exports.AddWorksheet = AddWorksheet;


/*
    GetWorksheet
    Retrieve the properties and relationships of worksheet object.
*/


var GetWorksheet = function(session) {
    /*
        Create a new instance of the GetWorksheet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Worksheet/GetWorksheet"
    GetWorksheet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetWorksheetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetWorksheetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetWorksheet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetWorksheetInputSet = function() {
    GetWorksheetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetWorksheet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetWorksheetResultSet = function(resultStream) {
    GetWorksheetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetWorksheet, choreography.Choreography);
util.inherits(GetWorksheetInputSet, choreography.InputSet);
util.inherits(GetWorksheetResultSet, choreography.ResultSet);
exports.GetWorksheet = GetWorksheet;


/*
    ListWorksheets
    Retrieve a list of worksheet objects.
*/


var ListWorksheets = function(session) {
    /*
        Create a new instance of the ListWorksheets Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Worksheet/ListWorksheets"
    ListWorksheets.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListWorksheetsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListWorksheetsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListWorksheets
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListWorksheetsInputSet = function() {
    ListWorksheetsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Skip input for this Choreo. ((optional, integer) The number of items to skip in a result set.)
        */
        this.set_Skip = function(value) {
            this.setInput("Skip", value);
        }

        /*
        Set the value of the Top input for this Choreo. ((optional, integer) The number of items to return in a result set.)
        */
        this.set_Top = function(value) {
            this.setInput("Top", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListWorksheets Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListWorksheetsResultSet = function(resultStream) {
    ListWorksheetsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListWorksheets, choreography.Choreography);
util.inherits(ListWorksheetsInputSet, choreography.InputSet);
util.inherits(ListWorksheetsResultSet, choreography.ResultSet);
exports.ListWorksheets = ListWorksheets;

