
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddTags
    Adds one or more tags to an object, up to a limit of 10. 
*/


var AddTags = function(session) {
    /*
        Create a new instance of the AddTags Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/AddTags"
    AddTags.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddTagsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddTagsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddTags
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddTagsInputSet = function() {
    AddTagsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ResourceId input for this Choreo. ((required, string) The ID of the ML object to tag.)
        */
        this.set_ResourceId = function(value) {
            this.setInput("ResourceId", value);
        }

        /*
        Set the value of the ResourceType input for this Choreo. ((required, string) The type of the ML object to tag. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.)
        */
        this.set_ResourceType = function(value) {
            this.setInput("ResourceType", value);
        }

        /*
        Set the value of the Tags input for this Choreo. ((required, json) An array of tag objects in a key-value pair format.)
        */
        this.set_Tags = function(value) {
            this.setInput("Tags", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddTags Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddTagsResultSet = function(resultStream) {
    AddTagsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddTags, choreography.Choreography);
util.inherits(AddTagsInputSet, choreography.InputSet);
util.inherits(AddTagsResultSet, choreography.ResultSet);
exports.AddTags = AddTags;


/*
    CreateBatchPrediction
    Generates predictions for a group of observations.
*/


var CreateBatchPrediction = function(session) {
    /*
        Create a new instance of the CreateBatchPrediction Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/CreateBatchPrediction"
    CreateBatchPrediction.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateBatchPredictionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateBatchPredictionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateBatchPrediction
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateBatchPredictionInputSet = function() {
    CreateBatchPredictionInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the BatchPredictionDataSourceId input for this Choreo. ((required, string) The ID of the DataSource that points to the group of observations to predict.)
        */
        this.set_BatchPredictionDataSourceId = function(value) {
            this.setInput("BatchPredictionDataSourceId", value);
        }

        /*
        Set the value of the BatchPredictionId input for this Choreo. ((required, string) A user-supplied ID that uniquely identifies the BatchPrediction.)
        */
        this.set_BatchPredictionId = function(value) {
            this.setInput("BatchPredictionId", value);
        }

        /*
        Set the value of the BatchPredictionName input for this Choreo. ((optional, string) A user-supplied name or description of the BatchPrediction.)
        */
        this.set_BatchPredictionName = function(value) {
            this.setInput("BatchPredictionName", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID of the MLModel that will generate predictions for the group of observations.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the OutputUri input for this Choreo. ((required, string) The location of an Amazon S3 bucket or directory to store the batch prediction results.)
        */
        this.set_OutputUri = function(value) {
            this.setInput("OutputUri", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateBatchPrediction Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateBatchPredictionResultSet = function(resultStream) {
    CreateBatchPredictionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateBatchPrediction, choreography.Choreography);
util.inherits(CreateBatchPredictionInputSet, choreography.InputSet);
util.inherits(CreateBatchPredictionResultSet, choreography.ResultSet);
exports.CreateBatchPrediction = CreateBatchPrediction;


/*
    CreateDataSourceFromS3
    Creates a DataSource object.
*/


var CreateDataSourceFromS3 = function(session) {
    /*
        Create a new instance of the CreateDataSourceFromS3 Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/CreateDataSourceFromS3"
    CreateDataSourceFromS3.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateDataSourceFromS3ResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateDataSourceFromS3InputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateDataSourceFromS3
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateDataSourceFromS3InputSet = function() {
    CreateDataSourceFromS3InputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ComputeStatistics input for this Choreo. ((optional, boolean) The compute statistics for a DataSource. This parameter must be set to true if the DataSource needs to be used for MLModel training. Defaults to false.)
        */
        this.set_ComputeStatistics = function(value) {
            this.setInput("ComputeStatistics", value);
        }

        /*
        Set the value of the DataLocationS3 input for this Choreo. ((required, string) The location of the data file(s) used by a DataSource. The URI specifies a data file or an Amazon Simple Storage Service (Amazon S3) directory or bucket containing data files.)
        */
        this.set_DataLocationS3 = function(value) {
            this.setInput("DataLocationS3", value);
        }

        /*
        Set the value of the DataRearrangement input for this Choreo. ((optional, json) A JSON string that represents the splitting and rearrangement requirements for the Datasource.)
        */
        this.set_DataRearrangement = function(value) {
            this.setInput("DataRearrangement", value);
        }

        /*
        Set the value of the DataSchema input for this Choreo. ((optional, json) A JSON string representing the schema. This is required unless specifying a valid URI for DataSchemaLocationS3.)
        */
        this.set_DataSchema = function(value) {
            this.setInput("DataSchema", value);
        }

        /*
        Set the value of the DataSchemaLocationS3 input for this Choreo. ((conditional, string) The Amazon S3 location of the DataSchema. This is required unless specifying a valid JSON schema file for DataSchema (see optional inputs).)
        */
        this.set_DataSchemaLocationS3 = function(value) {
            this.setInput("DataSchemaLocationS3", value);
        }

        /*
        Set the value of the DataSourceId input for this Choreo. ((required, string) A user-supplied identifier that uniquely identifies the DataSource.)
        */
        this.set_DataSourceId = function(value) {
            this.setInput("DataSourceId", value);
        }

        /*
        Set the value of the DataSourceName input for this Choreo. ((optional, string) A user-supplied name or description of the DataSource.)
        */
        this.set_DataSourceName = function(value) {
            this.setInput("DataSourceName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateDataSourceFromS3 Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateDataSourceFromS3ResultSet = function(resultStream) {
    CreateDataSourceFromS3ResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateDataSourceFromS3, choreography.Choreography);
util.inherits(CreateDataSourceFromS3InputSet, choreography.InputSet);
util.inherits(CreateDataSourceFromS3ResultSet, choreography.ResultSet);
exports.CreateDataSourceFromS3 = CreateDataSourceFromS3;


/*
    CreateEvaluation
    Creates a new Evaluation of an MLModel.
*/


var CreateEvaluation = function(session) {
    /*
        Create a new instance of the CreateEvaluation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/CreateEvaluation"
    CreateEvaluation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateEvaluationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateEvaluationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateEvaluation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateEvaluationInputSet = function() {
    CreateEvaluationInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EvaluationDataSourceId input for this Choreo. ((required, string) The DataSource that points to the training data.)
        */
        this.set_EvaluationDataSourceId = function(value) {
            this.setInput("EvaluationDataSourceId", value);
        }

        /*
        Set the value of the EvaluationId input for this Choreo. ((required, string) A user-supplied identifier that uniquely identifies the MLModel.)
        */
        this.set_EvaluationId = function(value) {
            this.setInput("EvaluationId", value);
        }

        /*
        Set the value of the EvaluationName input for this Choreo. ((optional, string) A user-supplied name or description of the MLModel.)
        */
        this.set_EvaluationName = function(value) {
            this.setInput("EvaluationName", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID of the MLModel to evaluate.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateEvaluation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateEvaluationResultSet = function(resultStream) {
    CreateEvaluationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateEvaluation, choreography.Choreography);
util.inherits(CreateEvaluationInputSet, choreography.InputSet);
util.inherits(CreateEvaluationResultSet, choreography.ResultSet);
exports.CreateEvaluation = CreateEvaluation;


/*
    CreateMLModel
    Creates a new MLModel using the DataSource and the recipe as information sources.
*/


var CreateMLModel = function(session) {
    /*
        Create a new instance of the CreateMLModel Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/CreateMLModel"
    CreateMLModel.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateMLModelResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateMLModelInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateMLModel
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateMLModelInputSet = function() {
    CreateMLModelInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) A user-supplied identifier that uniquely identifies the MLModel.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the MLModelName input for this Choreo. ((optional, string) A user-supplied name or description of the MLModel.)
        */
        this.set_MLModelName = function(value) {
            this.setInput("MLModelName", value);
        }

        /*
        Set the value of the MLModelType input for this Choreo. ((required, string) The category of supervised learning that this MLModel will address. Choose from the following types: REGRESSION, BINARY, MULTICLASS.)
        */
        this.set_MLModelType = function(value) {
            this.setInput("MLModelType", value);
        }

        /*
        Set the value of the Parameters input for this Choreo. ((optional, json) A list of the training parameters in the MLModel. The list is implemented as a map of key-value pairs.)
        */
        this.set_Parameters = function(value) {
            this.setInput("Parameters", value);
        }

        /*
        Set the value of the Recipe input for this Choreo. ((optional, string) The data recipe for creating the MLModel. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.)
        */
        this.set_Recipe = function(value) {
            this.setInput("Recipe", value);
        }

        /*
        Set the value of the RecipeUri input for this Choreo. ((optional, string) The Amazon S3 location and file name that contains the MLModel recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.)
        */
        this.set_RecipeUri = function(value) {
            this.setInput("RecipeUri", value);
        }

        /*
        Set the value of the TrainingDataSourceId input for this Choreo. ((required, string) The DataSource that points to the training data.)
        */
        this.set_TrainingDataSourceId = function(value) {
            this.setInput("TrainingDataSourceId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateMLModel Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateMLModelResultSet = function(resultStream) {
    CreateMLModelResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateMLModel, choreography.Choreography);
util.inherits(CreateMLModelInputSet, choreography.InputSet);
util.inherits(CreateMLModelResultSet, choreography.ResultSet);
exports.CreateMLModel = CreateMLModel;


/*
    CreateRealtimeEndpoint
    This Choreo creates a real-time endpoint for the MLModel. The endpoint contains the URI of the MLModel which is the location to send real-time prediction requests for the specified MLModel.
*/


var CreateRealtimeEndpoint = function(session) {
    /*
        Create a new instance of the CreateRealtimeEndpoint Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/CreateRealtimeEndpoint"
    CreateRealtimeEndpoint.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateRealtimeEndpointResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateRealtimeEndpointInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateRealtimeEndpoint
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateRealtimeEndpointInputSet = function() {
    CreateRealtimeEndpointInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID assigned to the MLModelId at creation.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateRealtimeEndpoint Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateRealtimeEndpointResultSet = function(resultStream) {
    CreateRealtimeEndpointResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateRealtimeEndpoint, choreography.Choreography);
util.inherits(CreateRealtimeEndpointInputSet, choreography.InputSet);
util.inherits(CreateRealtimeEndpointResultSet, choreography.ResultSet);
exports.CreateRealtimeEndpoint = CreateRealtimeEndpoint;


/*
    DeleteBatchPrediction
    Assigns the DELETED status to a BatchPrediction, rendering it unusable.
*/


var DeleteBatchPrediction = function(session) {
    /*
        Create a new instance of the DeleteBatchPrediction Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteBatchPrediction"
    DeleteBatchPrediction.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteBatchPredictionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteBatchPredictionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteBatchPrediction
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteBatchPredictionInputSet = function() {
    DeleteBatchPredictionInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the BatchPredictionId input for this Choreo. ((required, string) A user-supplied ID that uniquely identifies the BatchPrediction.)
        */
        this.set_BatchPredictionId = function(value) {
            this.setInput("BatchPredictionId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteBatchPrediction Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteBatchPredictionResultSet = function(resultStream) {
    DeleteBatchPredictionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteBatchPrediction, choreography.Choreography);
util.inherits(DeleteBatchPredictionInputSet, choreography.InputSet);
util.inherits(DeleteBatchPredictionResultSet, choreography.ResultSet);
exports.DeleteBatchPrediction = DeleteBatchPrediction;


/*
    DeleteDataSource
    Assigns the DELETED status to a DataSource, rendering it unusable.
*/


var DeleteDataSource = function(session) {
    /*
        Create a new instance of the DeleteDataSource Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteDataSource"
    DeleteDataSource.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteDataSourceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteDataSourceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteDataSource
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteDataSourceInputSet = function() {
    DeleteDataSourceInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the DataSourceId input for this Choreo. ((required, string) A user-supplied ID that uniquely identifies the DataSource.)
        */
        this.set_DataSourceId = function(value) {
            this.setInput("DataSourceId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteDataSource Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteDataSourceResultSet = function(resultStream) {
    DeleteDataSourceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteDataSource, choreography.Choreography);
util.inherits(DeleteDataSourceInputSet, choreography.InputSet);
util.inherits(DeleteDataSourceResultSet, choreography.ResultSet);
exports.DeleteDataSource = DeleteDataSource;


/*
    DeleteEvaluation
    Assigns the DELETED status to an Evaluation, rendering it unusable.
*/


var DeleteEvaluation = function(session) {
    /*
        Create a new instance of the DeleteEvaluation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteEvaluation"
    DeleteEvaluation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteEvaluationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteEvaluationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteEvaluation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteEvaluationInputSet = function() {
    DeleteEvaluationInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EvaluationId input for this Choreo. ((required, string) A user-supplied ID that uniquely identifies the Evaluation to delete.)
        */
        this.set_EvaluationId = function(value) {
            this.setInput("EvaluationId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteEvaluation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteEvaluationResultSet = function(resultStream) {
    DeleteEvaluationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteEvaluation, choreography.Choreography);
util.inherits(DeleteEvaluationInputSet, choreography.InputSet);
util.inherits(DeleteEvaluationResultSet, choreography.ResultSet);
exports.DeleteEvaluation = DeleteEvaluation;


/*
    DeleteMLModel
    Assigns the DELETED status to an MLModel, rendering it unusable.
*/


var DeleteMLModel = function(session) {
    /*
        Create a new instance of the DeleteMLModel Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteMLModel"
    DeleteMLModel.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteMLModelResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteMLModelInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteMLModel
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteMLModelInputSet = function() {
    DeleteMLModelInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID assigned to the MLModelId at creation.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteMLModel Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteMLModelResultSet = function(resultStream) {
    DeleteMLModelResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteMLModel, choreography.Choreography);
util.inherits(DeleteMLModelInputSet, choreography.InputSet);
util.inherits(DeleteMLModelResultSet, choreography.ResultSet);
exports.DeleteMLModel = DeleteMLModel;


/*
    DeleteRealtimeEndpoint
    Deletes a real time endpoint of an MLModel.
*/


var DeleteRealtimeEndpoint = function(session) {
    /*
        Create a new instance of the DeleteRealtimeEndpoint Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteRealtimeEndpoint"
    DeleteRealtimeEndpoint.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteRealtimeEndpointResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteRealtimeEndpointInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteRealtimeEndpoint
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteRealtimeEndpointInputSet = function() {
    DeleteRealtimeEndpointInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID assigned to the MLModelId at creation.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) Specifies whether the GetMLModel operation should return Recipe. Defaults to false.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteRealtimeEndpoint Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteRealtimeEndpointResultSet = function(resultStream) {
    DeleteRealtimeEndpointResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteRealtimeEndpoint, choreography.Choreography);
util.inherits(DeleteRealtimeEndpointInputSet, choreography.InputSet);
util.inherits(DeleteRealtimeEndpointResultSet, choreography.ResultSet);
exports.DeleteRealtimeEndpoint = DeleteRealtimeEndpoint;


/*
    DeleteTags
    Deletes the specified tags associated with an ML object.
*/


var DeleteTags = function(session) {
    /*
        Create a new instance of the DeleteTags Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DeleteTags"
    DeleteTags.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteTagsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteTagsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteTags
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteTagsInputSet = function() {
    DeleteTagsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ResourceId input for this Choreo. ((required, string) The ID of the ML object to tag.)
        */
        this.set_ResourceId = function(value) {
            this.setInput("ResourceId", value);
        }

        /*
        Set the value of the ResourceType input for this Choreo. ((required, string) The type of the ML object to tag. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.)
        */
        this.set_ResourceType = function(value) {
            this.setInput("ResourceType", value);
        }

        /*
        Set the value of the TagKeys input for this Choreo. ((required, json) One or more tags to delete.)
        */
        this.set_TagKeys = function(value) {
            this.setInput("TagKeys", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteTags Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteTagsResultSet = function(resultStream) {
    DeleteTagsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteTags, choreography.Choreography);
util.inherits(DeleteTagsInputSet, choreography.InputSet);
util.inherits(DeleteTagsResultSet, choreography.ResultSet);
exports.DeleteTags = DeleteTags;


/*
    DescribeDataSources
    Returns a list of DataSources that match the search criteria in the request.
*/


var DescribeDataSources = function(session) {
    /*
        Create a new instance of the DescribeDataSources Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DescribeDataSources"
    DescribeDataSources.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeDataSourcesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeDataSourcesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeDataSources
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeDataSourcesInputSet = function() {
    DescribeDataSourcesInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EQ input for this Choreo. ((optional, string) The equal to operator. The DataSource results will have FilterVariable values that exactly match the value specified with EQ.)
        */
        this.set_EQ = function(value) {
            this.setInput("EQ", value);
        }

        /*
        Set the value of the FilterVariable input for this Choreo. ((optional, string) Use one of the following variables to filter a list of DataSource: CreatedAt, Status, Name, DataUri, IAMUser.)
        */
        this.set_FilterVariable = function(value) {
            this.setInput("FilterVariable", value);
        }

        /*
        Set the value of the GE input for this Choreo. ((optional, string) The greater than or equal to operator. The DataSource results will have FilterVariable values that are greater than or equal to the value specified with GE.)
        */
        this.set_GE = function(value) {
            this.setInput("GE", value);
        }

        /*
        Set the value of the GT input for this Choreo. ((optional, string) The greater than operator. The DataSource results will have FilterVariable values that are greater than the value specified with GT.)
        */
        this.set_GT = function(value) {
            this.setInput("GT", value);
        }

        /*
        Set the value of the LE input for this Choreo. ((optional, string) The less than or equal to operator. The DataSource results will have FilterVariable values that are less than or equal to the value specified with LE.)
        */
        this.set_LE = function(value) {
            this.setInput("LE", value);
        }

        /*
        Set the value of the LT input for this Choreo. ((optional, string) The less than operator. The DataSource results will have FilterVariable values that are less than the value specified with LT.)
        */
        this.set_LT = function(value) {
            this.setInput("LT", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of DataSource to include in the result.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the NE input for this Choreo. ((optional, string) The not equal to operator. The DataSource results will have FilterVariable values not equal to the value specified with NE.)
        */
        this.set_NE = function(value) {
            this.setInput("NE", value);
        }

        /*
        Set the value of the NextToken input for this Choreo. ((optional, string) The ID of the page in the paginated results.)
        */
        this.set_NextToken = function(value) {
            this.setInput("NextToken", value);
        }

        /*
        Set the value of the Prefix input for this Choreo. ((optional, string) A string that is found at the beginning of a variable, such as Name or Id.)
        */
        this.set_Prefix = function(value) {
            this.setInput("Prefix", value);
        }

        /*
        Set the value of the SortOrder input for this Choreo. ((optional, string) Determines the sequence of the resulting list of DataSource. Valid values are: asc, dsc.)
        */
        this.set_SortOrder = function(value) {
            this.setInput("SortOrder", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeDataSources Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeDataSourcesResultSet = function(resultStream) {
    DescribeDataSourcesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeDataSources, choreography.Choreography);
util.inherits(DescribeDataSourcesInputSet, choreography.InputSet);
util.inherits(DescribeDataSourcesResultSet, choreography.ResultSet);
exports.DescribeDataSources = DescribeDataSources;


/*
    DescribeEvaluations
    Returns a list of Evaluations that match the search criteria in the request.
*/


var DescribeEvaluations = function(session) {
    /*
        Create a new instance of the DescribeEvaluations Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DescribeEvaluations"
    DescribeEvaluations.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeEvaluationsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeEvaluationsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeEvaluations
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeEvaluationsInputSet = function() {
    DescribeEvaluationsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EQ input for this Choreo. ((optional, string) The equal to operator. The Evaluation results will have FilterVariable values that exactly match the value specified with EQ.)
        */
        this.set_EQ = function(value) {
            this.setInput("EQ", value);
        }

        /*
        Set the value of the FilterVariable input for this Choreo. ((optional, string) Use one of the following variables to filter a list of Evaluation: CreatedAt, Status, Name, IAMUser, MLModelId, DataSourceId, DataUri.)
        */
        this.set_FilterVariable = function(value) {
            this.setInput("FilterVariable", value);
        }

        /*
        Set the value of the GE input for this Choreo. ((optional, string) The greater than or equal to operator. The Evaluation results will have FilterVariable values that are greater than or equal to the value specified with GE.)
        */
        this.set_GE = function(value) {
            this.setInput("GE", value);
        }

        /*
        Set the value of the GT input for this Choreo. ((optional, string) The greater than operator. The Evaluation results will have FilterVariable values that are greater than the value specified with GT.)
        */
        this.set_GT = function(value) {
            this.setInput("GT", value);
        }

        /*
        Set the value of the LE input for this Choreo. ((optional, string) The less than or equal to operator. The Evaluation results will have FilterVariable values that are less than or equal to the value specified with LE.)
        */
        this.set_LE = function(value) {
            this.setInput("LE", value);
        }

        /*
        Set the value of the LT input for this Choreo. ((optional, string) The less than operator. The Evaluation results will have FilterVariable values that are less than the value specified with LT.)
        */
        this.set_LT = function(value) {
            this.setInput("LT", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of Evaluation to include in the result.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the NE input for this Choreo. ((optional, string) The not equal to operator. The Evaluation results will have FilterVariable values not equal to the value specified with NE.)
        */
        this.set_NE = function(value) {
            this.setInput("NE", value);
        }

        /*
        Set the value of the NextToken input for this Choreo. ((optional, string) The ID of the page in the paginated results.)
        */
        this.set_NextToken = function(value) {
            this.setInput("NextToken", value);
        }

        /*
        Set the value of the Prefix input for this Choreo. ((optional, string) A string that is found at the beginning of a variable, such as Name or Id.)
        */
        this.set_Prefix = function(value) {
            this.setInput("Prefix", value);
        }

        /*
        Set the value of the SortOrder input for this Choreo. ((optional, string) Determines the sequence of the resulting list of Evaluation. Valid values are: asc, dsc.)
        */
        this.set_SortOrder = function(value) {
            this.setInput("SortOrder", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeEvaluations Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeEvaluationsResultSet = function(resultStream) {
    DescribeEvaluationsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeEvaluations, choreography.Choreography);
util.inherits(DescribeEvaluationsInputSet, choreography.InputSet);
util.inherits(DescribeEvaluationsResultSet, choreography.ResultSet);
exports.DescribeEvaluations = DescribeEvaluations;


/*
    DescribeMLModels
    Returns a list of MLModels that match the search criteria in the request.
*/


var DescribeMLModels = function(session) {
    /*
        Create a new instance of the DescribeMLModels Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DescribeMLModels"
    DescribeMLModels.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeMLModelsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeMLModelsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeMLModels
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeMLModelsInputSet = function() {
    DescribeMLModelsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EQ input for this Choreo. ((optional, string) The equal to operator. The MLModel results will have FilterVariable values that exactly match the value specified with EQ.)
        */
        this.set_EQ = function(value) {
            this.setInput("EQ", value);
        }

        /*
        Set the value of the FilterVariable input for this Choreo. ((optional, string) Use one of the following variables to filter a list of MLModel: CreatedAt, Status, Name, IAMUser, TrainingDataSourceId, RealtimeEndpointStatus, MLModelType, Algorithm, TrainingDataURI.)
        */
        this.set_FilterVariable = function(value) {
            this.setInput("FilterVariable", value);
        }

        /*
        Set the value of the GE input for this Choreo. ((optional, string) The greater than or equal to operator. The MLModel results will have FilterVariable values that are greater than or equal to the value specified with GE.)
        */
        this.set_GE = function(value) {
            this.setInput("GE", value);
        }

        /*
        Set the value of the GT input for this Choreo. ((optional, string) The greater than operator. The MLModel results will have FilterVariable values that are greater than the value specified with GT.)
        */
        this.set_GT = function(value) {
            this.setInput("GT", value);
        }

        /*
        Set the value of the LE input for this Choreo. ((optional, string) The less than or equal to operator. The MLModel results will have FilterVariable values that are less than or equal to the value specified with LE.)
        */
        this.set_LE = function(value) {
            this.setInput("LE", value);
        }

        /*
        Set the value of the LT input for this Choreo. ((optional, string) The less than operator. The MLModel results will have FilterVariable values that are less than the value specified with LT.)
        */
        this.set_LT = function(value) {
            this.setInput("LT", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of MLModel to include in the result.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the NE input for this Choreo. ((optional, string) The not equal to operator. The MLModel results will have FilterVariable values not equal to the value specified with NE.)
        */
        this.set_NE = function(value) {
            this.setInput("NE", value);
        }

        /*
        Set the value of the NextToken input for this Choreo. ((optional, string) The ID of the page in the paginated results.)
        */
        this.set_NextToken = function(value) {
            this.setInput("NextToken", value);
        }

        /*
        Set the value of the Prefix input for this Choreo. ((optional, string) A string that is found at the beginning of a variable, such as Name or Id.)
        */
        this.set_Prefix = function(value) {
            this.setInput("Prefix", value);
        }

        /*
        Set the value of the SortOrder input for this Choreo. ((optional, string) Determines the sequence of the resulting list of MLModel. Valid values are: asc, dsc.)
        */
        this.set_SortOrder = function(value) {
            this.setInput("SortOrder", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeMLModels Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeMLModelsResultSet = function(resultStream) {
    DescribeMLModelsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeMLModels, choreography.Choreography);
util.inherits(DescribeMLModelsInputSet, choreography.InputSet);
util.inherits(DescribeMLModelsResultSet, choreography.ResultSet);
exports.DescribeMLModels = DescribeMLModels;


/*
    DescribeTags
    Describes one or more of the tags for your Amazon ML object.
*/


var DescribeTags = function(session) {
    /*
        Create a new instance of the DescribeTags Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/DescribeTags"
    DescribeTags.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeTagsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeTagsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeTags
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeTagsInputSet = function() {
    DescribeTagsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ResourceId input for this Choreo. ((required, string) The ID of the ML object.)
        */
        this.set_ResourceId = function(value) {
            this.setInput("ResourceId", value);
        }

        /*
        Set the value of the ResourceType input for this Choreo. ((required, string) The type of the ML object. Valid values are: BatchPrediction, DataSource, Evaluation, MLModel.)
        */
        this.set_ResourceType = function(value) {
            this.setInput("ResourceType", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeTags Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeTagsResultSet = function(resultStream) {
    DescribeTagsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeTags, choreography.Choreography);
util.inherits(DescribeTagsInputSet, choreography.InputSet);
util.inherits(DescribeTagsResultSet, choreography.ResultSet);
exports.DescribeTags = DescribeTags;


/*
    GetDataSource
    Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.
*/


var GetDataSource = function(session) {
    /*
        Create a new instance of the GetDataSource Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/GetDataSource"
    GetDataSource.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetDataSourceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetDataSourceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetDataSource
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetDataSourceInputSet = function() {
    GetDataSourceInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the DataSourceId input for this Choreo. ((required, string) The ID assigned to the DataSource at creation.)
        */
        this.set_DataSourceId = function(value) {
            this.setInput("DataSourceId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) Specifies whether the GetDataSource operation should return DataSourceSchema. Defaults to true.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetDataSource Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetDataSourceResultSet = function(resultStream) {
    GetDataSourceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetDataSource, choreography.Choreography);
util.inherits(GetDataSourceInputSet, choreography.InputSet);
util.inherits(GetDataSourceResultSet, choreography.ResultSet);
exports.GetDataSource = GetDataSource;


/*
    GetEvaluation
    Returns an Evaluation that includes metadata as well as the current status of the Evaluation.
*/


var GetEvaluation = function(session) {
    /*
        Create a new instance of the GetEvaluation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/GetEvaluation"
    GetEvaluation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetEvaluationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetEvaluationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetEvaluation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetEvaluationInputSet = function() {
    GetEvaluationInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EvaluationId input for this Choreo. ((required, string) The ID of the Evaluation to retrieve.)
        */
        this.set_EvaluationId = function(value) {
            this.setInput("EvaluationId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetEvaluation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetEvaluationResultSet = function(resultStream) {
    GetEvaluationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetEvaluation, choreography.Choreography);
util.inherits(GetEvaluationInputSet, choreography.InputSet);
util.inherits(GetEvaluationResultSet, choreography.ResultSet);
exports.GetEvaluation = GetEvaluation;


/*
    GetMLModel
    Returns an MLModel that includes detailed metadata, data source information, and the current status of the MLModel.
*/


var GetMLModel = function(session) {
    /*
        Create a new instance of the GetMLModel Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/GetMLModel"
    GetMLModel.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetMLModelResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetMLModelInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetMLModel
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetMLModelInputSet = function() {
    GetMLModelInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID assigned to the MLModelId at creation.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) Specifies whether the GetMLModel operation should return Recipe. Defaults to false.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetMLModel Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetMLModelResultSet = function(resultStream) {
    GetMLModelResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetMLModel, choreography.Choreography);
util.inherits(GetMLModelInputSet, choreography.InputSet);
util.inherits(GetMLModelResultSet, choreography.ResultSet);
exports.GetMLModel = GetMLModel;


/*
    Predict
    Generates a prediction for the observation using the specified ML Model.
*/


var Predict = function(session) {
    /*
        Create a new instance of the Predict Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/Predict"
    Predict.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PredictResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PredictInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Predict
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PredictInputSet = function() {
    PredictInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) A unique identifier of the MLModel.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the PredictEndpoint input for this Choreo. ((required, string) The realtime endpoint to use for the prediction.)
        */
        this.set_PredictEndpoint = function(value) {
            this.setInput("PredictEndpoint", value);
        }

        /*
        Set the value of the Record input for this Choreo. ((required, json) A map of variable name-value pairs that represent an observation.)
        */
        this.set_Record = function(value) {
            this.setInput("Record", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Predict Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PredictResultSet = function(resultStream) {
    PredictResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Predict, choreography.Choreography);
util.inherits(PredictInputSet, choreography.InputSet);
util.inherits(PredictResultSet, choreography.ResultSet);
exports.Predict = Predict;


/*
    UpdateBatchPrediction
    Updates the BatchPredictionName of a BatchPrediction.
*/


var UpdateBatchPrediction = function(session) {
    /*
        Create a new instance of the UpdateBatchPrediction Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/UpdateBatchPrediction"
    UpdateBatchPrediction.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateBatchPredictionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateBatchPredictionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateBatchPrediction
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateBatchPredictionInputSet = function() {
    UpdateBatchPredictionInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the BatchPredictionId input for this Choreo. ((required, string) The ID assigned to the BatchPrediction during creation.)
        */
        this.set_BatchPredictionId = function(value) {
            this.setInput("BatchPredictionId", value);
        }

        /*
        Set the value of the BatchPredictionName input for this Choreo. ((required, string) A new user-supplied name or description of the BatchPrediction.)
        */
        this.set_BatchPredictionName = function(value) {
            this.setInput("BatchPredictionName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateBatchPrediction Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateBatchPredictionResultSet = function(resultStream) {
    UpdateBatchPredictionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateBatchPrediction, choreography.Choreography);
util.inherits(UpdateBatchPredictionInputSet, choreography.InputSet);
util.inherits(UpdateBatchPredictionResultSet, choreography.ResultSet);
exports.UpdateBatchPrediction = UpdateBatchPrediction;


/*
    UpdateDataSource
    Updates the DataSourceName of a DataSource.
*/


var UpdateDataSource = function(session) {
    /*
        Create a new instance of the UpdateDataSource Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/UpdateDataSource"
    UpdateDataSource.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateDataSourceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateDataSourceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateDataSource
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateDataSourceInputSet = function() {
    UpdateDataSourceInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the DataSourceId input for this Choreo. ((required, string) The ID assigned to the DataSource at creation.)
        */
        this.set_DataSourceId = function(value) {
            this.setInput("DataSourceId", value);
        }

        /*
        Set the value of the DataSourceName input for this Choreo. ((required, string) A new user-supplied name or description of the DataSource that will replace the current description.)
        */
        this.set_DataSourceName = function(value) {
            this.setInput("DataSourceName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateDataSource Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateDataSourceResultSet = function(resultStream) {
    UpdateDataSourceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateDataSource, choreography.Choreography);
util.inherits(UpdateDataSourceInputSet, choreography.InputSet);
util.inherits(UpdateDataSourceResultSet, choreography.ResultSet);
exports.UpdateDataSource = UpdateDataSource;


/*
    UpdateEvaluation
    Updates the EvaluationName of an Evaluation.
*/


var UpdateEvaluation = function(session) {
    /*
        Create a new instance of the UpdateEvaluation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/UpdateEvaluation"
    UpdateEvaluation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateEvaluationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateEvaluationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateEvaluation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateEvaluationInputSet = function() {
    UpdateEvaluationInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the EvaluationId input for this Choreo. ((required, string) The ID assigned to the Evaluation during creation.)
        */
        this.set_EvaluationId = function(value) {
            this.setInput("EvaluationId", value);
        }

        /*
        Set the value of the EvaluationName input for this Choreo. ((required, string) A new user-supplied name or description of the Evaluation that will replace the current content.)
        */
        this.set_EvaluationName = function(value) {
            this.setInput("EvaluationName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateEvaluation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateEvaluationResultSet = function(resultStream) {
    UpdateEvaluationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateEvaluation, choreography.Choreography);
util.inherits(UpdateEvaluationInputSet, choreography.InputSet);
util.inherits(UpdateEvaluationResultSet, choreography.ResultSet);
exports.UpdateEvaluation = UpdateEvaluation;


/*
    UpdateMLModel
    Updates the MLModelName and the ScoreThreshold of an MLModel.
*/


var UpdateMLModel = function(session) {
    /*
        Create a new instance of the UpdateMLModel Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/MachineLearning/UpdateMLModel"
    UpdateMLModel.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateMLModelResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateMLModelInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateMLModel
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateMLModelInputSet = function() {
    UpdateMLModelInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the MLModelId input for this Choreo. ((required, string) The ID assigned to the MLModelId at creation.)
        */
        this.set_MLModelId = function(value) {
            this.setInput("MLModelId", value);
        }

        /*
        Set the value of the MLModelName input for this Choreo. ((required, string) A user-supplied name or description of the MLModel.)
        */
        this.set_MLModelName = function(value) {
            this.setInput("MLModelName", value);
        }

        /*
        Set the value of the ScoreThreshold input for this Choreo. ((optional, decimal) The ScoreThreshold used in binary classification MLModel that marks the boundary between a positive prediction and a negative prediction.)
        */
        this.set_ScoreThreshold = function(value) {
            this.setInput("ScoreThreshold", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateMLModel Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateMLModelResultSet = function(resultStream) {
    UpdateMLModelResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateMLModel, choreography.Choreography);
util.inherits(UpdateMLModelInputSet, choreography.InputSet);
util.inherits(UpdateMLModelResultSet, choreography.ResultSet);
exports.UpdateMLModel = UpdateMLModel;

