
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ConvertLead
    Converts a lead to a potential, account, or contact in your Zoho CRM account.
*/


var ConvertLead = function(session) {
    /*
        Create a new instance of the ConvertLead Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/ConvertLead"
    ConvertLead.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ConvertLeadResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ConvertLeadInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ConvertLead
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ConvertLeadInputSet = function() {
    ConvertLeadInputSet.super_.call(this);
        /*
        Set the value of the Amount input for this Choreo. ((conditional, decimal) Corresponds to the Amount field in Zoho. Required if CreatePotential is set to 1.)
        */
        this.set_Amount = function(value) {
            this.setInput("Amount", value);
        }

        /*
        Set the value of the AssignTo input for this Choreo. ((optional, string) Corresponds to the Assign To field in Zoho)
        */
        this.set_AssignTo = function(value) {
            this.setInput("AssignTo", value);
        }

        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the ClosingDate input for this Choreo. ((conditional, date) Corresponds to the Closing Date field in Zoho. Formatted like MM/dd/yyyy. Required if CreatePotential is set to 1.)
        */
        this.set_ClosingDate = function(value) {
            this.setInput("ClosingDate", value);
        }

        /*
        Set the value of the ContactRole input for this Choreo. ((conditional, string) Corresponds to the Contact Role field in Zoho. Required if CreatePotential is set to 1.)
        */
        this.set_ContactRole = function(value) {
            this.setInput("ContactRole", value);
        }

        /*
        Set the value of the CreatePotential input for this Choreo. ((optional, boolean) Whether or not to create a potential)
        */
        this.set_CreatePotential = function(value) {
            this.setInput("CreatePotential", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, integer) The ID for the lead that you wish to convert to a potential)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the NotifyLeadOwner input for this Choreo. ((optional, boolean) Whether or not to notifiy the lead owner. Defaults to 0 for false.)
        */
        this.set_NotifyLeadOwner = function(value) {
            this.setInput("NotifyLeadOwner", value);
        }

        /*
        Set the value of the NotifyNewEntityOwner input for this Choreo. ((optional, boolean) Whether or not to notify the new entity owner. Defaults to 0 for false.)
        */
        this.set_NotifyNewEntityOwner = function(value) {
            this.setInput("NotifyNewEntityOwner", value);
        }

        /*
        Set the value of the PotentialName input for this Choreo. ((conditional, string) Corresponds to the Potential Name field in Zoho. Required if CreatePotential is set to 1.)
        */
        this.set_PotentialName = function(value) {
            this.setInput("PotentialName", value);
        }

        /*
        Set the value of the PotentialStage input for this Choreo. ((conditional, string) Corresponds to the Potential Stage field in Zoho. Required if CreatePotential is set to 1.)
        */
        this.set_PotentialStage = function(value) {
            this.setInput("PotentialStage", value);
        }

        /*
        Set the value of the Probability input for this Choreo. ((conditional, integer) Corresponds to the Probability field in Zoho. Required if CreatePotential is set to 1.)
        */
        this.set_Probability = function(value) {
            this.setInput("Probability", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ConvertLead Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ConvertLeadResultSet = function(resultStream) {
    ConvertLeadResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ConvertLead, choreography.Choreography);
util.inherits(ConvertLeadInputSet, choreography.InputSet);
util.inherits(ConvertLeadResultSet, choreography.ResultSet);
exports.ConvertLead = ConvertLead;


/*
    DeleteRecords
    Deletes a specified record from a Zoho CRM account.
*/


var DeleteRecords = function(session) {
    /*
        Create a new instance of the DeleteRecords Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/DeleteRecords"
    DeleteRecords.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteRecordsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteRecordsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteRecords
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteRecordsInputSet = function() {
    DeleteRecordsInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, integer) The ID for the record you want to delete)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to Leads.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteRecords Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteRecordsResultSet = function(resultStream) {
    DeleteRecordsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteRecords, choreography.Choreography);
util.inherits(DeleteRecordsInputSet, choreography.InputSet);
util.inherits(DeleteRecordsResultSet, choreography.ResultSet);
exports.DeleteRecords = DeleteRecords;


/*
    GenerateAuthToken
    Generates an authentication token.
*/


var GenerateAuthToken = function(session) {
    /*
        Create a new instance of the GenerateAuthToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GenerateAuthToken"
    GenerateAuthToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GenerateAuthTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GenerateAuthTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GenerateAuthToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GenerateAuthTokenInputSet = function() {
    GenerateAuthTokenInputSet.super_.call(this);
        /*
        Set the value of the Password input for this Choreo. ((required, string) Your Zoho password.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((required, string) Your Zoho CRM username.)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GenerateAuthToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GenerateAuthTokenResultSet = function(resultStream) {
    GenerateAuthTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "AuthenticationToken" output from this Choreo execution. ((string) The authentication token returned from Zoho.)
        */
        this.get_AuthenticationToken = function() {
            return this.getResult("AuthenticationToken");
        }
}

util.inherits(GenerateAuthToken, choreography.Choreography);
util.inherits(GenerateAuthTokenInputSet, choreography.InputSet);
util.inherits(GenerateAuthTokenResultSet, choreography.ResultSet);
exports.GenerateAuthToken = GenerateAuthToken;


/*
    GetCVRecord
    Retrieves data with respect to the Custom View in Zoho CRM.
*/


var GetCVRecord = function(session) {
    /*
        Create a new instance of the GetCVRecord Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetCVRecord"
    GetCVRecord.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCVRecordResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCVRecordInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCVRecord
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCVRecordInputSet = function() {
    GetCVRecordInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the CVName input for this Choreo. ((optional, string) Used to retrieve records from a specific customer view. Defaults to 'All Open Leads'.)
        */
        this.set_CVName = function(value) {
            this.setInput("CVName", value);
        }

        /*
        Set the value of the FromIndex input for this Choreo. ((optional, integer) The beginning index of the result set to return. Defaults to 1.)
        */
        this.set_FromIndex = function(value) {
            this.setInput("FromIndex", value);
        }

        /*
        Set the value of the LastModifiedDate input for this Choreo. ((optional, date) Used to return records with a created or modified date that is after the specified time.  (i.e. 2010-04-21 11:09:23))
        */
        this.set_LastModifiedDate = function(value) {
            this.setInput("LastModifiedDate", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to Leads.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the ToIndex input for this Choreo. ((optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.)
        */
        this.set_ToIndex = function(value) {
            this.setInput("ToIndex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCVRecord Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCVRecordResultSet = function(resultStream) {
    GetCVRecordResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetCVRecord, choreography.Choreography);
util.inherits(GetCVRecordInputSet, choreography.InputSet);
util.inherits(GetCVRecordResultSet, choreography.ResultSet);
exports.GetCVRecord = GetCVRecord;


/*
    GetMyRecords
    Retrieves data by owner of the authentication token specified.
*/


var GetMyRecords = function(session) {
    /*
        Create a new instance of the GetMyRecords Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetMyRecords"
    GetMyRecords.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetMyRecordsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetMyRecordsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetMyRecords
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetMyRecordsInputSet = function() {
    GetMyRecordsInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the FromIndex input for this Choreo. ((optional, integer) The beginning index of the result set to return. Defaults to 1.)
        */
        this.set_FromIndex = function(value) {
            this.setInput("FromIndex", value);
        }

        /*
        Set the value of the LastModifiedTime input for this Choreo. ((optional, date) Used to return records with a created or modified date that is after the specified time.  (i.e. 2010-04-21 11:09:23))
        */
        this.set_LastModifiedTime = function(value) {
            this.setInput("LastModifiedTime", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to Leads.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SelectColumns input for this Choreo. ((optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.)
        */
        this.set_SelectColumns = function(value) {
            this.setInput("SelectColumns", value);
        }

        /*
        Set the value of the SortColumnString input for this Choreo. ((optional, integer) Used to specify a column to sort by)
        */
        this.set_SortColumnString = function(value) {
            this.setInput("SortColumnString", value);
        }

        /*
        Set the value of the SortOrderString input for this Choreo. ((optional, string) Sorting order: asc or desc. Default sort order is set to ascending.)
        */
        this.set_SortOrderString = function(value) {
            this.setInput("SortOrderString", value);
        }

        /*
        Set the value of the ToIndex input for this Choreo. ((optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.)
        */
        this.set_ToIndex = function(value) {
            this.setInput("ToIndex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetMyRecords Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetMyRecordsResultSet = function(resultStream) {
    GetMyRecordsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetMyRecords, choreography.Choreography);
util.inherits(GetMyRecordsInputSet, choreography.InputSet);
util.inherits(GetMyRecordsResultSet, choreography.ResultSet);
exports.GetMyRecords = GetMyRecords;


/*
    GetRecords
    Retrieves all users data specified in the API request.
*/


var GetRecords = function(session) {
    /*
        Create a new instance of the GetRecords Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetRecords"
    GetRecords.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetRecordsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetRecordsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetRecords
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetRecordsInputSet = function() {
    GetRecordsInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the FromIndex input for this Choreo. ((optional, integer) The beginning index of the result set to return. Defaults to 1.)
        */
        this.set_FromIndex = function(value) {
            this.setInput("FromIndex", value);
        }

        /*
        Set the value of the LastModifiedTime input for this Choreo. ((optional, date) Used to return records with a created or modified date that is after the specified time.  (i.e. 2010-04-21 11:09:23))
        */
        this.set_LastModifiedTime = function(value) {
            this.setInput("LastModifiedTime", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to 'Leads'.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SelectColumns input for this Choreo. ((optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.)
        */
        this.set_SelectColumns = function(value) {
            this.setInput("SelectColumns", value);
        }

        /*
        Set the value of the SortColumnString input for this Choreo. ((optional, string) Used to specify a column to sort by (in ascending order))
        */
        this.set_SortColumnString = function(value) {
            this.setInput("SortColumnString", value);
        }

        /*
        Set the value of the SortOrderString input for this Choreo. ((optional, string) Sorting order: asc or desc. Default sort order is set to ascending.)
        */
        this.set_SortOrderString = function(value) {
            this.setInput("SortOrderString", value);
        }

        /*
        Set the value of the ToIndex input for this Choreo. ((optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.)
        */
        this.set_ToIndex = function(value) {
            this.setInput("ToIndex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetRecords Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetRecordsResultSet = function(resultStream) {
    GetRecordsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetRecords, choreography.Choreography);
util.inherits(GetRecordsInputSet, choreography.InputSet);
util.inherits(GetRecordsResultSet, choreography.ResultSet);
exports.GetRecords = GetRecords;


/*
    GetRecordsById
    Retrieves records from your Zoho CRM account by ID.
*/


var GetRecordsById = function(session) {
    /*
        Create a new instance of the GetRecordsById Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetRecordsById"
    GetRecordsById.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetRecordsByIdResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetRecordsByIdInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetRecordsById
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetRecordsByIdInputSet = function() {
    GetRecordsByIdInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, integer) The ID for the Zoho record to lookup)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to 'Leads'.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetRecordsById Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetRecordsByIdResultSet = function(resultStream) {
    GetRecordsByIdResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetRecordsById, choreography.Choreography);
util.inherits(GetRecordsByIdInputSet, choreography.InputSet);
util.inherits(GetRecordsByIdResultSet, choreography.ResultSet);
exports.GetRecordsById = GetRecordsById;


/*
    GetSearchRecords
    Lets you to search your Zoho CRM account for records based on Zoho's search expressions.
*/


var GetSearchRecords = function(session) {
    /*
        Create a new instance of the GetSearchRecords Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetSearchRecords"
    GetSearchRecords.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetSearchRecordsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetSearchRecordsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetSearchRecords
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetSearchRecordsInputSet = function() {
    GetSearchRecordsInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the FromIndex input for this Choreo. ((optional, integer) The beginning index of the result set to return. Defaults to 1.)
        */
        this.set_FromIndex = function(value) {
            this.setInput("FromIndex", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to 'Leads'.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SearchColumn input for this Choreo. ((required, string) Specify the name of the column you want to search (i.e. Email))
        */
        this.set_SearchColumn = function(value) {
            this.setInput("SearchColumn", value);
        }

        /*
        Set the value of the SearchExpression input for this Choreo. ((required, string) Specify an expression to use in your search (i.e. =, <>, contains, starts with, ends with, doesn't contain, <, >, <=, =>))
        */
        this.set_SearchExpression = function(value) {
            this.setInput("SearchExpression", value);
        }

        /*
        Set the value of the SearchString input for this Choreo. ((required, string) Specify a search string to use in the search (i.e. *gmail.com*))
        */
        this.set_SearchString = function(value) {
            this.setInput("SearchString", value);
        }

        /*
        Set the value of the SelectColumns input for this Choreo. ((optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.)
        */
        this.set_SelectColumns = function(value) {
            this.setInput("SelectColumns", value);
        }

        /*
        Set the value of the ToIndex input for this Choreo. ((optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.)
        */
        this.set_ToIndex = function(value) {
            this.setInput("ToIndex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetSearchRecords Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetSearchRecordsResultSet = function(resultStream) {
    GetSearchRecordsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetSearchRecords, choreography.Choreography);
util.inherits(GetSearchRecordsInputSet, choreography.InputSet);
util.inherits(GetSearchRecordsResultSet, choreography.ResultSet);
exports.GetSearchRecords = GetSearchRecords;


/*
    GetSearchRecordsByPDC
    Retrieves records from your Zoho CRM account and searches by predefined columns.
*/


var GetSearchRecordsByPDC = function(session) {
    /*
        Create a new instance of the GetSearchRecordsByPDC Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/GetSearchRecordsByPDC"
    GetSearchRecordsByPDC.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetSearchRecordsByPDCResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetSearchRecordsByPDCInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetSearchRecordsByPDC
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetSearchRecordsByPDCInputSet = function() {
    GetSearchRecordsByPDCInputSet.super_.call(this);
        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the FromIndex input for this Choreo. ((optional, integer) The beginning index of the result set to return. Defaults to 1.)
        */
        this.set_FromIndex = function(value) {
            this.setInput("FromIndex", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((required, string) The Zoho module you want to access. Defaults to 'Leads'.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SearchColumn input for this Choreo. ((required, string) The column name you want to search (such as "email", the column names used in this method are in lowercase))
        */
        this.set_SearchColumn = function(value) {
            this.setInput("SearchColumn", value);
        }

        /*
        Set the value of the SearchValue input for this Choreo. ((required, string) Specify a search value for the column you're searching)
        */
        this.set_SearchValue = function(value) {
            this.setInput("SearchValue", value);
        }

        /*
        Set the value of the SelectColumns input for this Choreo. ((optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.)
        */
        this.set_SelectColumns = function(value) {
            this.setInput("SelectColumns", value);
        }

        /*
        Set the value of the ToIndex input for this Choreo. ((optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.)
        */
        this.set_ToIndex = function(value) {
            this.setInput("ToIndex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetSearchRecordsByPDC Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetSearchRecordsByPDCResultSet = function(resultStream) {
    GetSearchRecordsByPDCResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetSearchRecordsByPDC, choreography.Choreography);
util.inherits(GetSearchRecordsByPDCInputSet, choreography.InputSet);
util.inherits(GetSearchRecordsByPDCResultSet, choreography.ResultSet);
exports.GetSearchRecordsByPDC = GetSearchRecordsByPDC;


/*
    InsertRecords
    Inserts records into your Zoho CRM account.
*/


var InsertRecords = function(session) {
    /*
        Create a new instance of the InsertRecords Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Zoho/CRM/InsertRecords"
    InsertRecords.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new InsertRecordsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new InsertRecordsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the InsertRecords
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var InsertRecordsInputSet = function() {
    InsertRecordsInputSet.super_.call(this);
        /*
        Set the value of the AnnualRevenue input for this Choreo. ((optional, string) Corresponds to the Annual Revenue field in Zoho)
        */
        this.set_AnnualRevenue = function(value) {
            this.setInput("AnnualRevenue", value);
        }

        /*
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        */
        this.set_AuthenticationToken = function(value) {
            this.setInput("AuthenticationToken", value);
        }

        /*
        Set the value of the CampaignSource input for this Choreo. ((optional, string) Corresponds to the Campaign Source field in Zoho)
        */
        this.set_CampaignSource = function(value) {
            this.setInput("CampaignSource", value);
        }

        /*
        Set the value of the City input for this Choreo. ((optional, string) Corresponds to the City field in Zoho)
        */
        this.set_City = function(value) {
            this.setInput("City", value);
        }

        /*
        Set the value of the Company input for this Choreo. ((optional, string) Corresponds to the Company field in Zoho)
        */
        this.set_Company = function(value) {
            this.setInput("Company", value);
        }

        /*
        Set the value of the Country input for this Choreo. ((optional, string) Corresponds to the Country field in Zoho)
        */
        this.set_Country = function(value) {
            this.setInput("Country", value);
        }

        /*
        Set the value of the Description input for this Choreo. ((optional, string) Corresponds to the Description field in Zoho)
        */
        this.set_Description = function(value) {
            this.setInput("Description", value);
        }

        /*
        Set the value of the Email input for this Choreo. ((optional, string) Corresponds to the Email field in Zoho)
        */
        this.set_Email = function(value) {
            this.setInput("Email", value);
        }

        /*
        Set the value of the EmailOptOut input for this Choreo. ((optional, boolean) Corresponds to the Email Opt Out field in Zoho. Defaults to 0 for false.)
        */
        this.set_EmailOptOut = function(value) {
            this.setInput("EmailOptOut", value);
        }

        /*
        Set the value of the Fax input for this Choreo. ((optional, string) Corresponds to the Fax field in Zoho)
        */
        this.set_Fax = function(value) {
            this.setInput("Fax", value);
        }

        /*
        Set the value of the FirstName input for this Choreo. ((optional, string) Corresponds to the First Name field in Zoho)
        */
        this.set_FirstName = function(value) {
            this.setInput("FirstName", value);
        }

        /*
        Set the value of the Industry input for this Choreo. ((optional, string) Corresponds to the Industry field in Zoho)
        */
        this.set_Industry = function(value) {
            this.setInput("Industry", value);
        }

        /*
        Set the value of the LastName input for this Choreo. ((required, string) Corresponds to the Last Name field in Zoho)
        */
        this.set_LastName = function(value) {
            this.setInput("LastName", value);
        }

        /*
        Set the value of the LeadOwner input for this Choreo. ((optional, string) Corresponds to the Lead Owner field in Zoho)
        */
        this.set_LeadOwner = function(value) {
            this.setInput("LeadOwner", value);
        }

        /*
        Set the value of the LeadSource input for this Choreo. ((optional, string) Corresponds to the Lead Source field in Zoho)
        */
        this.set_LeadSource = function(value) {
            this.setInput("LeadSource", value);
        }

        /*
        Set the value of the LeadStatus input for this Choreo. ((optional, string) Corresponds to the Lead Status field in Zoho)
        */
        this.set_LeadStatus = function(value) {
            this.setInput("LeadStatus", value);
        }

        /*
        Set the value of the Mobile input for this Choreo. ((optional, string) Corresponds to the Mobile field in Zoho)
        */
        this.set_Mobile = function(value) {
            this.setInput("Mobile", value);
        }

        /*
        Set the value of the Module input for this Choreo. ((optional, string) The Zoho module you want to access. Defaults to 'Leads'.)
        */
        this.set_Module = function(value) {
            this.setInput("Module", value);
        }

        /*
        Set the value of the NumOfEmployees input for this Choreo. ((optional, string) Corresponds to the Num Of Employees field in Zoho)
        */
        this.set_NumOfEmployees = function(value) {
            this.setInput("NumOfEmployees", value);
        }

        /*
        Set the value of the Phone input for this Choreo. ((optional, string) Corresponds to the Phone field in Zoho)
        */
        this.set_Phone = function(value) {
            this.setInput("Phone", value);
        }

        /*
        Set the value of the Rating input for this Choreo. ((optional, string) Corresponds to the Rating field in Zoho)
        */
        this.set_Rating = function(value) {
            this.setInput("Rating", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Salutation input for this Choreo. ((optional, string) Corresponds to the Salutation field in Zoho)
        */
        this.set_Salutation = function(value) {
            this.setInput("Salutation", value);
        }

        /*
        Set the value of the SkypeID input for this Choreo. ((optional, string) Corresponds to the Skype ID field in Zoho)
        */
        this.set_SkypeID = function(value) {
            this.setInput("SkypeID", value);
        }

        /*
        Set the value of the State input for this Choreo. ((optional, string) Corresponds to the State field in Zoho)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Street input for this Choreo. ((optional, string) Corresponds to the Street field in Zoho)
        */
        this.set_Street = function(value) {
            this.setInput("Street", value);
        }

        /*
        Set the value of the Title input for this Choreo. ((optional, string) Corresponds to the Title field in Zoho)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

        /*
        Set the value of the Website input for this Choreo. ((optional, string) Corresponds to the Website field in Zoho)
        */
        this.set_Website = function(value) {
            this.setInput("Website", value);
        }

        /*
        Set the value of the ZipCode input for this Choreo. ((optional, integer) Corresponds to the Zip Code field in Zoho)
        */
        this.set_ZipCode = function(value) {
            this.setInput("ZipCode", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the InsertRecords Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var InsertRecordsResultSet = function(resultStream) {
    InsertRecordsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(InsertRecords, choreography.Choreography);
util.inherits(InsertRecordsInputSet, choreography.InputSet);
util.inherits(InsertRecordsResultSet, choreography.ResultSet);
exports.InsertRecords = InsertRecords;

