
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetSearchResult
    Allows your application to submit a query to Wolfram|Alpha and return only the plain text from the first result pod.
*/


var GetSearchResult = function(session) {
    /*
        Create a new instance of the GetSearchResult Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/WolframAlpha/GetSearchResult"
    GetSearchResult.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetSearchResultResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetSearchResultInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetSearchResult
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetSearchResultInputSet = function() {
    GetSearchResultInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The App ID provided by Wolfram|Alpha.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the Input input for this Choreo. ((required, string) Specifies the input string (e.g., "5 largest countries").)
        */
        this.set_Input = function(value) {
            this.setInput("Input", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Location input for this Choreo. ((optional, string) When query results depend on your location, use this parameter to specify a location such as "Los Angeles, CA", or "Madrid".)
        */
        this.set_Location = function(value) {
            this.setInput("Location", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format for the response. Valid values are JSON and XML. This will be ignored when providng an XPath query because results are returned as a string or JSON depending on the Mode specified.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Translation input for this Choreo. ((optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.)
        */
        this.set_Translation = function(value) {
            this.setInput("Translation", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) Lets you specify the preferred measurement system, either "metric" or "nonmetric" (U.S. customary units).)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetSearchResult Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetSearchResultResultSet = function(resultStream) {
    GetSearchResultResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Result" output from this Choreo execution. ((string) The plain text result parsed from the Wolfram Alpha response.)
        */
        this.get_Result = function() {
            return this.getResult("Result");
        }
}

util.inherits(GetSearchResult, choreography.Choreography);
util.inherits(GetSearchResultInputSet, choreography.InputSet);
util.inherits(GetSearchResultResultSet, choreography.ResultSet);
exports.GetSearchResult = GetSearchResult;


/*
    Query
    Allows your application to submit free-form queries similar to the queries one might enter at the Wolfram|Alpha website.
*/


var Query = function(session) {
    /*
        Create a new instance of the Query Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/WolframAlpha/Query"
    Query.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new QueryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new QueryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Query
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var QueryInputSet = function() {
    QueryInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The App ID provided by Wolfram|Alpha.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the Assumption input for this Choreo. ((optional, string) Up to 10 comma-seperated assumptions to narrow a query.  Wolfram|Alpha provides you with a list of assumptons in the response of a previous query.  Please consult the documentation for more details.)
        */
        this.set_Assumption = function(value) {
            this.setInput("Assumption", value);
        }

        /*
        Set the value of the Async input for this Choreo. ((optional, boolean) Set to true to specify that asynchronous mode should be used. This allows partial results to come back before all the pods are computed.)
        */
        this.set_Async = function(value) {
            this.setInput("Async", value);
        }

        /*
        Set the value of the ExcludePodID input for this Choreo. ((optional, string) Specifies the IDs of the pod(s) to exlude from the response. All pod IDs are returned by default.)
        */
        this.set_ExcludePodID = function(value) {
            this.setInput("ExcludePodID", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((optional, string) The desired result formats separated by commas. Valid values are image, plaintext, minput, moutput, cell, mathml, imagemap, sound, wav. Defaults to "plaintext,image".)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the FormatTimeout input for this Choreo. ((optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for the entire collection of pods. Default value is 8.0.)
        */
        this.set_FormatTimeout = function(value) {
            this.setInput("FormatTimeout", value);
        }

        /*
        Set the value of the IgnoreCase input for this Choreo. ((optional, boolean) Whether to force Wolfram Alpha to ignore case in queries. Defaults to false.)
        */
        this.set_IgnoreCase = function(value) {
            this.setInput("IgnoreCase", value);
        }

        /*
        Set the value of the IncludePodID input for this Choreo. ((optional, string) Specifies the IDs of the pod(s) to include in the response. All pod IDs are returned by default.)
        */
        this.set_IncludePodID = function(value) {
            this.setInput("IncludePodID", value);
        }

        /*
        Set the value of the Input input for this Choreo. ((required, string) Specifies the input string (e.g., "5 largest countries").)
        */
        this.set_Input = function(value) {
            this.setInput("Input", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((optional, decimal) When query results depend on your location, use this parameter to specify a latitude point.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Location input for this Choreo. ((optional, string) When query results depend on your location, use this parameter to specify a location such as "Los Angeles, CA", or "Madrid".)
        */
        this.set_Location = function(value) {
            this.setInput("Location", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((optional, decimal) When query results depend on your location, use this parameter to specify a longitude point.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the Magnification input for this Choreo. ((optional, decimal) Controls the magnification of pod images. The default value is 1.0, indicating no magnification.)
        */
        this.set_Magnification = function(value) {
            this.setInput("Magnification", value);
        }

        /*
        Set the value of the MaxWidth input for this Choreo. ((optional, integer) Used to change the default width of pod images. Width and MaxWidth apply to images of text and tables. This can be used to avoid undesirable line breaks if the value of Width is too small.)
        */
        this.set_MaxWidth = function(value) {
            this.setInput("MaxWidth", value);
        }

        /*
        Set the value of the ParseTimeout input for this Choreo. ((optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "parsing" stage of processing. Default value is 5.0.)
        */
        this.set_ParseTimeout = function(value) {
            this.setInput("ParseTimeout", value);
        }

        /*
        Set the value of the PlotWidth input for this Choreo. ((optional, integer) Controls the width at which plots and graphics are rendered. The default value is 200 pixels.)
        */
        this.set_PlotWidth = function(value) {
            this.setInput("PlotWidth", value);
        }

        /*
        Set the value of the PodIndex input for this Choreo. ((optional, string) Specifies the index of the pod(s) to return. This is an alternative to specifying pods by title or ID. You can give a single number or a sequence like "2,3,5".)
        */
        this.set_PodIndex = function(value) {
            this.setInput("PodIndex", value);
        }

        /*
        Set the value of the PodState input for this Choreo. ((optional, string) Specifies a pod state change, which replaces a pod with a modified version, such as a switch from Imperial to metric units.)
        */
        this.set_PodState = function(value) {
            this.setInput("PodState", value);
        }

        /*
        Set the value of the PodTimeout input for this Choreo. ((optional, decimal) The number of seconds to allow Wolfram Alpha to spend in the "format" stage for any one pod. Default value is 4.0.)
        */
        this.set_PodTimeout = function(value) {
            this.setInput("PodTimeout", value);
        }

        /*
        Set the value of the PodTitle input for this Choreo. ((optional, string) Specifies the titles of the pod(s) to include in the response. All pod titles are returned by default. You can use * as a wildcard to match zero or more characters in pod titles.)
        */
        this.set_PodTitle = function(value) {
            this.setInput("PodTitle", value);
        }

        /*
        Set the value of the Reinterpret input for this Choreo. ((optional, boolean) Whether to allow Wolfram Alpha to reinterpret queries that would otherwise not be understood. Defaults to false.)
        */
        this.set_Reinterpret = function(value) {
            this.setInput("Reinterpret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format for the response. Valid values are JSON and XML. This will be ignored when providng an XPath query because results are returned as a string or JSON depending on the Mode specified.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the ScanTimeout input for this Choreo. ((optional, decimal) The number of seconds to allow Wolfram Alpha to compute results in the "scan" stage of processing. Default value is 3.0.)
        */
        this.set_ScanTimeout = function(value) {
            this.setInput("ScanTimeout", value);
        }

        /*
        Set the value of the Scanner input for this Choreo. ((optional, string) Specifies that only pods produced by the given scanner should be returned. (e.g. Numeric, Music).  Defaults to all pods.)
        */
        this.set_Scanner = function(value) {
            this.setInput("Scanner", value);
        }

        /*
        Set the value of the Translation input for this Choreo. ((optional, boolean) Whether to allow Wolfram Alpha to try to translate simple queries into English. Defaults to true.)
        */
        this.set_Translation = function(value) {
            this.setInput("Translation", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) Lets you specify the preferred measurement system, either "metric" or "nonmetric" (U.S. customary units).)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

        /*
        Set the value of the Width input for this Choreo. ((optional, integer) Used to change the default width of pod images. The default is 500 pixels. Width and MaxWidth apply to images of text and tables.)
        */
        this.set_Width = function(value) {
            this.setInput("Width", value);
        }

        /*
        Set the value of the XPath input for this Choreo. ((optional, string) An XPath query to apply to the API results.)
        */
        this.set_XPath = function(value) {
            this.setInput("XPath", value);
        }

        /*
        Set the value of the XPathMode input for this Choreo. ((optional, string) Valid values are "select" (the default) or "recursive". Recursive mode will iterate using the provided XPath. Select mode will return the first match at the position indicated by the provided XPath.)
        */
        this.set_XPathMode = function(value) {
            this.setInput("XPathMode", value);
        }

        /*
        Set the value of the XPathRegex input for this Choreo. ((optional, string) A regular expression that can be applied to the result of the XPath query provided.)
        */
        this.set_XPathRegex = function(value) {
            this.setInput("XPathRegex", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Query Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var QueryResultSet = function(resultStream) {
    QueryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Wolfram Alpha.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Query, choreography.Choreography);
util.inherits(QueryInputSet, choreography.InputSet);
util.inherits(QueryResultSet, choreography.ResultSet);
exports.Query = Query;

