
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GenerateRandom
    This choreo generates a random number in a variety of ranges. 
*/


var GenerateRandom = function(session) {
    /*
        Create a new instance of the GenerateRandom Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Numbers/GenerateRandom"
    GenerateRandom.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GenerateRandomResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GenerateRandomInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GenerateRandom
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GenerateRandomInputSet = function() {
    GenerateRandomInputSet.super_.call(this);
}

/*
A ResultSet with methods tailored to the values returned by the GenerateRandom Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GenerateRandomResultSet = function(resultStream) {
    GenerateRandomResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "SignedDecimal" output from this Choreo execution. ((decimal) Signed Decimal in the range of  -0.5 to +0.5.)
        */
        this.get_SignedDecimal = function() {
            return this.getResult("SignedDecimal");
        }
        /*
        Retrieve the value for the "SignedInteger" output from this Choreo execution. ((integer) SIgned Integer in the range of -2147483648 through 2147483647.)
        */
        this.get_SignedInteger = function() {
            return this.getResult("SignedInteger");
        }
        /*
        Retrieve the value for the "UnsignedDecimal" output from this Choreo execution. ((decimal) Unsigned Decimal in the range of 0.0 to 1.0.)
        */
        this.get_UnsignedDecimal = function() {
            return this.getResult("UnsignedDecimal");
        }
        /*
        Retrieve the value for the "UnsignedInteger" output from this Choreo execution. ((integer) Unsigned integer in the range of 0 through 4294967295.)
        */
        this.get_UnsignedInteger = function() {
            return this.getResult("UnsignedInteger");
        }
}

util.inherits(GenerateRandom, choreography.Choreography);
util.inherits(GenerateRandomInputSet, choreography.InputSet);
util.inherits(GenerateRandomResultSet, choreography.ResultSet);
exports.GenerateRandom = GenerateRandom;

