
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetCallbackData
    Retrieves data captured from a request to your callback URL.
*/


var GetCallbackData = function(session) {
    /*
        Create a new instance of the GetCallbackData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Callback/GetCallbackData"
    GetCallbackData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCallbackDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCallbackDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCallbackData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCallbackDataInputSet = function() {
    GetCallbackDataInputSet.super_.call(this);
        /*
        Set the value of the CallbackID input for this Choreo. ((required, string) The ID that can used to retrieve request data that the callback URL has captured.)
        */
        this.set_CallbackID = function(value) {
            this.setInput("CallbackID", value);
        }

        /*
        Set the value of the FilterName input for this Choreo. ((optional, string) Allows you to filter callback data by a query parameter key-value pair. FilterValue is required when using this input.)
        */
        this.set_FilterName = function(value) {
            this.setInput("FilterName", value);
        }

        /*
        Set the value of the FilterValue input for this Choreo. ((optional, string) Allows you to filter callback data by a query parameter key-value pair. FilterName is required when using this input.)
        */
        this.set_FilterValue = function(value) {
            this.setInput("FilterValue", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCallbackData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCallbackDataResultSet = function(resultStream) {
    GetCallbackDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "CallbackData" output from this Choreo execution. (Contains the request data received at your CalllbackURL.)
        */
        this.get_CallbackData = function() {
            return this.getResult("CallbackData");
        }
}

util.inherits(GetCallbackData, choreography.Choreography);
util.inherits(GetCallbackDataInputSet, choreography.InputSet);
util.inherits(GetCallbackDataResultSet, choreography.ResultSet);
exports.GetCallbackData = GetCallbackData;


/*
    RegisterCallback
    Allows you to generate a unique URL that can "listen" for incoming data from web request.
*/


var RegisterCallback = function(session) {
    /*
        Create a new instance of the RegisterCallback Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Callback/RegisterCallback"
    RegisterCallback.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RegisterCallbackResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RegisterCallbackInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RegisterCallback
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RegisterCallbackInputSet = function() {
    RegisterCallbackInputSet.super_.call(this);
        /*
        Set the value of the CustomCallbackD input for this Choreo. ((optional, string) This value is used to register a unique URL associated with your account. If omitted, a random identifier is generated. Using a custom value here is useful when you need the URL to be static.)
        */
        this.set_CustomCallbackD = function(value) {
            this.setInput("CustomCallbackD", value);
        }

        /*
        Set the value of the FilterName input for this Choreo. ((optional, string) When using a Custom Callback ID, it can be useful to filter requests using a query parameter. This value is used as a query parameter name, and can be used to lookup request data.)
        */
        this.set_FilterName = function(value) {
            this.setInput("FilterName", value);
        }

        /*
        Set the value of the FilterValue input for this Choreo. ((optional, string) When using a Custom Callback ID, it can be useful to filter requests using a query parameter. This value is used as a query parameter value, and can be used to lookup request data.)
        */
        this.set_FilterValue = function(value) {
            this.setInput("FilterValue", value);
        }

        /*
        Set the value of the ForwardingURL input for this Choreo. ((optional, string) The URL that Temboo will redirect a users to after they visit your URL. This should include the "https://" or "http://" prefix and be a fully qualified URL.)
        */
        this.set_ForwardingURL = function(value) {
            this.setInput("ForwardingURL", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RegisterCallback Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RegisterCallbackResultSet = function(resultStream) {
    RegisterCallbackResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "CallbackID" output from this Choreo execution. ((string) The ID that can used to retrieve request data that the Callback URL captures.)
        */
        this.get_CallbackID = function() {
            return this.getResult("CallbackID");
        }
        /*
        Retrieve the value for the "CallbackURL" output from this Choreo execution. ((string) The URL that is listening for an incoming request. Note that this URL will expire in 10 minutes.)
        */
        this.get_CallbackURL = function() {
            return this.getResult("CallbackURL");
        }
}

util.inherits(RegisterCallback, choreography.Choreography);
util.inherits(RegisterCallbackInputSet, choreography.InputSet);
util.inherits(RegisterCallbackResultSet, choreography.ResultSet);
exports.RegisterCallback = RegisterCallback;

