
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetActivity
    Returns information about a user's activity with Uber including pickup locations and times, dropoff locations and times, the distance of past requests, and information about which products were requested.
*/


var GetActivity = function(session) {
    /*
        Create a new instance of the GetActivity Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Uber/User/GetActivity"
    GetActivity.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetActivityResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetActivityInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetActivity
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetActivityInputSet = function() {
    GetActivityInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) A valid Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) Limits the number of records returned in the response.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) Returns results starting from the specified number.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetActivity Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetActivityResultSet = function(resultStream) {
    GetActivityResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Uber.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetActivity, choreography.Choreography);
util.inherits(GetActivityInputSet, choreography.InputSet);
util.inherits(GetActivityResultSet, choreography.ResultSet);
exports.GetActivity = GetActivity;


/*
    GetProfile
    Returns information about the Uber user that has authorized with the application.
*/


var GetProfile = function(session) {
    /*
        Create a new instance of the GetProfile Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Uber/User/GetProfile"
    GetProfile.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetProfileResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetProfileInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetProfile
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetProfileInputSet = function() {
    GetProfileInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) A valid Access Token retrieved during the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetProfile Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetProfileResultSet = function(resultStream) {
    GetProfileResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Uber.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetProfile, choreography.Choreography);
util.inherits(GetProfileInputSet, choreography.InputSet);
util.inherits(GetProfileResultSet, choreography.ResultSet);
exports.GetProfile = GetProfile;

