
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetResources
    List available resources for a specified API version.
*/


var GetResources = function(session) {
    /*
        Create a new instance of the GetResources Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Salesforce/Resources/GetResources"
    GetResources.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetResourcesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetResourcesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetResources
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetResourcesInputSet = function() {
    GetResourcesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Salesforce. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Salesforce. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the InstanceName input for this Choreo. ((required, string) The server url prefix that indicates which instance your Salesforce account is on (e.g. na1, na2, na3, etc).)
        */
        this.set_InstanceName = function(value) {
            this.setInput("InstanceName", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Version input for this Choreo. ((optional, string) The API version number to retrieve resources for. Defaults to "v28.0".)
        */
        this.set_Version = function(value) {
            this.setInput("Version", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetResources Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetResourcesResultSet = function(resultStream) {
    GetResourcesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Salesforce.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetResources, choreography.Choreography);
util.inherits(GetResourcesInputSet, choreography.InputSet);
util.inherits(GetResourcesResultSet, choreography.ResultSet);
exports.GetResources = GetResources;

