
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetLogEntry
    Returns details for a specific incident log entry.
*/


var GetLogEntry = function(session) {
    /*
        Create a new instance of the GetLogEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/LogEntries/GetLogEntry"
    GetLogEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLogEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLogEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLogEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLogEntryInputSet = function() {
    GetLogEntryInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the LogEntryID input for this Choreo. ((required, string) The ID of the log entry to return.)
        */
        this.set_LogEntryID = function(value) {
            this.setInput("LogEntryID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLogEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLogEntryResultSet = function(resultStream) {
    GetLogEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLogEntry, choreography.Choreography);
util.inherits(GetLogEntryInputSet, choreography.InputSet);
util.inherits(GetLogEntryResultSet, choreography.ResultSet);
exports.GetLogEntry = GetLogEntry;


/*
    ListLogEntries
    Lists all incident log entries across an entire account.
*/


var ListLogEntries = function(session) {
    /*
        Create a new instance of the ListLogEntries Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/LogEntries/ListLogEntries"
    ListLogEntries.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListLogEntriesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListLogEntriesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListLogEntries
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListLogEntriesInputSet = function() {
    ListLogEntriesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Include input for this Choreo. ((optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.)
        */
        this.set_Include = function(value) {
            this.setInput("Include", value);
        }

        /*
        Set the value of the IsOverview input for this Choreo. ((optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.)
        */
        this.set_IsOverview = function(value) {
            this.setInput("IsOverview", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of log entries returned. Default (and max limit) is 100.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) The offset of the first log entry record returned. Default is 0.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListLogEntries Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListLogEntriesResultSet = function(resultStream) {
    ListLogEntriesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListLogEntries, choreography.Choreography);
util.inherits(ListLogEntriesInputSet, choreography.InputSet);
util.inherits(ListLogEntriesResultSet, choreography.ResultSet);
exports.ListLogEntries = ListLogEntries;


/*
    ListLogEntriesByIncident
    Lists all incident log entries associated with a specific incident.
*/


var ListLogEntriesByIncident = function(session) {
    /*
        Create a new instance of the ListLogEntriesByIncident Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/LogEntries/ListLogEntriesByIncident"
    ListLogEntriesByIncident.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListLogEntriesByIncidentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListLogEntriesByIncidentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListLogEntriesByIncident
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListLogEntriesByIncidentInputSet = function() {
    ListLogEntriesByIncidentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the IncidentID input for this Choreo. ((required, string) The ID of the incident associated with the log entries to retrieve.)
        */
        this.set_IncidentID = function(value) {
            this.setInput("IncidentID", value);
        }

        /*
        Set the value of the Include input for this Choreo. ((optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.)
        */
        this.set_Include = function(value) {
            this.setInput("Include", value);
        }

        /*
        Set the value of the IsOverview input for this Choreo. ((optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.)
        */
        this.set_IsOverview = function(value) {
            this.setInput("IsOverview", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of log events returned. Default (and max limit) is 100.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) The offset of the first log event record returned. Default is 0.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListLogEntriesByIncident Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListLogEntriesByIncidentResultSet = function(resultStream) {
    ListLogEntriesByIncidentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListLogEntriesByIncident, choreography.Choreography);
util.inherits(ListLogEntriesByIncidentInputSet, choreography.InputSet);
util.inherits(ListLogEntriesByIncidentResultSet, choreography.ResultSet);
exports.ListLogEntriesByIncident = ListLogEntriesByIncident;


/*
    ListLogEntriesByUser
    Lists all incident log entries associated with a specific user.
*/


var ListLogEntriesByUser = function(session) {
    /*
        Create a new instance of the ListLogEntriesByUser Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/LogEntries/ListLogEntriesByUser"
    ListLogEntriesByUser.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListLogEntriesByUserResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListLogEntriesByUserInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListLogEntriesByUser
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListLogEntriesByUserInputSet = function() {
    ListLogEntriesByUserInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Include input for this Choreo. ((optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.)
        */
        this.set_Include = function(value) {
            this.setInput("Include", value);
        }

        /*
        Set the value of the IsOverview input for this Choreo. ((optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.)
        */
        this.set_IsOverview = function(value) {
            this.setInput("IsOverview", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of log events returned. Default (and max limit) is 100.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) The offset of the first log event record returned. Default is 0.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((required, string) The ID of the user associated with the log entries to retrieve.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListLogEntriesByUser Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListLogEntriesByUserResultSet = function(resultStream) {
    ListLogEntriesByUserResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListLogEntriesByUser, choreography.Choreography);
util.inherits(ListLogEntriesByUserInputSet, choreography.InputSet);
util.inherits(ListLogEntriesByUserResultSet, choreography.ResultSet);
exports.ListLogEntriesByUser = ListLogEntriesByUser;

