
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Track
    Records an event in Mixpanel.
*/


var Track = function(session) {
    /*
        Create a new instance of the Track Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Events/Track"
    Track.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TrackResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TrackInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Track
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TrackInputSet = function() {
    TrackInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((optional, string) Used to uniquely identify a user associated with your event. When provided, you can track a given user through funnels and distinguish unique users for retention analyses.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) A name for the event (e.g., Signed Up, Uploaded Photo, etc).)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the EventProperties input for this Choreo. ((optional, json) Additional properties associated with the event formatted as name/value pairs in a JSON object. These properties can be used for segmentation and funnels.)
        */
        this.set_EventProperties = function(value) {
            this.setInput("EventProperties", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the event (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time the event occurred. If not provided, Mixpanel will use the time the event arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Track Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TrackResultSet = function(resultStream) {
    TrackResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Track, choreography.Choreography);
util.inherits(TrackInputSet, choreography.InputSet);
util.inherits(TrackResultSet, choreography.ResultSet);
exports.Track = Track;

