
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Average
    Averages an expression for events per unit time.
*/


var Average = function(session) {
    /*
        Create a new instance of the Average Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Segmentation/Average"
    Average.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AverageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AverageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Average
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AverageInputSet = function() {
    AverageInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The event that you wish to segment on.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to begin querying for the event from. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the On input for this Choreo. ((required, string) The expression to average per unit time. The result of the expression should be a numeric value (e.g., properties["time"]. See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to stop querying for the event from. This date is inclusive. The date range may not be more than 30 days.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) Determines the buckets into which the property values that you segment on are placed. Valid values are: hour or day.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., properties["time"] >= 2000). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Average Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AverageResultSet = function(resultStream) {
    AverageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Average, choreography.Choreography);
util.inherits(AverageInputSet, choreography.InputSet);
util.inherits(AverageResultSet, choreography.ResultSet);
exports.Average = Average;


/*
    Numeric
    Gets data for an event, segmented and filtered by properties, with values placed into numeric buckets.
*/


var Numeric = function(session) {
    /*
        Create a new instance of the Numeric Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Segmentation/Numeric"
    Numeric.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new NumericResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new NumericInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Numeric
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var NumericInputSet = function() {
    NumericInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Buckets input for this Choreo. ((required, integer) The number of buckets that you wish to divide the numeric values up into. Bucket ranges are automatically computed based on the maximum and minimum of the 'On' expression.)
        */
        this.set_Buckets = function(value) {
            this.setInput("Buckets", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The event that you wish to segment on.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to begin querying for the event from. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the On input for this Choreo. ((required, string) The property expression to segment the event on. Must be a numeric expression (e.g., number(properties["time"]). See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to stop querying for the event from. This date is inclusive.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) Determines the buckets into which the property values that you segment on are placed. Valid values are: hour or day.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., number(properties["time"]) >= 2000). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Numeric Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var NumericResultSet = function(resultStream) {
    NumericResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Numeric, choreography.Choreography);
util.inherits(NumericInputSet, choreography.InputSet);
util.inherits(NumericResultSet, choreography.ResultSet);
exports.Numeric = Numeric;


/*
    SegmentationData
    Gets data for an event, segmented and filtered by properties.
*/


var SegmentationData = function(session) {
    /*
        Create a new instance of the SegmentationData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Segmentation/SegmentationData"
    SegmentationData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SegmentationDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SegmentationDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SegmentationData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SegmentationDataInputSet = function() {
    SegmentationDataInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The event that you wish to segment on.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to begin querying for the event from. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) Return the top limit property values. This parameter is ignored if the On input is not specified.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the On input for this Choreo. ((optional, string) The property expression to segment the event on (e.g., properties["Referred By"] == "Friend"). See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to stop querying for the event from. This date is inclusive.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) Determines the buckets into which the property values that you segment on are placed. Valid values are: minute, hour, day (the default), or month.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., properties["Signed Up"]). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SegmentationData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SegmentationDataResultSet = function(resultStream) {
    SegmentationDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SegmentationData, choreography.Choreography);
util.inherits(SegmentationDataInputSet, choreography.InputSet);
util.inherits(SegmentationDataResultSet, choreography.ResultSet);
exports.SegmentationData = SegmentationData;


/*
    Sum
    Sums an expression for events per unit time.
*/


var Sum = function(session) {
    /*
        Create a new instance of the Sum Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Segmentation/Sum"
    Sum.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SumResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SumInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Sum
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SumInputSet = function() {
    SumInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The event that you wish to segment on.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to begin querying for the event from. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the On input for this Choreo. ((required, string) The expression to sum per unit time. Must be a numeric expression (e.g., number(properties["time"]). See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((required, date) The date in yyyy-mm-dd format from which to stop querying for the event from. This date is inclusive. The date range may not be more than 30 days.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) Determines the buckets into which the property values that you segment on are placed. Valid values are: hour or day.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., number(properties["time"]) >= 2000). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Sum Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SumResultSet = function(resultStream) {
    SumResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Sum, choreography.Choreography);
util.inherits(SumInputSet, choreography.InputSet);
util.inherits(SumResultSet, choreography.ResultSet);
exports.Sum = Sum;

