
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddTranslation
    Retrieves an array of all translations for a given text.
*/


var AddTranslation = function(session) {
    /*
        Create a new instance of the AddTranslation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/AddTranslation"
    AddTranslation.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddTranslationResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddTranslationInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddTranslation
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddTranslationInputSet = function() {
    AddTranslationInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The supported formats are "text/plain" and "text/html".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) A string containing the ISO 639-1 language code of the source language. Must be one of the languages returned by the method GetLanguagesForTranslate.(e.g., en).)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the OriginalText input for this Choreo. ((required, string) A string containing the text to translate from. The string has a maximum length of 1000 characters.)
        */
        this.set_OriginalText = function(value) {
            this.setInput("OriginalText", value);
        }

        /*
        Set the value of the Rating input for this Choreo. ((optional, integer) An integer representing the quality rating for this string. Value between -10 and 10. Defaults to 1.)
        */
        this.set_Rating = function(value) {
            this.setInput("Rating", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string containing the lISO 639-1 language code of the target language. Must be one of the languages returned by the method GetLanguagesForTranslate (e.g., es).)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the TranslatedText input for this Choreo. ((required, string) A string containing translated text in the target language. The string has a maximum length of 2000 characters.)
        */
        this.set_TranslatedText = function(value) {
            this.setInput("TranslatedText", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((optional, string) A string containing the content location of this translation.)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

        /*
        Set the value of the User input for this Choreo. ((required, string) A string used to track the originator of the submission.)
        */
        this.set_User = function(value) {
            this.setInput("User", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddTranslation Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddTranslationResultSet = function(resultStream) {
    AddTranslationResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddTranslation, choreography.Choreography);
util.inherits(AddTranslationInputSet, choreography.InputSet);
util.inherits(AddTranslationResultSet, choreography.ResultSet);
exports.AddTranslation = AddTranslation;


/*
    AddTranslationArray
    Adds an array of translations to add translation memory.
*/


var AddTranslationArray = function(session) {
    /*
        Create a new instance of the AddTranslationArray Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/AddTranslationArray"
    AddTranslationArray.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddTranslationArrayResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddTranslationArrayInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddTranslationArray
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddTranslationArrayInputSet = function() {
    AddTranslationArrayInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The supported formats are "text/plain" and "text/html".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) A string containing the ISO 639-1 language code of the source language (e.g., en). Must be one of the languages returned by the method GetLanguagesForTranslate.)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string containing the ISO 639-1 language code of the target language (e.g., es). Must be one of the languages returned by the method GetLanguagesForTranslate.)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the Translations input for this Choreo. ((required, json) An array containing translations to add to translation memory. Each translation must contain: OriginalText, TranslatedText, and Rating. See Choreo description for formatting examples.)
        */
        this.set_Translations = function(value) {
            this.setInput("Translations", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((optional, string) A string containing the content location of this translation.)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

        /*
        Set the value of the User input for this Choreo. ((required, string) A string used to track the originator of the submission.)
        */
        this.set_User = function(value) {
            this.setInput("User", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddTranslationArray Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddTranslationArrayResultSet = function(resultStream) {
    AddTranslationArrayResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddTranslationArray, choreography.Choreography);
util.inherits(AddTranslationArrayInputSet, choreography.InputSet);
util.inherits(AddTranslationArrayResultSet, choreography.ResultSet);
exports.AddTranslationArray = AddTranslationArray;


/*
    BreakSentences
    Breaks a piece of text into sentences and returns an array containing the lengths in each sentence.
*/


var BreakSentences = function(session) {
    /*
        Create a new instance of the BreakSentences Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/BreakSentences"
    BreakSentences.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new BreakSentencesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new BreakSentencesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the BreakSentences
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var BreakSentencesInputSet = function() {
    BreakSentencesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((required, string) A string representing the ISO 639-1 language code of input text.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) A string representing the text to split into sentences. The size of the text must not exceed 10000 characters.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the BreakSentences Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var BreakSentencesResultSet = function(resultStream) {
    BreakSentencesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(BreakSentences, choreography.Choreography);
util.inherits(BreakSentencesInputSet, choreography.InputSet);
util.inherits(BreakSentencesResultSet, choreography.ResultSet);
exports.BreakSentences = BreakSentences;


/*
    Detect
    Identifies the language of a selected piece of text.
*/


var Detect = function(session) {
    /*
        Create a new instance of the Detect Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/Detect"
    Detect.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DetectResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DetectInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Detect
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DetectInputSet = function() {
    DetectInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) A string containing some text whose language is to be identified. The size of the text must not exceed 10000 characters.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Detect Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DetectResultSet = function(resultStream) {
    DetectResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Detect, choreography.Choreography);
util.inherits(DetectInputSet, choreography.InputSet);
util.inherits(DetectResultSet, choreography.ResultSet);
exports.Detect = Detect;


/*
    DetectArray
    Identifies the language of an array of text strings.
*/


var DetectArray = function(session) {
    /*
        Create a new instance of the DetectArray Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/DetectArray"
    DetectArray.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DetectArrayResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DetectArrayInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DetectArray
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DetectArrayInputSet = function() {
    DetectArrayInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Texts input for this Choreo. ((required, json) A JSON array representing the text from an unknown language. The size of the text must not exceed 10000 characters.)
        */
        this.set_Texts = function(value) {
            this.setInput("Texts", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DetectArray Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DetectArrayResultSet = function(resultStream) {
    DetectArrayResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DetectArray, choreography.Choreography);
util.inherits(DetectArrayInputSet, choreography.InputSet);
util.inherits(DetectArrayResultSet, choreography.ResultSet);
exports.DetectArray = DetectArray;


/*
    GetLanguageNames
    Retrieves friendly names for languages and localized using the specified locale language.
*/


var GetLanguageNames = function(session) {
    /*
        Create a new instance of the GetLanguageNames Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetLanguageNames"
    GetLanguageNames.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLanguageNamesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLanguageNamesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLanguageNames
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLanguageNamesInputSet = function() {
    GetLanguageNamesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the LanguageCodes input for this Choreo. ((required, json) An array of ISO 639-1 language codes to retrieve friendly names for.)
        */
        this.set_LanguageCodes = function(value) {
            this.setInput("LanguageCodes", value);
        }

        /*
        Set the value of the Locale input for this Choreo. ((required, string) The ISO 639-1 language code associated with the language you wish to return results in.)
        */
        this.set_Locale = function(value) {
            this.setInput("Locale", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLanguageNames Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLanguageNamesResultSet = function(resultStream) {
    GetLanguageNamesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLanguageNames, choreography.Choreography);
util.inherits(GetLanguageNamesInputSet, choreography.InputSet);
util.inherits(GetLanguageNamesResultSet, choreography.ResultSet);
exports.GetLanguageNames = GetLanguageNames;


/*
    GetLanguagesForSpeak
    Retrieves the languages available for speech synthesis.
*/


var GetLanguagesForSpeak = function(session) {
    /*
        Create a new instance of the GetLanguagesForSpeak Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetLanguagesForSpeak"
    GetLanguagesForSpeak.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLanguagesForSpeakResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLanguagesForSpeakInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLanguagesForSpeak
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLanguagesForSpeakInputSet = function() {
    GetLanguagesForSpeakInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLanguagesForSpeak Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLanguagesForSpeakResultSet = function(resultStream) {
    GetLanguagesForSpeakResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLanguagesForSpeak, choreography.Choreography);
util.inherits(GetLanguagesForSpeakInputSet, choreography.InputSet);
util.inherits(GetLanguagesForSpeakResultSet, choreography.ResultSet);
exports.GetLanguagesForSpeak = GetLanguagesForSpeak;


/*
    GetLanguagesForTranslate
    Retrieves a list of language codes representing languages that are supported by the Translation Service.
*/


var GetLanguagesForTranslate = function(session) {
    /*
        Create a new instance of the GetLanguagesForTranslate Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetLanguagesForTranslate"
    GetLanguagesForTranslate.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLanguagesForTranslateResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLanguagesForTranslateInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLanguagesForTranslate
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLanguagesForTranslateInputSet = function() {
    GetLanguagesForTranslateInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLanguagesForTranslate Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLanguagesForTranslateResultSet = function(resultStream) {
    GetLanguagesForTranslateResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLanguagesForTranslate, choreography.Choreography);
util.inherits(GetLanguagesForTranslateInputSet, choreography.InputSet);
util.inherits(GetLanguagesForTranslateResultSet, choreography.ResultSet);
exports.GetLanguagesForTranslate = GetLanguagesForTranslate;


/*
    GetToken
    Retrieves an access token that can be used to authenticate with the Microsoft Translator API.
*/


var GetToken = function(session) {
    /*
        Create a new instance of the GetToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetToken"
    GetToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTokenInputSet = function() {
    GetTokenInputSet.super_.call(this);
        /*
        Set the value of the ClientID input for this Choreo. ((required, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((required, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTokenResultSet = function(resultStream) {
    GetTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "AccessToken" output from this Choreo execution. ((string) The access token returned from Microsoft.)
        */
        this.get_AccessToken = function() {
            return this.getResult("AccessToken");
        }
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) The number of seconds for which the access token is valid.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
}

util.inherits(GetToken, choreography.Choreography);
util.inherits(GetTokenInputSet, choreography.InputSet);
util.inherits(GetTokenResultSet, choreography.ResultSet);
exports.GetToken = GetToken;


/*
    GetTranslations
    Retrieves an array of all translations for a given text.
*/


var GetTranslations = function(session) {
    /*
        Create a new instance of the GetTranslations Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetTranslations"
    GetTranslations.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTranslationsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTranslationsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTranslations
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTranslationsInputSet = function() {
    GetTranslationsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The only supported, and the default, option is "text/plain".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the MaxTranslations input for this Choreo. ((required, integer) An integer representing the maximum number of translations to return.)
        */
        this.set_MaxTranslations = function(value) {
            this.setInput("MaxTranslations", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the State input for this Choreo. ((optional, string) User state to help correlate request and response. The same contents will be returned in the response.)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((optional, string) Filter results by this URI. Default: all)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

        /*
        Set the value of the User input for this Choreo. ((optional, string) Filter results by this user. Default: all)
        */
        this.set_User = function(value) {
            this.setInput("User", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTranslations Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTranslationsResultSet = function(resultStream) {
    GetTranslationsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetTranslations, choreography.Choreography);
util.inherits(GetTranslationsInputSet, choreography.InputSet);
util.inherits(GetTranslationsResultSet, choreography.ResultSet);
exports.GetTranslations = GetTranslations;


/*
    GetTranslationsArray
    Retrieves multiple translation candidates for multiple source texts.
*/


var GetTranslationsArray = function(session) {
    /*
        Create a new instance of the GetTranslationsArray Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/GetTranslationsArray"
    GetTranslationsArray.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTranslationsArrayResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTranslationsArrayInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTranslationsArray
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTranslationsArrayInputSet = function() {
    GetTranslationsArrayInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The only supported, and the default, option is "text/plain".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the MaxTranslations input for this Choreo. ((required, integer) An integer representing the maximum number of translations to return.)
        */
        this.set_MaxTranslations = function(value) {
            this.setInput("MaxTranslations", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the State input for this Choreo. ((optional, string) User state to help correlate request and response. The same contents will be returned in the response.)
        */
        this.set_State = function(value) {
            this.setInput("State", value);
        }

        /*
        Set the value of the Texts input for this Choreo. ((required, json) An array containing the texts for translation. All strings must be of the same language. The total of all texts must not exceed 10000 characters. The max number of array items is 2000.)
        */
        this.set_Texts = function(value) {
            this.setInput("Texts", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((optional, string) Filter results by this URI. Default: all)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

        /*
        Set the value of the User input for this Choreo. ((optional, string) Filter results by this user. Default: all)
        */
        this.set_User = function(value) {
            this.setInput("User", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTranslationsArray Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTranslationsArrayResultSet = function(resultStream) {
    GetTranslationsArrayResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetTranslationsArray, choreography.Choreography);
util.inherits(GetTranslationsArrayInputSet, choreography.InputSet);
util.inherits(GetTranslationsArrayResultSet, choreography.ResultSet);
exports.GetTranslationsArray = GetTranslationsArray;


/*
    Speak
    Returns a Base64 encoded wave or mp3 file of the passed-in text being spoken in the desired language.
*/


var Speak = function(session) {
    /*
        Create a new instance of the Speak Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/Speak"
    Speak.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SpeakResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SpeakInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Speak
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SpeakInputSet = function() {
    SpeakInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((optional, string) A string specifying the content-type. Currently, "audio/wav" and "audio/mp3" are available. The default value is "audio/wav".)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((required, string) A string representing the supported ISO 639-1 language code to speak the text in (e.g., es). The code must be present in the list of codes returned from the method GetLanguagesForSpeak.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Options input for this Choreo. ((optional, string) A string specifying the quality of the audio signals. Valid values are: MaxQuality or MinQuality (the default).)
        */
        this.set_Options = function(value) {
            this.setInput("Options", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Speak Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SpeakResultSet = function(resultStream) {
    SpeakResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "AudioFile" output from this Choreo execution. ((string) The Base64 encoded audio file in mp3 or wav format.)
        */
        this.get_AudioFile = function() {
            return this.getResult("AudioFile");
        }
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
}

util.inherits(Speak, choreography.Choreography);
util.inherits(SpeakInputSet, choreography.InputSet);
util.inherits(SpeakResultSet, choreography.ResultSet);
exports.Speak = Speak;


/*
    Translate
    Translates a text string from one language to another.
*/


var Translate = function(session) {
    /*
        Create a new instance of the Translate Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/Translate"
    Translate.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TranslateResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TranslateInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Translate
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TranslateInputSet = function() {
    TranslateInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string representing the ISO 639-1 language codee to translate the text into (e.g., es).)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Translate Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TranslateResultSet = function(resultStream) {
    TranslateResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "TranslatedText" output from this Choreo execution. ((string) The translated text parsed from the Microsoft response.)
        */
        this.get_TranslatedText = function() {
            return this.getResult("TranslatedText");
        }
}

util.inherits(Translate, choreography.Choreography);
util.inherits(TranslateInputSet, choreography.InputSet);
util.inherits(TranslateResultSet, choreography.ResultSet);
exports.Translate = Translate;


/*
    TranslateArray
    Translates multiple source texts.
*/


var TranslateArray = function(session) {
    /*
        Create a new instance of the TranslateArray Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Translator/TranslateArray"
    TranslateArray.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TranslateArrayResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TranslateArrayInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TranslateArray
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TranslateArrayInputSet = function() {
    TranslateArrayInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Category input for this Choreo. ((optional, string) A string containing the category (domain) of the translation. Defaults to "general".)
        */
        this.set_Category = function(value) {
            this.setInput("Category", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the From input for this Choreo. ((optional, string) A string representing the language code of the translation text (e.g., en). If not provided auto-detection is used.)
        */
        this.set_From = function(value) {
            this.setInput("From", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Texts input for this Choreo. ((required, json) An array containing the texts for translation. All strings must be of the same language. The total of all texts must not exceed 10000 characters. The max number of array items is 2000.)
        */
        this.set_Texts = function(value) {
            this.setInput("Texts", value);
        }

        /*
        Set the value of the To input for this Choreo. ((required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).)
        */
        this.set_To = function(value) {
            this.setInput("To", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((optional, string) Filter results by this URI. Default: all)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

        /*
        Set the value of the User input for this Choreo. ((optional, multiline) Filter results by this user. Default: all)
        */
        this.set_User = function(value) {
            this.setInput("User", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TranslateArray Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TranslateArrayResultSet = function(resultStream) {
    TranslateArrayResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ExpiresIn" output from this Choreo execution. ((integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.)
        */
        this.get_ExpiresIn = function() {
            return this.getResult("ExpiresIn");
        }
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the ClientID and ClientSecret are provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TranslateArray, choreography.Choreography);
util.inherits(TranslateArrayInputSet, choreography.InputSet);
util.inherits(TranslateArrayResultSet, choreography.ResultSet);
exports.TranslateArray = TranslateArray;

