
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    InvokeFunction
    Invokes a workbook function.
*/


var InvokeFunction = function(session) {
    /*
        Create a new instance of the InvokeFunction Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Workbook/InvokeFunction"
    InvokeFunction.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new InvokeFunctionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new InvokeFunctionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the InvokeFunction
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var InvokeFunctionInputSet = function() {
    InvokeFunctionInputSet.super_.call(this);
        /*
        Set the value of the Arguments input for this Choreo. ((required, json) A JSON object containing the function arguments. See Choreo notes for more details.)
        */
        this.set_Arguments = function(value) {
            this.setInput("Arguments", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Function input for this Choreo. ((required, string) The name of the function (e.g. vlookup).)
        */
        this.set_Function = function(value) {
            this.setInput("Function", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the InvokeFunction Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var InvokeFunctionResultSet = function(resultStream) {
    InvokeFunctionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(InvokeFunction, choreography.Choreography);
util.inherits(InvokeFunctionInputSet, choreography.InputSet);
util.inherits(InvokeFunctionResultSet, choreography.ResultSet);
exports.InvokeFunction = InvokeFunction;

