
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    DeletePlace
    Delete a new Place from Google Places.
*/


var DeletePlace = function(session) {
    /*
        Create a new instance of the DeletePlace Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/DeletePlace"
    DeletePlace.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeletePlaceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeletePlaceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeletePlace
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeletePlaceInputSet = function() {
    DeletePlaceInputSet.super_.call(this);
        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the PlaceID input for this Choreo. ((conditional, string) A textual identifier that uniquely identifies a place.)
        */
        this.set_PlaceID = function(value) {
            this.setInput("PlaceID", value);
        }

        /*
        Set the value of the PlaceReference input for this Choreo. ((optional, string) A textual identifier that uniquely identifies a place. Note, this parameter is deprecated as of June 24, 2014. Use PlaceID instead.)
        */
        this.set_PlaceReference = function(value) {
            this.setInput("PlaceReference", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeletePlace Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeletePlaceResultSet = function(resultStream) {
    DeletePlaceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeletePlace, choreography.Choreography);
util.inherits(DeletePlaceInputSet, choreography.InputSet);
util.inherits(DeletePlaceResultSet, choreography.ResultSet);
exports.DeletePlace = DeletePlace;


/*
    PlaceDetails
    Retrieve detailed information about places retrieved by the PlaceSearch Choreo.
*/


var PlaceDetails = function(session) {
    /*
        Create a new instance of the PlaceDetails Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/PlaceDetails"
    PlaceDetails.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PlaceDetailsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PlaceDetailsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PlaceDetails
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PlaceDetailsInputSet = function() {
    PlaceDetailsInputSet.super_.call(this);
        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the PlaceID input for this Choreo. ((conditional, string) A textual identifier that uniquely identifies a place. PlaceIDs are returned by the PlaceSearch Choreo.)
        */
        this.set_PlaceID = function(value) {
            this.setInput("PlaceID", value);
        }

        /*
        Set the value of the Reference input for this Choreo. ((optional, string) A textual identifier that uniquely identifies a place. Note, this parameter is deprecated as of June 24, 2014. Use PlaceID instead.)
        */
        this.set_Reference = function(value) {
            this.setInput("Reference", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PlaceDetails Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PlaceDetailsResultSet = function(resultStream) {
    PlaceDetailsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PlaceDetails, choreography.Choreography);
util.inherits(PlaceDetailsInputSet, choreography.InputSet);
util.inherits(PlaceDetailsResultSet, choreography.ResultSet);
exports.PlaceDetails = PlaceDetails;


/*
    PlaceSearch
    Search for places based on latitude/longitude coordinates, keywords, and distance.
*/


var PlaceSearch = function(session) {
    /*
        Create a new instance of the PlaceSearch Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/PlaceSearch"
    PlaceSearch.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PlaceSearchResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PlaceSearchInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PlaceSearch
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PlaceSearchInputSet = function() {
    PlaceSearchInputSet.super_.call(this);
        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the Keyword input for this Choreo. ((optional, string) Enter a keyword (term, address, type, customer review, etc.) to be matched against all results retrieved for this Place.)
        */
        this.set_Keyword = function(value) {
            this.setInput("Keyword", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, string) Specify a latitude point around which Places results will be retrieved (e.g., 38.898717).)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, string) Specify a longitude point around which Places results will be retrieved (e.g., -77.035974).)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the MaxPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MaxPrice = function(value) {
            this.setInput("MaxPrice", value);
        }

        /*
        Set the value of the MinPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MinPrice = function(value) {
            this.setInput("MinPrice", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((optional, string) Enter a name to be matched when results are retrieved for this specified Place.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the OpenNow input for this Choreo. ((optional, boolean) Returns only those Places that are open for business at the time the query is sent. Places that do not specify opening hours in the Google Places database will not be returned.)
        */
        this.set_OpenNow = function(value) {
            this.setInput("OpenNow", value);
        }

        /*
        Set the value of the PageToken input for this Choreo. ((optional, string) The "NextPageToken" returned in the choreo output from a previous run. Used to page through large result sets. When the PageToken is specified, all other inputs are ignored.)
        */
        this.set_PageToken = function(value) {
            this.setInput("PageToken", value);
        }

        /*
        Set the value of the Radius input for this Choreo. ((required, integer) Specify the radius in meters for which Places results will be returned. Maximum radius is limited to 50,000 meters. If rankby=distance, then radius must not be specified.)
        */
        this.set_Radius = function(value) {
            this.setInput("Radius", value);
        }

        /*
        Set the value of the RankBy input for this Choreo. ((optional, string) Specify how results are listed. Values include: prominence (default); distance - sorts results by distance from specified location. Radius must not be used, and Keyword, Name, or Types are required).)
        */
        this.set_RankBy = function(value) {
            this.setInput("RankBy", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

        /*
        Set the value of the Types input for this Choreo. ((optional, string) Filter results by types, such as: bar, dentist.  Multiple types must be separated by the pipe ("|") symbol: bar|dentist|airport.)
        */
        this.set_Types = function(value) {
            this.setInput("Types", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PlaceSearch Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PlaceSearchResultSet = function(resultStream) {
    PlaceSearchResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PlaceSearch, choreography.Choreography);
util.inherits(PlaceSearchInputSet, choreography.InputSet);
util.inherits(PlaceSearchResultSet, choreography.ResultSet);
exports.PlaceSearch = PlaceSearch;


/*
    RadarSearch
    Search up to 200 places at once.   RadarSearch helps identify specific areas of interest within a geographic area.
*/


var RadarSearch = function(session) {
    /*
        Create a new instance of the RadarSearch Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/RadarSearch"
    RadarSearch.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RadarSearchResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RadarSearchInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RadarSearch
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RadarSearchInputSet = function() {
    RadarSearchInputSet.super_.call(this);
        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the Keyword input for this Choreo. ((conditional, string) Enter a keyword (term, address, type, customer review, etc.) to be matched against all results retrieved for this Place.  At least one of Keyword, Name or Types must be specified.)
        */
        this.set_Keyword = function(value) {
            this.setInput("Keyword", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, string) Specify a latitude point around which Places results will be retrieved (e.g., 38.898717).)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, string) Specify a longitude point around which Places results will be retrieved (e.g., -77.035974).)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the MaxPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MaxPrice = function(value) {
            this.setInput("MaxPrice", value);
        }

        /*
        Set the value of the MinPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MinPrice = function(value) {
            this.setInput("MinPrice", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((conditional, string) Enter a name to be matched when results are retrieved for this specified Place.  At least one of Keyword, Name or Types must be specified.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the OpenNow input for this Choreo. ((optional, boolean) Returns only those Places that are open for business at the time the query is sent. Places that do not specify opening hours in the Google Places database will not be returned.)
        */
        this.set_OpenNow = function(value) {
            this.setInput("OpenNow", value);
        }

        /*
        Set the value of the PageToken input for this Choreo. ((optional, string) The "NextPageToken" returned in the choreo output from a previous run. Used to page through large result sets. When the PageToken is specified, all other inputs are ignored.)
        */
        this.set_PageToken = function(value) {
            this.setInput("PageToken", value);
        }

        /*
        Set the value of the Radius input for this Choreo. ((required, integer) Specify the radius in meters for which Places results will be returned. Maximum radius is limited to 50,000 meters.)
        */
        this.set_Radius = function(value) {
            this.setInput("Radius", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

        /*
        Set the value of the Types input for this Choreo. ((conditional, string) Filter results by types, such as: bar, dentist.  Multiple types must be separated by the pipe ("|") symbol: bar|dentist|airport.   At least one of Keyword, Name or Types must be specified.)
        */
        this.set_Types = function(value) {
            this.setInput("Types", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RadarSearch Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RadarSearchResultSet = function(resultStream) {
    RadarSearchResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RadarSearch, choreography.Choreography);
util.inherits(RadarSearchInputSet, choreography.InputSet);
util.inherits(RadarSearchResultSet, choreography.ResultSet);
exports.RadarSearch = RadarSearch;


/*
    TextSearch
    Search for places based on a text query and optional location.
*/


var TextSearch = function(session) {
    /*
        Create a new instance of the TextSearch Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/TextSearch"
    TextSearch.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TextSearchResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TextSearchInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TextSearch
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TextSearchInputSet = function() {
    TextSearchInputSet.super_.call(this);
        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language code, indicating in which language the results should be returned, if possible. See Choreo notes for a list of supported languages and their codes.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((optional, string) Specify a latitude point around which Places results will be retrieved (e.g., 38.898717). When specifying a latitude, both longitude and radius must also be supplied.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((optional, string) Specify a longitude point around which Places results will be retrieved (e.g., -77.035974). When specifying a longitude, both latitude and radius must also be supplied.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the MaxPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MaxPrice = function(value) {
            this.setInput("MaxPrice", value);
        }

        /*
        Set the value of the MinPrice input for this Choreo. ((optional, integer) Restricts results to only those places within the specified range. Valid values range between 0 (most affordable) to 4 (most expensive), inclusive. The exact amount will vary from region to region.)
        */
        this.set_MinPrice = function(value) {
            this.setInput("MinPrice", value);
        }

        /*
        Set the value of the OpenNow input for this Choreo. ((optional, boolean) Returns only those Places that are open for business at the time the query is sent. Places that do not specify opening hours in the Google Places database will not be returned.)
        */
        this.set_OpenNow = function(value) {
            this.setInput("OpenNow", value);
        }

        /*
        Set the value of the PageToken input for this Choreo. ((optional, string) The "NextPageToken" returned in the choreo output from a previous run. Used to page through large result sets. When the PageToken is specified, all other inputs are ignored.)
        */
        this.set_PageToken = function(value) {
            this.setInput("PageToken", value);
        }

        /*
        Set the value of the Query input for this Choreo. ((required, string) The text string on which to search, for example: "restaurant". The Place service will return candidate matches based on this string and order the results based on their perceived relevance.)
        */
        this.set_Query = function(value) {
            this.setInput("Query", value);
        }

        /*
        Set the value of the Radius input for this Choreo. ((optional, integer) Specify the radius in meters for which Places results will be returned. Maximum radius is limited to 50,000 meters. When specifying a radius, both latitude and longitude must also be supplied.)
        */
        this.set_Radius = function(value) {
            this.setInput("Radius", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

        /*
        Set the value of the Types input for this Choreo. ((optional, string) Filter results by types, such as: bar, dentist.  Multiple types must be separated by the pipe ("|") symbol: bar|dentist|airport.)
        */
        this.set_Types = function(value) {
            this.setInput("Types", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TextSearch Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TextSearchResultSet = function(resultStream) {
    TextSearchResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TextSearch, choreography.Choreography);
util.inherits(TextSearchInputSet, choreography.InputSet);
util.inherits(TextSearchResultSet, choreography.ResultSet);
exports.TextSearch = TextSearch;


/*
    UserPlaceReports
    Add a new Place to Google Places.
*/


var UserPlaceReports = function(session) {
    /*
        Create a new instance of the UserPlaceReports Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Places/UserPlaceReports"
    UserPlaceReports.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UserPlaceReportsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UserPlaceReportsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UserPlaceReports
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UserPlaceReportsInputSet = function() {
    UserPlaceReportsInputSet.super_.call(this);
        /*
        Set the value of the POSTForm input for this Choreo. ((optional, json) A JSON request body containing the information about the place. This can be specified as an alternative to specifying individual place properties. See Choreo notes for details about formatting.)
        */
        this.set_POSTForm = function(value) {
            this.setInput("POSTForm", value);
        }

        /*
        Set the value of the Accuracy input for this Choreo. ((conditional, decimal) The accuracy of the location signal on which this request is based, expressed in meters.)
        */
        this.set_Accuracy = function(value) {
            this.setInput("Accuracy", value);
        }

        /*
        Set the value of the Address input for this Choreo. ((optional, string) The address of the place you wish to add.)
        */
        this.set_Address = function(value) {
            this.setInput("Address", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, string) The API Key provided by Google.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((conditional, string) The language in which the place's name is being reported.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, decimal) The latitude point for the place you wish to add (e.g., 38.898717).)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, decimal) The longitude coordinate for the place you wish to add (e.g., -77.035974).)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((required, string) The full text name of the place)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the PhoneNumber input for this Choreo. ((optional, string) The phone number associated with the place.)
        */
        this.set_PhoneNumber = function(value) {
            this.setInput("PhoneNumber", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        */
        this.set_Sensor = function(value) {
            this.setInput("Sensor", value);
        }

        /*
        Set the value of the Types input for this Choreo. ((required, json) A JSON array of categories in which this place belongs.)
        */
        this.set_Types = function(value) {
            this.setInput("Types", value);
        }

        /*
        Set the value of the Website input for this Choreo. ((optional, string) A URL pointing to the authoritative website for this Place, such as a business home page.)
        */
        this.set_Website = function(value) {
            this.setInput("Website", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UserPlaceReports Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UserPlaceReportsResultSet = function(resultStream) {
    UserPlaceReportsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UserPlaceReports, choreography.Choreography);
util.inherits(UserPlaceReportsInputSet, choreography.InputSet);
util.inherits(UserPlaceReportsResultSet, choreography.ResultSet);
exports.UserPlaceReports = UserPlaceReports;

