
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ChangeSetting
    Changes a setting for the given user.
*/


var ChangeSetting = function(session) {
    /*
        Create a new instance of the ChangeSetting Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Foursquare/Settings/ChangeSetting"
    ChangeSetting.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ChangeSettingResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ChangeSettingInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ChangeSetting
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ChangeSettingInputSet = function() {
    ChangeSettingInputSet.super_.call(this);
        /*
        Set the value of the OauthToken input for this Choreo. ((conditional, string) The Foursquare API OAuth token string.)
        */
        this.set_OauthToken = function(value) {
            this.setInput("OauthToken", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SettingID input for this Choreo. ((required, string) Name of setting to change. Valid values are: sendMayorshipsToTwitter, sendBadgesToTwitter, sendMayorshipsToFacebook, sendBadgesToFacebook, receivePings, and receiveCommentPings.)
        */
        this.set_SettingID = function(value) {
            this.setInput("SettingID", value);
        }

        /*
        Set the value of the Value input for this Choreo. ((required, boolean) The value of the setting you want to change. Set to 1 for true, and 0 for false.)
        */
        this.set_Value = function(value) {
            this.setInput("Value", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ChangeSetting Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ChangeSettingResultSet = function(resultStream) {
    ChangeSettingResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ChangeSetting, choreography.Choreography);
util.inherits(ChangeSettingInputSet, choreography.InputSet);
util.inherits(ChangeSettingResultSet, choreography.ResultSet);
exports.ChangeSetting = ChangeSetting;


/*
    SettingDetail
    Returns a setting for the acting user.
*/


var SettingDetail = function(session) {
    /*
        Create a new instance of the SettingDetail Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Foursquare/Settings/SettingDetail"
    SettingDetail.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SettingDetailResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SettingDetailInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SettingDetail
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SettingDetailInputSet = function() {
    SettingDetailInputSet.super_.call(this);
        /*
        Set the value of the OauthToken input for this Choreo. ((conditional, string) The Foursquare API OAuth token string.)
        */
        this.set_OauthToken = function(value) {
            this.setInput("OauthToken", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the SettingID input for this Choreo. ((required, string) Name of setting to change. Valid values are: sendMayorshipsToTwitter, sendBadgesToTwitter, sendMayorshipsToFacebook, sendBadgesToFacebook, receivePings, and receiveCommentPings.)
        */
        this.set_SettingID = function(value) {
            this.setInput("SettingID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SettingDetail Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SettingDetailResultSet = function(resultStream) {
    SettingDetailResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SettingDetail, choreography.Choreography);
util.inherits(SettingDetailInputSet, choreography.InputSet);
util.inherits(SettingDetailResultSet, choreography.ResultSet);
exports.SettingDetail = SettingDetail;


/*
    UserSettings
    Returns the settings of the acting user.
*/


var UserSettings = function(session) {
    /*
        Create a new instance of the UserSettings Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Foursquare/Settings/UserSettings"
    UserSettings.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UserSettingsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UserSettingsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UserSettings
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UserSettingsInputSet = function() {
    UserSettingsInputSet.super_.call(this);
        /*
        Set the value of the OauthToken input for this Choreo. ((conditional, string) The Foursquare API OAuth token string.)
        */
        this.set_OauthToken = function(value) {
            this.setInput("OauthToken", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UserSettings Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UserSettingsResultSet = function(resultStream) {
    UserSettingsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UserSettings, choreography.Choreography);
util.inherits(UserSettingsInputSet, choreography.InputSet);
util.inherits(UserSettingsResultSet, choreography.ResultSet);
exports.UserSettings = UserSettings;

