
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetAccount
    Retrieves information about a user's account.
*/


var GetAccount = function(session) {
    /*
        Create a new instance of the GetAccount Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Users/GetAccount"
    GetAccount.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetAccountResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetAccountInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetAccount
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetAccountInputSet = function() {
    GetAccountInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AccountID input for this Choreo. ((required, string) A user's account identifier.)
        */
        this.set_AccountID = function(value) {
            this.setInput("AccountID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetAccount Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetAccountResultSet = function(resultStream) {
    GetAccountResultSet.super_.call(this, resultStream);    
}

util.inherits(GetAccount, choreography.Choreography);
util.inherits(GetAccountInputSet, choreography.InputSet);
util.inherits(GetAccountResultSet, choreography.ResultSet);
exports.GetAccount = GetAccount;


/*
    GetCurrentAccount
    Retrieves information about the current user's account.
*/


var GetCurrentAccount = function(session) {
    /*
        Create a new instance of the GetCurrentAccount Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Users/GetCurrentAccount"
    GetCurrentAccount.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetCurrentAccountResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetCurrentAccountInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetCurrentAccount
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetCurrentAccountInputSet = function() {
    GetCurrentAccountInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetCurrentAccount Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetCurrentAccountResultSet = function(resultStream) {
    GetCurrentAccountResultSet.super_.call(this, resultStream);    
}

util.inherits(GetCurrentAccount, choreography.Choreography);
util.inherits(GetCurrentAccountInputSet, choreography.InputSet);
util.inherits(GetCurrentAccountResultSet, choreography.ResultSet);
exports.GetCurrentAccount = GetCurrentAccount;

