
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetForecastByAddress
    Returns the current weather conditions for a specified location by address.
*/


var GetForecastByAddress = function(session) {
    /*
        Create a new instance of the GetForecastByAddress Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/DarkSky/GetForecastByAddress"
    GetForecastByAddress.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetForecastByAddressResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetForecastByAddressInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetForecastByAddress
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetForecastByAddressInputSet = function() {
    GetForecastByAddressInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Dark Sky.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Address input for this Choreo. ((required, string) The address of the location.)
        */
        this.set_Address = function(value) {
            this.setInput("Address", value);
        }

        /*
        Set the value of the Exclude input for this Choreo. ((optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.)
        */
        this.set_Exclude = function(value) {
            this.setInput("Exclude", value);
        }

        /*
        Set the value of the Extend input for this Choreo. ((optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.)
        */
        this.set_Extend = function(value) {
            this.setInput("Extend", value);
        }

        /*
        Set the value of the GeocodingAPIKey input for this Choreo. ((required, string) Your Google Geocoding API Key.)
        */
        this.set_GeocodingAPIKey = function(value) {
            this.setInput("GeocodingAPIKey", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetForecastByAddress Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetForecastByAddressResultSet = function(resultStream) {
    GetForecastByAddressResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "HourlySummary" output from this Choreo execution. ((string) The hourly summary.)
        */
        this.get_HourlySummary = function() {
            return this.getResult("HourlySummary");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Summary" output from this Choreo execution. ((string) The current weather summary.)
        */
        this.get_Summary = function() {
            return this.getResult("Summary");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((decimal) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "UVIndex" output from this Choreo execution. ((integer) The current uv index.)
        */
        this.get_UVIndex = function() {
            return this.getResult("UVIndex");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dark Sky.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetForecastByAddress, choreography.Choreography);
util.inherits(GetForecastByAddressInputSet, choreography.InputSet);
util.inherits(GetForecastByAddressResultSet, choreography.ResultSet);
exports.GetForecastByAddress = GetForecastByAddress;


/*
    GetForecastByCoordinates
    Returns the current weather conditions for a specified location by geo-coordinates.
*/


var GetForecastByCoordinates = function(session) {
    /*
        Create a new instance of the GetForecastByCoordinates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/DarkSky/GetForecastByCoordinates"
    GetForecastByCoordinates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetForecastByCoordinatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetForecastByCoordinatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetForecastByCoordinates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetForecastByCoordinatesInputSet = function() {
    GetForecastByCoordinatesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Dark Sky.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Exclude input for this Choreo. ((optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.)
        */
        this.set_Exclude = function(value) {
            this.setInput("Exclude", value);
        }

        /*
        Set the value of the Extend input for this Choreo. ((optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.)
        */
        this.set_Extend = function(value) {
            this.setInput("Extend", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, decimal) The latitude of the location.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, decimal) The longitude of the location.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetForecastByCoordinates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetForecastByCoordinatesResultSet = function(resultStream) {
    GetForecastByCoordinatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "HourlySummary" output from this Choreo execution. ((string) The hourly summary.)
        */
        this.get_HourlySummary = function() {
            return this.getResult("HourlySummary");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Summary" output from this Choreo execution. ((string) The current weather summary.)
        */
        this.get_Summary = function() {
            return this.getResult("Summary");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((decimal) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "UVIndex" output from this Choreo execution. ((integer) The current uv index.)
        */
        this.get_UVIndex = function() {
            return this.getResult("UVIndex");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dark Sky.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetForecastByCoordinates, choreography.Choreography);
util.inherits(GetForecastByCoordinatesInputSet, choreography.InputSet);
util.inherits(GetForecastByCoordinatesResultSet, choreography.ResultSet);
exports.GetForecastByCoordinates = GetForecastByCoordinates;


/*
    TimeMachineRequest
    Returns the observed (in the past) or forecasted (in the future) hour-by-hour weather and daily weather conditions for a particular date.
*/


var TimeMachineRequest = function(session) {
    /*
        Create a new instance of the TimeMachineRequest Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/DarkSky/TimeMachineRequest"
    TimeMachineRequest.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TimeMachineRequestResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TimeMachineRequestInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TimeMachineRequest
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TimeMachineRequestInputSet = function() {
    TimeMachineRequestInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Dark Sky.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Exclude input for this Choreo. ((optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.)
        */
        this.set_Exclude = function(value) {
            this.setInput("Exclude", value);
        }

        /*
        Set the value of the Extend input for this Choreo. ((optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.)
        */
        this.set_Extend = function(value) {
            this.setInput("Extend", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, decimal) The latitude of the location.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, decimal) The longitude of the location.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((required, date) A UNIX timestamp (seconds since midnight GMT on 1 Jan 1970) or a string formatted date e.g., 2016-03-05T15:48:56Z.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TimeMachineRequest Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TimeMachineRequestResultSet = function(resultStream) {
    TimeMachineRequestResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "HourlySummary" output from this Choreo execution. ((string) The hourly summary.)
        */
        this.get_HourlySummary = function() {
            return this.getResult("HourlySummary");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Summary" output from this Choreo execution. ((string) The current weather summary.)
        */
        this.get_Summary = function() {
            return this.getResult("Summary");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((decimal) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "UVIndex" output from this Choreo execution. ((integer) The current uv index.)
        */
        this.get_UVIndex = function() {
            return this.getResult("UVIndex");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dark Sky.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TimeMachineRequest, choreography.Choreography);
util.inherits(TimeMachineRequestInputSet, choreography.InputSet);
util.inherits(TimeMachineRequestResultSet, choreography.ResultSet);
exports.TimeMachineRequest = TimeMachineRequest;

