
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    BatchGetItem
    Returns the attributes of one or more items from one or more tables
*/


var BatchGetItem = function(session) {
    /*
        Create a new instance of the BatchGetItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/BatchGetItem"
    BatchGetItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new BatchGetItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new BatchGetItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the BatchGetItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var BatchGetItemInputSet = function() {
    BatchGetItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the RequestItems input for this Choreo. ((required, json) A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. See choreo notes for more details.)
        */
        this.set_RequestItems = function(value) {
            this.setInput("RequestItems", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the BatchGetItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var BatchGetItemResultSet = function(resultStream) {
    BatchGetItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(BatchGetItem, choreography.Choreography);
util.inherits(BatchGetItemInputSet, choreography.InputSet);
util.inherits(BatchGetItemResultSet, choreography.ResultSet);
exports.BatchGetItem = BatchGetItem;


/*
    BatchWriteItem
    Puts or deletes multiple items in one or more tables.
*/


var BatchWriteItem = function(session) {
    /*
        Create a new instance of the BatchWriteItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/BatchWriteItem"
    BatchWriteItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new BatchWriteItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new BatchWriteItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the BatchWriteItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var BatchWriteItemInputSet = function() {
    BatchWriteItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the RequestItems input for this Choreo. ((required, json) A map of one or more table names and, for each table, a list of operations to be performed (DeleteRequest or PutRequest). See choreo notes for more details.)
        */
        this.set_RequestItems = function(value) {
            this.setInput("RequestItems", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the ReturnItemCollectionMetrics input for this Choreo. ((optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.)
        */
        this.set_ReturnItemCollectionMetrics = function(value) {
            this.setInput("ReturnItemCollectionMetrics", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the BatchWriteItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var BatchWriteItemResultSet = function(resultStream) {
    BatchWriteItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(BatchWriteItem, choreography.Choreography);
util.inherits(BatchWriteItemInputSet, choreography.InputSet);
util.inherits(BatchWriteItemResultSet, choreography.ResultSet);
exports.BatchWriteItem = BatchWriteItem;


/*
    CreateTable
    Adds a new table to your account.
*/


var CreateTable = function(session) {
    /*
        Create a new instance of the CreateTable Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/CreateTable"
    CreateTable.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateTableResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateTableInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateTable
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateTableInputSet = function() {
    CreateTableInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the AttributeDefinitions input for this Choreo. ((required, json) An array of attributes that describe the key schema for the table and indexes.)
        */
        this.set_AttributeDefinitions = function(value) {
            this.setInput("AttributeDefinitions", value);
        }

        /*
        Set the value of the GlobalSecondaryIndexes input for this Choreo. ((optional, json) One or more global secondary indexes (the maximum is five) to be created on the table.)
        */
        this.set_GlobalSecondaryIndexes = function(value) {
            this.setInput("GlobalSecondaryIndexes", value);
        }

        /*
        Set the value of the KeySchema input for this Choreo. ((required, json) Specifies the attributes that make up the primary key for a table or an index. This is a JSON array of objects containing properties for AttributeName and KeyType. )
        */
        this.set_KeySchema = function(value) {
            this.setInput("KeySchema", value);
        }

        /*
        Set the value of the LocalSecondaryIndexes input for this Choreo. ((optional, json) One or more local secondary indexes (the maximum is five) to be created on the table.)
        */
        this.set_LocalSecondaryIndexes = function(value) {
            this.setInput("LocalSecondaryIndexes", value);
        }

        /*
        Set the value of the ProvisionedThroughput input for this Choreo. ((required, json) Represents the provisioned throughput settings for a specified table or index.)
        */
        this.set_ProvisionedThroughput = function(value) {
            this.setInput("ProvisionedThroughput", value);
        }

        /*
        Set the value of the StreamSpecification input for this Choreo. ((optional, json) The settings for DynamoDB Streams on the table.)
        */
        this.set_StreamSpecification = function(value) {
            this.setInput("StreamSpecification", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to create.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateTable Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateTableResultSet = function(resultStream) {
    CreateTableResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateTable, choreography.Choreography);
util.inherits(CreateTableInputSet, choreography.InputSet);
util.inherits(CreateTableResultSet, choreography.ResultSet);
exports.CreateTable = CreateTable;


/*
    DeleteItem
    Deletes a single item in a table by primary key.
*/


var DeleteItem = function(session) {
    /*
        Create a new instance of the DeleteItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/DeleteItem"
    DeleteItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteItemInputSet = function() {
    DeleteItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConditionExpression input for this Choreo. ((optional, string) A condition that must be satisfied in order for a conditional DeleteItem to succeed.)
        */
        this.set_ConditionExpression = function(value) {
            this.setInput("ConditionExpression", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the ExpressionAttributeValues input for this Choreo. ((optional, json) One or more values that can be substituted in an expression.)
        */
        this.set_ExpressionAttributeValues = function(value) {
            this.setInput("ExpressionAttributeValues", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to delete.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the ReturnItemCollectionMetrics input for this Choreo. ((optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.)
        */
        this.set_ReturnItemCollectionMetrics = function(value) {
            this.setInput("ReturnItemCollectionMetrics", value);
        }

        /*
        Set the value of the ReturnValues input for this Choreo. ((optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were deleted. Valid values are NONE and ALL_OLD.)
        */
        this.set_ReturnValues = function(value) {
            this.setInput("ReturnValues", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table from which to delete the item.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteItemResultSet = function(resultStream) {
    DeleteItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteItem, choreography.Choreography);
util.inherits(DeleteItemInputSet, choreography.InputSet);
util.inherits(DeleteItemResultSet, choreography.ResultSet);
exports.DeleteItem = DeleteItem;


/*
    DeleteTable
    Deletes a table and all of its items.
*/


var DeleteTable = function(session) {
    /*
        Create a new instance of the DeleteTable Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/DeleteTable"
    DeleteTable.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteTableResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteTableInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteTable
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteTableInputSet = function() {
    DeleteTableInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to delete.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteTable Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteTableResultSet = function(resultStream) {
    DeleteTableResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteTable, choreography.Choreography);
util.inherits(DeleteTableInputSet, choreography.InputSet);
util.inherits(DeleteTableResultSet, choreography.ResultSet);
exports.DeleteTable = DeleteTable;


/*
    DescribeLimits
    Returns the current provisioned-capacity limits for your AWS account in a region, both for the region as a whole and for any one DynamoDB table that you create there.
*/


var DescribeLimits = function(session) {
    /*
        Create a new instance of the DescribeLimits Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/DescribeLimits"
    DescribeLimits.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeLimitsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeLimitsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeLimits
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeLimitsInputSet = function() {
    DescribeLimitsInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeLimits Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeLimitsResultSet = function(resultStream) {
    DescribeLimitsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeLimits, choreography.Choreography);
util.inherits(DescribeLimitsInputSet, choreography.InputSet);
util.inherits(DescribeLimitsResultSet, choreography.ResultSet);
exports.DescribeLimits = DescribeLimits;


/*
    DescribeTable
    Returns information about the table.
*/


var DescribeTable = function(session) {
    /*
        Create a new instance of the DescribeTable Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/DescribeTable"
    DescribeTable.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DescribeTableResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DescribeTableInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DescribeTable
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DescribeTableInputSet = function() {
    DescribeTableInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to describe.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DescribeTable Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DescribeTableResultSet = function(resultStream) {
    DescribeTableResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DescribeTable, choreography.Choreography);
util.inherits(DescribeTableInputSet, choreography.InputSet);
util.inherits(DescribeTableResultSet, choreography.ResultSet);
exports.DescribeTable = DescribeTable;


/*
    GetItem
    Returns a set of attributes for the item with the given primary key.
*/


var GetItem = function(session) {
    /*
        Create a new instance of the GetItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/GetItem"
    GetItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetItemInputSet = function() {
    GetItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConsistentRead input for this Choreo. ((optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.)
        */
        this.set_ConsistentRead = function(value) {
            this.setInput("ConsistentRead", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the ProjectionExpression input for this Choreo. ((optional, string) A string that identifies one or more attributes to retrieve from the table.)
        */
        this.set_ProjectionExpression = function(value) {
            this.setInput("ProjectionExpression", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table containing the requested items.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetItemResultSet = function(resultStream) {
    GetItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetItem, choreography.Choreography);
util.inherits(GetItemInputSet, choreography.InputSet);
util.inherits(GetItemResultSet, choreography.ResultSet);
exports.GetItem = GetItem;


/*
    ListTables
    Returns an array of table names associated with the current account and endpoint.
*/


var ListTables = function(session) {
    /*
        Create a new instance of the ListTables Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/ListTables"
    ListTables.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListTablesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListTablesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListTables
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListTablesInputSet = function() {
    ListTablesInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ExclusiveStartTableName input for this Choreo. ((optional, string) The first table name that this operation will evaluate. Use the value that was returned for LastEvaluatedTableName in a previous request to retrieve the next page of results.)
        */
        this.set_ExclusiveStartTableName = function(value) {
            this.setInput("ExclusiveStartTableName", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) A maximum number of table names to return. Defaults to 100.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListTables Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListTablesResultSet = function(resultStream) {
    ListTablesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListTables, choreography.Choreography);
util.inherits(ListTablesInputSet, choreography.InputSet);
util.inherits(ListTablesResultSet, choreography.ResultSet);
exports.ListTables = ListTables;


/*
    PutItem
    Creates a new item, or replaces an old item with a new item.
*/


var PutItem = function(session) {
    /*
        Create a new instance of the PutItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/PutItem"
    PutItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PutItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PutItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PutItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PutItemInputSet = function() {
    PutItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConditionExpression input for this Choreo. ((optional, string) A condition that must be satisfied in order for a conditional PutItem operation to succeed.)
        */
        this.set_ConditionExpression = function(value) {
            this.setInput("ConditionExpression", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the ExpressionAttributeValues input for this Choreo. ((optional, json) One or more values that can be substituted in an expression.)
        */
        this.set_ExpressionAttributeValues = function(value) {
            this.setInput("ExpressionAttributeValues", value);
        }

        /*
        Set the value of the Item input for this Choreo. ((required, json) A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required.)
        */
        this.set_Item = function(value) {
            this.setInput("Item", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the ReturnItemCollectionMetrics input for this Choreo. ((optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.)
        */
        this.set_ReturnItemCollectionMetrics = function(value) {
            this.setInput("ReturnItemCollectionMetrics", value);
        }

        /*
        Set the value of the ReturnValues input for this Choreo. ((optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request. Valid values are NONE and ALL_OLD.)
        */
        this.set_ReturnValues = function(value) {
            this.setInput("ReturnValues", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to contain the item.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PutItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PutItemResultSet = function(resultStream) {
    PutItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PutItem, choreography.Choreography);
util.inherits(PutItemInputSet, choreography.InputSet);
util.inherits(PutItemResultSet, choreography.ResultSet);
exports.PutItem = PutItem;


/*
    Query
    Queries a table using the primary key or a secondary index.
*/


var Query = function(session) {
    /*
        Create a new instance of the Query Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/Query"
    Query.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new QueryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new QueryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Query
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var QueryInputSet = function() {
    QueryInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConsistentRead input for this Choreo. ((optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.)
        */
        this.set_ConsistentRead = function(value) {
            this.setInput("ConsistentRead", value);
        }

        /*
        Set the value of the ExclusiveStartKey input for this Choreo. ((optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.)
        */
        this.set_ExclusiveStartKey = function(value) {
            this.setInput("ExclusiveStartKey", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the ExpressionAttributeValues input for this Choreo. ((conditional, json) One or more values that can be substituted in an expression.)
        */
        this.set_ExpressionAttributeValues = function(value) {
            this.setInput("ExpressionAttributeValues", value);
        }

        /*
        Set the value of the FilterExpression input for this Choreo. ((optional, string) A string that contains conditions that DynamoDB applies after the Query operation, but before the data is returned to you.)
        */
        this.set_FilterExpression = function(value) {
            this.setInput("FilterExpression", value);
        }

        /*
        Set the value of the IndexName input for this Choreo. ((optional, string) The name of an index to query. This index can be any local secondary index or global secondary index on the table.)
        */
        this.set_IndexName = function(value) {
            this.setInput("IndexName", value);
        }

        /*
        Set the value of the KeyConditionExpression input for this Choreo. ((conditional, string) The condition that specifies the key value(s) for items to be retrieved by the Query action.)
        */
        this.set_KeyConditionExpression = function(value) {
            this.setInput("KeyConditionExpression", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the ProjectionExpression input for this Choreo. ((optional, string) A string that identifies one or more attributes to retrieve from the table.)
        */
        this.set_ProjectionExpression = function(value) {
            this.setInput("ProjectionExpression", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the ScanIndexForward input for this Choreo. ((optional, boolean) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.)
        */
        this.set_ScanIndexForward = function(value) {
            this.setInput("ScanIndexForward", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table containing the requested items.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Query Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var QueryResultSet = function(resultStream) {
    QueryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Query, choreography.Choreography);
util.inherits(QueryInputSet, choreography.InputSet);
util.inherits(QueryResultSet, choreography.ResultSet);
exports.Query = Query;


/*
    Scan
    Returns one or more items and item attributes by accessing every item in a table or a secondary index.
*/


var Scan = function(session) {
    /*
        Create a new instance of the Scan Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/Scan"
    Scan.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ScanResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ScanInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Scan
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ScanInputSet = function() {
    ScanInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConsistentRead input for this Choreo. ((optional, boolean) A Boolean value that determines the read consistency model during the scan.)
        */
        this.set_ConsistentRead = function(value) {
            this.setInput("ConsistentRead", value);
        }

        /*
        Set the value of the ExclusiveStartKey input for this Choreo. ((optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.)
        */
        this.set_ExclusiveStartKey = function(value) {
            this.setInput("ExclusiveStartKey", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the ExpressionAttributeValues input for this Choreo. ((optional, json) One or more values that can be substituted in an expression.)
        */
        this.set_ExpressionAttributeValues = function(value) {
            this.setInput("ExpressionAttributeValues", value);
        }

        /*
        Set the value of the FilterExpression input for this Choreo. ((optional, string) A string that contains conditions that DynamoDB applies after the Scan operation, but before the data is returned to you.)
        */
        this.set_FilterExpression = function(value) {
            this.setInput("FilterExpression", value);
        }

        /*
        Set the value of the IndexName input for this Choreo. ((optional, string) The name of an index to scan. This index can be any local secondary index or global secondary index on the table.)
        */
        this.set_IndexName = function(value) {
            this.setInput("IndexName", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the ProjectionExpression input for this Choreo. ((optional, string) A string that identifies one or more attributes to retrieve from the table.)
        */
        this.set_ProjectionExpression = function(value) {
            this.setInput("ProjectionExpression", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the Segment input for this Choreo. ((optional, integer) For a parallel Scan request, Segment identifies an individual segment to be scanned by an application worker.)
        */
        this.set_Segment = function(value) {
            this.setInput("Segment", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table containing the requested items.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the TotalSegments input for this Choreo. ((optional, integer) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.)
        */
        this.set_TotalSegments = function(value) {
            this.setInput("TotalSegments", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Scan Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ScanResultSet = function(resultStream) {
    ScanResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Scan, choreography.Choreography);
util.inherits(ScanInputSet, choreography.InputSet);
util.inherits(ScanResultSet, choreography.ResultSet);
exports.Scan = Scan;


/*
    UpdateItem
    Edits an existing item's attributes, or adds a new item to the table if it does not already exist.
*/


var UpdateItem = function(session) {
    /*
        Create a new instance of the UpdateItem Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/UpdateItem"
    UpdateItem.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateItemResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateItemInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateItem
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateItemInputSet = function() {
    UpdateItemInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the ConditionExpression input for this Choreo. ((optional, string) A condition that must be satisfied in order for a conditional update to succeed.)
        */
        this.set_ConditionExpression = function(value) {
            this.setInput("ConditionExpression", value);
        }

        /*
        Set the value of the ExpressionAttributeNames input for this Choreo. ((optional, json) One or more substitution tokens for attribute names in an expression.)
        */
        this.set_ExpressionAttributeNames = function(value) {
            this.setInput("ExpressionAttributeNames", value);
        }

        /*
        Set the value of the ExpressionAttributeValues input for this Choreo. ((optional, json) One or more values that can be substituted in an expression.)
        */
        this.set_ExpressionAttributeValues = function(value) {
            this.setInput("ExpressionAttributeValues", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, json) The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the ReturnConsumedCapacity input for this Choreo. ((optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.)
        */
        this.set_ReturnConsumedCapacity = function(value) {
            this.setInput("ReturnConsumedCapacity", value);
        }

        /*
        Set the value of the ReturnItemCollectionMetrics input for this Choreo. ((optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.)
        */
        this.set_ReturnItemCollectionMetrics = function(value) {
            this.setInput("ReturnItemCollectionMetrics", value);
        }

        /*
        Set the value of the ReturnValues input for this Choreo. ((optional, string) Use ReturnValues if you want to get the item attributes as they appeared either before or after they were updated. Valid values are NONE and ALL_OLD.)
        */
        this.set_ReturnValues = function(value) {
            this.setInput("ReturnValues", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to contain the item.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UpdateExpression input for this Choreo. ((optional, string) An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.)
        */
        this.set_UpdateExpression = function(value) {
            this.setInput("UpdateExpression", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateItem Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateItemResultSet = function(resultStream) {
    UpdateItemResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateItem, choreography.Choreography);
util.inherits(UpdateItemInputSet, choreography.InputSet);
util.inherits(UpdateItemResultSet, choreography.ResultSet);
exports.UpdateItem = UpdateItem;


/*
    UpdateTable
    Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
*/


var UpdateTable = function(session) {
    /*
        Create a new instance of the UpdateTable Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/DynamoDB/UpdateTable"
    UpdateTable.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateTableResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateTableInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateTable
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateTableInputSet = function() {
    UpdateTableInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the AttributeDefinitions input for this Choreo. ((optional, json) An array of attributes that describe the key schema for the table and indexes.)
        */
        this.set_AttributeDefinitions = function(value) {
            this.setInput("AttributeDefinitions", value);
        }

        /*
        Set the value of the GlobalSecondaryIndexUpdates input for this Choreo. ((conditional, json) One or more global secondary indexes (the maximum is five) to be created on the table.)
        */
        this.set_GlobalSecondaryIndexUpdates = function(value) {
            this.setInput("GlobalSecondaryIndexUpdates", value);
        }

        /*
        Set the value of the ProvisionedThroughput input for this Choreo. ((conditional, json) Represents the provisioned throughput settings for a specified table or index.)
        */
        this.set_ProvisionedThroughput = function(value) {
            this.setInput("ProvisionedThroughput", value);
        }

        /*
        Set the value of the StreamSpecification input for this Choreo. ((conditional, json) The settings for DynamoDB Streams on the table.)
        */
        this.set_StreamSpecification = function(value) {
            this.setInput("StreamSpecification", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the table to create.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateTable Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateTableResultSet = function(resultStream) {
    UpdateTableResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateTable, choreography.Choreography);
util.inherits(UpdateTableInputSet, choreography.InputSet);
util.inherits(UpdateTableResultSet, choreography.ResultSet);
exports.UpdateTable = UpdateTable;

