
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddProperty
    Adds a property to a file or folder using the Amazon Cloud Drive API.
*/


var AddProperty = function(session) {
    /*
        Create a new instance of the AddProperty Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Properties/AddProperty"
    AddProperty.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddPropertyResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddPropertyInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddProperty
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddPropertyInputSet = function() {
    AddPropertyInputSet.super_.call(this);
        /*
        Set the value of the Value input for this Choreo. ((required, string) The value of the property. Max length 500 characters.)
        */
        this.set_Value = function(value) {
            this.setInput("Value", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, string) The ID of the file or folder to which the properties needs to be added.)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, string) The key of the properties which needs to be added. The key should just contain alphanumeric and "_". Max length is 50 characters.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the Owner input for this Choreo. ((required, string) The "owner" of property.)
        */
        this.set_Owner = function(value) {
            this.setInput("Owner", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddProperty Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddPropertyResultSet = function(resultStream) {
    AddPropertyResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddProperty, choreography.Choreography);
util.inherits(AddPropertyInputSet, choreography.InputSet);
util.inherits(AddPropertyResultSet, choreography.ResultSet);
exports.AddProperty = AddProperty;


/*
    DeleteProperty
    Uses the Amazon Cloud Drive API to delete a specific property by key.
*/


var DeleteProperty = function(session) {
    /*
        Create a new instance of the DeleteProperty Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Properties/DeleteProperty"
    DeleteProperty.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeletePropertyResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeletePropertyInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteProperty
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeletePropertyInputSet = function() {
    DeletePropertyInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, string) The ID of the file or folder associated with the property being deleted.)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, string) The key of the properties which needs to be deleted.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the Owner input for this Choreo. ((required, string) The "owner" of property.)
        */
        this.set_Owner = function(value) {
            this.setInput("Owner", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteProperty Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeletePropertyResultSet = function(resultStream) {
    DeletePropertyResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "ResponseStatusCode" output from this Choreo execution. ((integer) The response status code returned from Amazon. A 204 is returned for a successful delete operation.)
        */
        this.get_ResponseStatusCode = function() {
            return this.getResult("ResponseStatusCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon. An empty result object is returned for a successful delete operation.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteProperty, choreography.Choreography);
util.inherits(DeletePropertyInputSet, choreography.InputSet);
util.inherits(DeletePropertyResultSet, choreography.ResultSet);
exports.DeleteProperty = DeleteProperty;


/*
    GetProperty
    Queries the Amazon Cloud Drive API to retrieve a specific property by key.
*/


var GetProperty = function(session) {
    /*
        Create a new instance of the GetProperty Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Properties/GetProperty"
    GetProperty.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetPropertyResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetPropertyInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetProperty
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetPropertyInputSet = function() {
    GetPropertyInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, string) The ID of the file or folder associated with the property being retrieved.)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the Key input for this Choreo. ((required, string) The key of the properties which needs to be retrieved.)
        */
        this.set_Key = function(value) {
            this.setInput("Key", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the Owner input for this Choreo. ((required, string) The "owner" of property.)
        */
        this.set_Owner = function(value) {
            this.setInput("Owner", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetProperty Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetPropertyResultSet = function(resultStream) {
    GetPropertyResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetProperty, choreography.Choreography);
util.inherits(GetPropertyInputSet, choreography.InputSet);
util.inherits(GetPropertyResultSet, choreography.ResultSet);
exports.GetProperty = GetProperty;


/*
    ListProperties
    Queries the Amazon Cloud Drive API to return a list of properties for a specified file or folder.
*/


var ListProperties = function(session) {
    /*
        Create a new instance of the ListProperties Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Properties/ListProperties"
    ListProperties.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListPropertiesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListPropertiesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListProperties
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListPropertiesInputSet = function() {
    ListPropertiesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, integer) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the ID input for this Choreo. ((required, string) The ID of the file or folder to list properties for.)
        */
        this.set_ID = function(value) {
            this.setInput("ID", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the Owner input for this Choreo. ((required, string) The "owner" of properties to list.)
        */
        this.set_Owner = function(value) {
            this.setInput("Owner", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListProperties Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListPropertiesResultSet = function(resultStream) {
    ListPropertiesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListProperties, choreography.Choreography);
util.inherits(ListPropertiesInputSet, choreography.InputSet);
util.inherits(ListPropertiesResultSet, choreography.ResultSet);
exports.ListProperties = ListProperties;

