
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetNews
    Retrieves the most recent Yahoo Finance Company or Industry news items as an RSS feed.
*/


var GetNews = function(session) {
    /*
        Create a new instance of the GetNews Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Finance/GetNews"
    GetNews.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetNewsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetNewsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetNews
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetNewsInputSet = function() {
    GetNewsInputSet.super_.call(this);
        /*
        Set the value of the Company input for this Choreo. ((required, string) Ticker symbol for one or more companies to search, separated by commas (e.g. YHOO,DIS to include news about Yahoo! and Disney).)
        */
        this.set_Company = function(value) {
            this.setInput("Company", value);
        }

        /*
        Set the value of the NewsType input for this Choreo. ((required, string) Enter the type of news items you want to see in the RSS feed: headline or industry.)
        */
        this.set_NewsType = function(value) {
            this.setInput("NewsType", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetNews Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetNewsResultSet = function(resultStream) {
    GetNewsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo Finance.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetNews, choreography.Choreography);
util.inherits(GetNewsInputSet, choreography.InputSet);
util.inherits(GetNewsResultSet, choreography.ResultSet);
exports.GetNews = GetNews;


/*
    GetStockQuote
    Retrieves information for the specified stock symbol from Yahoo Finance.
*/


var GetStockQuote = function(session) {
    /*
        Create a new instance of the GetStockQuote Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Finance/GetStockQuote"
    GetStockQuote.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetStockQuoteResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetStockQuoteInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetStockQuote
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetStockQuoteInputSet = function() {
    GetStockQuoteInputSet.super_.call(this);
        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the StockSymbol input for this Choreo. ((required, string) The stock ticker symbol to search for (e.g., AAPL, GOOG, etc).)
        */
        this.set_StockSymbol = function(value) {
            this.setInput("StockSymbol", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetStockQuote Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetStockQuoteResultSet = function(resultStream) {
    GetStockQuoteResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Ask" output from this Choreo execution. ((decimal) The asking price.)
        */
        this.get_Ask = function() {
            return this.getResult("Ask");
        }
        /*
        Retrieve the value for the "Bid" output from this Choreo execution. ((decimal) The bid price.)
        */
        this.get_Bid = function() {
            return this.getResult("Bid");
        }
        /*
        Retrieve the value for the "Change" output from this Choreo execution. ((string) The change in the stock price.)
        */
        this.get_Change = function() {
            return this.getResult("Change");
        }
        /*
        Retrieve the value for the "DaysHigh" output from this Choreo execution. ((decimal) The high price of the day.)
        */
        this.get_DaysHigh = function() {
            return this.getResult("DaysHigh");
        }
        /*
        Retrieve the value for the "DaysLow" output from this Choreo execution. ((decimal) The low price of the day.)
        */
        this.get_DaysLow = function() {
            return this.getResult("DaysLow");
        }
        /*
        Retrieve the value for the "LastTradePriceOnly" output from this Choreo execution. ((decimal) The last trade price.)
        */
        this.get_LastTradePriceOnly = function() {
            return this.getResult("LastTradePriceOnly");
        }
        /*
        Retrieve the value for the "Open" output from this Choreo execution. ((decimal) The price when the market last opened.)
        */
        this.get_Open = function() {
            return this.getResult("Open");
        }
        /*
        Retrieve the value for the "PreviousClose" output from this Choreo execution. ((decimal) The previous closing price.)
        */
        this.get_PreviousClose = function() {
            return this.getResult("PreviousClose");
        }
        /*
        Retrieve the value for the "Volume" output from this Choreo execution. ((integer) The volume traded.)
        */
        this.get_Volume = function() {
            return this.getResult("Volume");
        }
        /*
        Retrieve the value for the "YearHigh" output from this Choreo execution. ((decimal) The price for the year high.)
        */
        this.get_YearHigh = function() {
            return this.getResult("YearHigh");
        }
        /*
        Retrieve the value for the "YearLow" output from this Choreo execution. ((decimal) The price for the year low.)
        */
        this.get_YearLow = function() {
            return this.getResult("YearLow");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo Finance.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetStockQuote, choreography.Choreography);
util.inherits(GetStockQuoteInputSet, choreography.InputSet);
util.inherits(GetStockQuoteResultSet, choreography.ResultSet);
exports.GetStockQuote = GetStockQuote;

