
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AlertsPerTime
    Returns high-level statistics about the number of alerts sent for a specified time period.
*/


var AlertsPerTime = function(session) {
    /*
        Create a new instance of the AlertsPerTime Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Reports/AlertsPerTime"
    AlertsPerTime.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AlertsPerTimeResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AlertsPerTimeInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AlertsPerTime
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AlertsPerTimeInputSet = function() {
    AlertsPerTimeInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Rollup input for this Choreo. ((optional, string) Used to rollup totals by time period. Valid values are: daily, weekly, or monthly.)
        */
        this.set_Rollup = function(value) {
            this.setInput("Rollup", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AlertsPerTime Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AlertsPerTimeResultSet = function(resultStream) {
    AlertsPerTimeResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AlertsPerTime, choreography.Choreography);
util.inherits(AlertsPerTimeInputSet, choreography.InputSet);
util.inherits(AlertsPerTimeResultSet, choreography.ResultSet);
exports.AlertsPerTime = AlertsPerTime;


/*
    IncidentsPerTime
    Returns high-level statistics about the number of incidents created for a specified time period.
*/


var IncidentsPerTime = function(session) {
    /*
        Create a new instance of the IncidentsPerTime Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Reports/IncidentsPerTime"
    IncidentsPerTime.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new IncidentsPerTimeResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new IncidentsPerTimeInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the IncidentsPerTime
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var IncidentsPerTimeInputSet = function() {
    IncidentsPerTimeInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Rollup input for this Choreo. ((optional, string) Used to rollup totals by time period. Valid values are: daily, weekly, or monthly.)
        */
        this.set_Rollup = function(value) {
            this.setInput("Rollup", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the IncidentsPerTime Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var IncidentsPerTimeResultSet = function(resultStream) {
    IncidentsPerTimeResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(IncidentsPerTime, choreography.Choreography);
util.inherits(IncidentsPerTimeInputSet, choreography.InputSet);
util.inherits(IncidentsPerTimeResultSet, choreography.ResultSet);
exports.IncidentsPerTime = IncidentsPerTime;

