
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ListAlerts
    List alerts for a given time range and allows you to filter by type.
*/


var ListAlerts = function(session) {
    /*
        Create a new instance of the ListAlerts Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Alerts/ListAlerts"
    ListAlerts.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListAlertsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListAlertsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListAlerts
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListAlertsInputSet = function() {
    ListAlertsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Filter input for this Choreo. ((optional, string) Returns only alerts of this type. Valid types are: SMS, Email, Phone, or Push.)
        */
        this.set_Filter = function(value) {
            this.setInput("Filter", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListAlerts Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListAlertsResultSet = function(resultStream) {
    ListAlertsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListAlerts, choreography.Choreography);
util.inherits(ListAlertsInputSet, choreography.InputSet);
util.inherits(ListAlertsResultSet, choreography.ResultSet);
exports.ListAlerts = ListAlerts;

