
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Add
    Adds or subtracts a value from an existing numeric property value.
*/


var Add = function(session) {
    /*
        Create a new instance of the Add Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Add"
    Add.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Add
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddInputSet = function() {
    AddInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((conditional, json) A JSON object containing names and values of custom profile properties. The current value will be added to any existing property value. If the property doesn't exist, the value will be added to 0.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Add Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddResultSet = function(resultStream) {
    AddResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Add, choreography.Choreography);
util.inherits(AddInputSet, choreography.InputSet);
util.inherits(AddResultSet, choreography.ResultSet);
exports.Add = Add;


/*
    Append
    Appends a value to a list property on a profile.
*/


var Append = function(session) {
    /*
        Create a new instance of the Append Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Append"
    Append.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AppendResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AppendInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Append
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AppendInputSet = function() {
    AppendInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((conditional, json) A JSON object containing a name/value pair representing a list name and value. The current value will be appended to any existing lists. If the list doesn't exist, it will be created.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Append Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AppendResultSet = function(resultStream) {
    AppendResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Append, choreography.Choreography);
util.inherits(AppendInputSet, choreography.InputSet);
util.inherits(AppendResultSet, choreography.ResultSet);
exports.Append = Append;


/*
    Delete
    Permanently deletes the profile from Mixpanel, along with all of its properties.
*/


var Delete = function(session) {
    /*
        Create a new instance of the Delete Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Delete"
    Delete.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Delete
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteInputSet = function() {
    DeleteInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Delete Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteResultSet = function(resultStream) {
    DeleteResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Delete, choreography.Choreography);
util.inherits(DeleteInputSet, choreography.InputSet);
util.inherits(DeleteResultSet, choreography.ResultSet);
exports.Delete = Delete;


/*
    Set
    Sets the properties of a profile.
*/


var Set = function(session) {
    /*
        Create a new instance of the Set Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Set"
    Set.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Set
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SetInputSet = function() {
    SetInputSet.super_.call(this);
        /*
        Set the value of the City input for this Choreo. ((optional, string) The city associated with the user's location.)
        */
        this.set_City = function(value) {
            this.setInput("City", value);
        }

        /*
        Set the value of the Created input for this Choreo. ((optional, date) The time when the user created their account. This should be expressed as YYYY-MM-DDThh:mm:ss.)
        */
        this.set_Created = function(value) {
            this.setInput("Created", value);
        }

        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the Email input for this Choreo. ((optional, string) The user's email address. Mixpanel can use this property when sending email notifications to your users.)
        */
        this.set_Email = function(value) {
            this.setInput("Email", value);
        }

        /*
        Set the value of the FirstName input for this Choreo. ((optional, string) The first name of the user represented the profile.)
        */
        this.set_FirstName = function(value) {
            this.setInput("FirstName", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the LastName input for this Choreo. ((optional, string) The last name of the user representing the profile.)
        */
        this.set_LastName = function(value) {
            this.setInput("LastName", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((optional, string) The full name of the user. This can be used as an alternative to FirstName and LastName.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the Phone input for this Choreo. ((optional, string) The user's phone number (e.g., 4805551212). Mixpanel can use this property when sending SMS messages to your users.)
        */
        this.set_Phone = function(value) {
            this.setInput("Phone", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((optional, json) A JSON object containing names and values of custom profile properties. Note that properties that exist already will be overwritten.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Region input for this Choreo. ((optional, string) The region associated with a user's location.)
        */
        this.set_Region = function(value) {
            this.setInput("Region", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Timezone input for this Choreo. ((optional, string) The timezone associated with a user's location.)
        */
        this.set_Timezone = function(value) {
            this.setInput("Timezone", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Set Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SetResultSet = function(resultStream) {
    SetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Set, choreography.Choreography);
util.inherits(SetInputSet, choreography.InputSet);
util.inherits(SetResultSet, choreography.ResultSet);
exports.Set = Set;


/*
    SetOnce
    Sets the properties of a profile, but will not overwrite existing properties.
*/


var SetOnce = function(session) {
    /*
        Create a new instance of the SetOnce Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/SetOnce"
    SetOnce.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SetOnceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SetOnceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SetOnce
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SetOnceInputSet = function() {
    SetOnceInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((conditional, json) A JSON object containing names and values of custom profile properties. Note that properties existing already will not be overwritten.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SetOnce Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SetOnceResultSet = function(resultStream) {
    SetOnceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SetOnce, choreography.Choreography);
util.inherits(SetOnceInputSet, choreography.InputSet);
util.inherits(SetOnceResultSet, choreography.ResultSet);
exports.SetOnce = SetOnce;


/*
    Transaction
    Appends transaction data to a profile.
*/


var Transaction = function(session) {
    /*
        Create a new instance of the Transaction Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Transaction"
    Transaction.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TransactionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TransactionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Transaction
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TransactionInputSet = function() {
    TransactionInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the TransactionAmount input for this Choreo. ((required, decimal) The amount of the transaction.)
        */
        this.set_TransactionAmount = function(value) {
            this.setInput("TransactionAmount", value);
        }

        /*
        Set the value of the TransactionProperties input for this Choreo. ((optional, json) A JSON object containing any transaction properties you wish to set (e.g. SKU, Product Name, etc).)
        */
        this.set_TransactionProperties = function(value) {
            this.setInput("TransactionProperties", value);
        }

        /*
        Set the value of the TransactionTime input for this Choreo. ((conditional, date) The time of the transaction (e.g., 2013-01-03T09:00:00). If this isn't provided, the current time in UTC is specified.)
        */
        this.set_TransactionTime = function(value) {
            this.setInput("TransactionTime", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Transaction Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TransactionResultSet = function(resultStream) {
    TransactionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Transaction, choreography.Choreography);
util.inherits(TransactionInputSet, choreography.InputSet);
util.inherits(TransactionResultSet, choreography.ResultSet);
exports.Transaction = Transaction;


/*
    Union
    Merges list values with an existing list on a profile.
*/


var Union = function(session) {
    /*
        Create a new instance of the Union Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Union"
    Union.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UnionResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UnionInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Union
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UnionInputSet = function() {
    UnionInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((required, json) A JSON object containing a list name and an array of values. The list values in the request are merged with the existing list on the user profile, ignoring duplicate list values.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Union Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UnionResultSet = function(resultStream) {
    UnionResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Union, choreography.Choreography);
util.inherits(UnionInputSet, choreography.InputSet);
util.inherits(UnionResultSet, choreography.ResultSet);
exports.Union = Union;


/*
    Unset
    Removes the specified properties and their values from a profile.
*/


var Unset = function(session) {
    /*
        Create a new instance of the Unset Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/Profiles/Unset"
    Unset.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UnsetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UnsetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Unset
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UnsetInputSet = function() {
    UnsetInputSet.super_.call(this);
        /*
        Set the value of the DistinctID input for this Choreo. ((required, string) Used to uniquely identify the profile you want to update.)
        */
        this.set_DistinctID = function(value) {
            this.setInput("DistinctID", value);
        }

        /*
        Set the value of the IP input for this Choreo. ((optional, string) An IP address string associated with the profile (e.g., 127.0.0.1). When set to 0 (the default) Mixpanel will ignore IP information.)
        */
        this.set_IP = function(value) {
            this.setInput("IP", value);
        }

        /*
        Set the value of the IgnoreTime input for this Choreo. ((optional, boolean) When set to true, Mixpanel will not automatically update the "Last Seen" property of the profile. Otherwise, Mixpanel will add a "Last Seen" property associated with any set, append, or add requests.)
        */
        this.set_IgnoreTime = function(value) {
            this.setInput("IgnoreTime", value);
        }

        /*
        Set the value of the ProfileProperties input for this Choreo. ((conditional, json) A JSON array of property names to remove from a profile.)
        */
        this.set_ProfileProperties = function(value) {
            this.setInput("ProfileProperties", value);
        }

        /*
        Set the value of the Time input for this Choreo. ((optional, date) A unix timestamp representing the time of the profile update. If not provided, Mixpanel will use the time the update arrives at the server.)
        */
        this.set_Time = function(value) {
            this.setInput("Time", value);
        }

        /*
        Set the value of the Token input for this Choreo. ((required, string) The token provided by Mixpanel. You can find your Mixpanel token in the project settings dialog in the Mixpanel app.)
        */
        this.set_Token = function(value) {
            this.setInput("Token", value);
        }

        /*
        Set the value of the Verbose input for this Choreo. ((optional, boolean) When set to 1, the response will contain more information describing the success or failure of the tracking call.)
        */
        this.set_Verbose = function(value) {
            this.setInput("Verbose", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Unset Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UnsetResultSet = function(resultStream) {
    UnsetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Unset, choreography.Choreography);
util.inherits(UnsetInputSet, choreography.InputSet);
util.inherits(UnsetResultSet, choreography.ResultSet);
exports.Unset = Unset;

