
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    FunnelData
    Gets data for a specified funnel.
*/


var FunnelData = function(session) {
    /*
        Create a new instance of the FunnelData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Funnels/FunnelData"
    FunnelData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new FunnelDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new FunnelDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the FunnelData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var FunnelDataInputSet = function() {
    FunnelDataInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the FromDate input for this Choreo. ((optional, date) The first date in yyyy-mm-dd format from which a user can begin the first step in the funnel. This date is inclusive.)
        */
        this.set_FromDate = function(value) {
            this.setInput("FromDate", value);
        }

        /*
        Set the value of the FunnelID input for this Choreo. ((required, string) The ID of the funnel to get data for.)
        */
        this.set_FunnelID = function(value) {
            this.setInput("FunnelID", value);
        }

        /*
        Set the value of the Interval input for this Choreo. ((optional, integer) The number of days you want your results bucketed into.The default value is 1.)
        */
        this.set_Interval = function(value) {
            this.setInput("Interval", value);
        }

        /*
        Set the value of the Length input for this Choreo. ((optional, integer) The number of days each user has to complete the funnel, starting from the time they triggered the first step in the funnel. May not be greater than 60 days. Defaults to 14.)
        */
        this.set_Length = function(value) {
            this.setInput("Length", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) Return the top limit property values. This parameter is ignored if the On input is not specified.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the On input for this Choreo. ((optional, string) The property expression to segment the event on (e.g., properties["Referred By"] == "Friend"). See Choreo description for examples.)
        */
        this.set_On = function(value) {
            this.setInput("On", value);
        }

        /*
        Set the value of the ToDate input for this Choreo. ((optional, date) The last date in yyyy-mm-dd format from which a user can begin the first step in the funnel. This date is inclusive. The date range may not be more than 60 days.)
        */
        this.set_ToDate = function(value) {
            this.setInput("ToDate", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((optional, string) This is an alternate way of specifying interval and can set to be 'day' or 'week'.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

        /*
        Set the value of the Where input for this Choreo. ((optional, string) An expression to filter events by  (e.g., properties["Signed Up"]). See Choreo description for examples.)
        */
        this.set_Where = function(value) {
            this.setInput("Where", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the FunnelData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var FunnelDataResultSet = function(resultStream) {
    FunnelDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(FunnelData, choreography.Choreography);
util.inherits(FunnelDataInputSet, choreography.InputSet);
util.inherits(FunnelDataResultSet, choreography.ResultSet);
exports.FunnelData = FunnelData;


/*
    FunnelList
    Gets the names and funnel_ids of your funnels.
*/


var FunnelList = function(session) {
    /*
        Create a new instance of the FunnelList Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Funnels/FunnelList"
    FunnelList.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new FunnelListResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new FunnelListInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the FunnelList
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var FunnelListInputSet = function() {
    FunnelListInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the FunnelList Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var FunnelListResultSet = function(resultStream) {
    FunnelListResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(FunnelList, choreography.Choreography);
util.inherits(FunnelListInputSet, choreography.InputSet);
util.inherits(FunnelListResultSet, choreography.ResultSet);
exports.FunnelList = FunnelList;

