
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CreateTableRow
    Creates new rows in a table.
*/


var CreateTableRow = function(session) {
    /*
        Create a new instance of the CreateTableRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/CreateTableRow"
    CreateTableRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateTableRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateTableRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateTableRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateTableRowInputSet = function() {
    CreateTableRowInputSet.super_.call(this);
        /*
        Set the value of the Values input for this Choreo. ((required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.)
        */
        this.set_Values = function(value) {
            this.setInput("Values", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Index input for this Choreo. ((optional, integer) Indicates that the row should be created at this index.)
        */
        this.set_Index = function(value) {
            this.setInput("Index", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table to write to (e.g. Table1).)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet to write to (e.g. Sheet1).)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateTableRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateTableRowResultSet = function(resultStream) {
    CreateTableRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateTableRow, choreography.Choreography);
util.inherits(CreateTableRowInputSet, choreography.InputSet);
util.inherits(CreateTableRowResultSet, choreography.ResultSet);
exports.CreateTableRow = CreateTableRow;


/*
    DataBodyRange
    Gets the range object associated with the data body of the table.
*/


var DataBodyRange = function(session) {
    /*
        Create a new instance of the DataBodyRange Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/DataBodyRange"
    DataBodyRange.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DataBodyRangeResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DataBodyRangeInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DataBodyRange
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DataBodyRangeInputSet = function() {
    DataBodyRangeInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table.)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DataBodyRange Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DataBodyRangeResultSet = function(resultStream) {
    DataBodyRangeResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DataBodyRange, choreography.Choreography);
util.inherits(DataBodyRangeInputSet, choreography.InputSet);
util.inherits(DataBodyRangeResultSet, choreography.ResultSet);
exports.DataBodyRange = DataBodyRange;


/*
    DeleteRow
    Deletes the row from the table.
*/


var DeleteRow = function(session) {
    /*
        Create a new instance of the DeleteRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/DeleteRow"
    DeleteRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteRowInputSet = function() {
    DeleteRowInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Index input for this Choreo. ((required, integer) The index of the row that should be deleted.)
        */
        this.set_Index = function(value) {
            this.setInput("Index", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table.)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteRowResultSet = function(resultStream) {
    DeleteRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ResponseCode" output from this Choreo execution. ((integer) The response status code. A 204 is returned for a successful deletion.)
        */
        this.get_ResponseCode = function() {
            return this.getResult("ResponseCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteRow, choreography.Choreography);
util.inherits(DeleteRowInputSet, choreography.InputSet);
util.inherits(DeleteRowResultSet, choreography.ResultSet);
exports.DeleteRow = DeleteRow;


/*
    GetRow
    Retrieve the properties and relationships of tablerow object.
*/


var GetRow = function(session) {
    /*
        Create a new instance of the GetRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/GetRow"
    GetRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetRowInputSet = function() {
    GetRowInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Index input for this Choreo. ((required, integer) The index of the row that should be returned. If left empty, the last row in the table will be returned.)
        */
        this.set_Index = function(value) {
            this.setInput("Index", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table.)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetRowResultSet = function(resultStream) {
    GetRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetRow, choreography.Choreography);
util.inherits(GetRowInputSet, choreography.InputSet);
util.inherits(GetRowResultSet, choreography.ResultSet);
exports.GetRow = GetRow;


/*
    ListColumns
    Retrieve a list of tablecolumn objects.
*/


var ListColumns = function(session) {
    /*
        Create a new instance of the ListColumns Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/ListColumns"
    ListColumns.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListColumnsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListColumnsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListColumns
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListColumnsInputSet = function() {
    ListColumnsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Skip input for this Choreo. ((optional, integer) The number of items to skip in a result set.)
        */
        this.set_Skip = function(value) {
            this.setInput("Skip", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table.)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Top input for this Choreo. ((optional, integer) The number of items to return in a result set.)
        */
        this.set_Top = function(value) {
            this.setInput("Top", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListColumns Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListColumnsResultSet = function(resultStream) {
    ListColumnsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListColumns, choreography.Choreography);
util.inherits(ListColumnsInputSet, choreography.InputSet);
util.inherits(ListColumnsResultSet, choreography.ResultSet);
exports.ListColumns = ListColumns;


/*
    ListRows
    Retrieve a list of tablerow objects.
*/


var ListRows = function(session) {
    /*
        Create a new instance of the ListRows Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/ListRows"
    ListRows.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListRowsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListRowsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListRows
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListRowsInputSet = function() {
    ListRowsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Skip input for this Choreo. ((optional, integer) The number of items to skip in a result set.)
        */
        this.set_Skip = function(value) {
            this.setInput("Skip", value);
        }

        /*
        Set the value of the Table input for this Choreo. ((required, string) The name or id of the table.)
        */
        this.set_Table = function(value) {
            this.setInput("Table", value);
        }

        /*
        Set the value of the Top input for this Choreo. ((optional, integer) The number of items to return in a result set.)
        */
        this.set_Top = function(value) {
            this.setInput("Top", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListRows Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListRowsResultSet = function(resultStream) {
    ListRowsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListRows, choreography.Choreography);
util.inherits(ListRowsInputSet, choreography.InputSet);
util.inherits(ListRowsResultSet, choreography.ResultSet);
exports.ListRows = ListRows;


/*
    ListTables
    Retrieves a list of tables.
*/


var ListTables = function(session) {
    /*
        Create a new instance of the ListTables Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Table/ListTables"
    ListTables.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListTablesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListTablesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListTables
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListTablesInputSet = function() {
    ListTablesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Skip input for this Choreo. ((optional, integer) The number of items to skip in a result set.)
        */
        this.set_Skip = function(value) {
            this.setInput("Skip", value);
        }

        /*
        Set the value of the Top input for this Choreo. ((optional, integer) The number of items to return in a result set.)
        */
        this.set_Top = function(value) {
            this.setInput("Top", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListTables Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListTablesResultSet = function(resultStream) {
    ListTablesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListTables, choreography.Choreography);
util.inherits(ListTablesInputSet, choreography.InputSet);
util.inherits(ListTablesResultSet, choreography.ResultSet);
exports.ListTables = ListTables;

