
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    Copy
    Copies a file or folder to a different location in the user's Dropbox.
*/


var Copy = function(session) {
    /*
        Create a new instance of the Copy Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Copy"
    Copy.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CopyResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CopyInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Copy
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CopyInputSet = function() {
    CopyInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AllowSharedFolder input for this Choreo. ((optional, boolean) If true, contents are copied into a shared folder, otherwise an error will be returned if the FromPath contains a shared folder. The default for this field is false.)
        */
        this.set_AllowSharedFolder = function(value) {
            this.setInput("AllowSharedFolder", value);
        }

        /*
        Set the value of the AutoRename input for this Choreo. ((optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.)
        */
        this.set_AutoRename = function(value) {
            this.setInput("AutoRename", value);
        }

        /*
        Set the value of the FromPath input for this Choreo. ((required, string) Path in the user's Dropbox to be copied or moved.)
        */
        this.set_FromPath = function(value) {
            this.setInput("FromPath", value);
        }

        /*
        Set the value of the ToPath input for this Choreo. ((required, string) Path in the user's Dropbox that is the destination.)
        */
        this.set_ToPath = function(value) {
            this.setInput("ToPath", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Copy Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CopyResultSet = function(resultStream) {
    CopyResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Copy, choreography.Choreography);
util.inherits(CopyInputSet, choreography.InputSet);
util.inherits(CopyResultSet, choreography.ResultSet);
exports.Copy = Copy;


/*
    CopyReferenceGet
    Gets a copy reference to a file or folder.
*/


var CopyReferenceGet = function(session) {
    /*
        Create a new instance of the CopyReferenceGet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/CopyReferenceGet"
    CopyReferenceGet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CopyReferenceGetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CopyReferenceGetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CopyReferenceGet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CopyReferenceGetInputSet = function() {
    CopyReferenceGetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path to the file or folder you want to get a copy reference to.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CopyReferenceGet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CopyReferenceGetResultSet = function(resultStream) {
    CopyReferenceGetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CopyReferenceGet, choreography.Choreography);
util.inherits(CopyReferenceGetInputSet, choreography.InputSet);
util.inherits(CopyReferenceGetResultSet, choreography.ResultSet);
exports.CopyReferenceGet = CopyReferenceGet;


/*
    CopyReferenceSave
    Saves a copy reference returned by CopyReferenceGet to the user's Dropbox.
*/


var CopyReferenceSave = function(session) {
    /*
        Create a new instance of the CopyReferenceSave Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/CopyReferenceSave"
    CopyReferenceSave.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CopyReferenceSaveResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CopyReferenceSaveInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CopyReferenceSave
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CopyReferenceSaveInputSet = function() {
    CopyReferenceSaveInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the CopyReference input for this Choreo. ((required, string) A copy reference returned by CopyReferenceGet.)
        */
        this.set_CopyReference = function(value) {
            this.setInput("CopyReference", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) Path in the user's Dropbox that is the destination.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CopyReferenceSave Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CopyReferenceSaveResultSet = function(resultStream) {
    CopyReferenceSaveResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CopyReferenceSave, choreography.Choreography);
util.inherits(CopyReferenceSaveInputSet, choreography.InputSet);
util.inherits(CopyReferenceSaveResultSet, choreography.ResultSet);
exports.CopyReferenceSave = CopyReferenceSave;


/*
    CreateFolder
    Creates a folder at a given path.
*/


var CreateFolder = function(session) {
    /*
        Create a new instance of the CreateFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/CreateFolder"
    CreateFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateFolderInputSet = function() {
    CreateFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AutoRename input for this Choreo. ((optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.)
        */
        this.set_AutoRename = function(value) {
            this.setInput("AutoRename", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) Path in the user's Dropbox to create.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateFolderResultSet = function(resultStream) {
    CreateFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateFolder, choreography.Choreography);
util.inherits(CreateFolderInputSet, choreography.InputSet);
util.inherits(CreateFolderResultSet, choreography.ResultSet);
exports.CreateFolder = CreateFolder;


/*
    Delete
    Deletes the file or folder at a given path.
*/


var Delete = function(session) {
    /*
        Create a new instance of the Delete Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Delete"
    Delete.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Delete
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteInputSet = function() {
    DeleteInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) Path in the user's Dropbox to delete.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Delete Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteResultSet = function(resultStream) {
    DeleteResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Delete, choreography.Choreography);
util.inherits(DeleteInputSet, choreography.InputSet);
util.inherits(DeleteResultSet, choreography.ResultSet);
exports.Delete = Delete;


/*
    Download
    Downloads a file from a user's Dropbox.
*/


var Download = function(session) {
    /*
        Create a new instance of the Download Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Download"
    Download.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DownloadResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DownloadInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Download
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DownloadInputSet = function() {
    DownloadInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Encode input for this Choreo. ((optional, boolean) Binary files must be returned as Base64-encoded data. If the file you are donwloading is plain text, you can set this to false to return the raw data. Defaults to true. )
        */
        this.set_Encode = function(value) {
            this.setInput("Encode", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path of the file to download.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Download Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DownloadResultSet = function(resultStream) {
    DownloadResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Download, choreography.Choreography);
util.inherits(DownloadInputSet, choreography.InputSet);
util.inherits(DownloadResultSet, choreography.ResultSet);
exports.Download = Download;


/*
    GetLatestCursor
    Gets a cursor for the folder's state.
*/


var GetLatestCursor = function(session) {
    /*
        Create a new instance of the GetLatestCursor Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/GetLatestCursor"
    GetLatestCursor.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLatestCursorResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLatestCursorInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLatestCursor
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLatestCursorInputSet = function() {
    GetLatestCursorInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the IncludeDeleted input for this Choreo. ((optional, boolean) If true, the results will include entries for files and folders that used to exist but were deleted. The default for this field is false.)
        */
        this.set_IncludeDeleted = function(value) {
            this.setInput("IncludeDeleted", value);
        }

        /*
        Set the value of the IncludeHasExplicitSharedMembers input for this Choreo. ((optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.)
        */
        this.set_IncludeHasExplicitSharedMembers = function(value) {
            this.setInput("IncludeHasExplicitSharedMembers", value);
        }

        /*
        Set the value of the IncludeMediaInfo input for this Choreo. ((optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.)
        */
        this.set_IncludeMediaInfo = function(value) {
            this.setInput("IncludeMediaInfo", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path to the folder you want to see the contents of. This should be empty to list contents at the root level.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Recursive input for this Choreo. ((optional, boolean) If true, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. The default for this field is false.)
        */
        this.set_Recursive = function(value) {
            this.setInput("Recursive", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLatestCursor Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLatestCursorResultSet = function(resultStream) {
    GetLatestCursorResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Cursor" output from this Choreo execution. ((string) A cursor used to retrieve the next set of results with ListFolderContinue.)
        */
        this.get_Cursor = function() {
            return this.getResult("Cursor");
        }
}

util.inherits(GetLatestCursor, choreography.Choreography);
util.inherits(GetLatestCursorInputSet, choreography.InputSet);
util.inherits(GetLatestCursorResultSet, choreography.ResultSet);
exports.GetLatestCursor = GetLatestCursor;


/*
    GetMetadata
    Returns the metadata for a file or folder.
*/


var GetMetadata = function(session) {
    /*
        Create a new instance of the GetMetadata Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/GetMetadata"
    GetMetadata.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetMetadataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetMetadataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetMetadata
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetMetadataInputSet = function() {
    GetMetadataInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the IncludeDeleted input for this Choreo. ((optional, boolean) If true, DeletedMetadata will be returned for deleted file or folder, otherwise LookupError.not_found will be returned. The default for this field is false.)
        */
        this.set_IncludeDeleted = function(value) {
            this.setInput("IncludeDeleted", value);
        }

        /*
        Set the value of the IncludeHasExplicitSharedMembers input for this Choreo. ((optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.)
        */
        this.set_IncludeHasExplicitSharedMembers = function(value) {
            this.setInput("IncludeHasExplicitSharedMembers", value);
        }

        /*
        Set the value of the IncludeMediaInfo input for this Choreo. ((optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.)
        */
        this.set_IncludeMediaInfo = function(value) {
            this.setInput("IncludeMediaInfo", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path of a file or folder on Dropbox.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetMetadata Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetMetadataResultSet = function(resultStream) {
    GetMetadataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetMetadata, choreography.Choreography);
util.inherits(GetMetadataInputSet, choreography.InputSet);
util.inherits(GetMetadataResultSet, choreography.ResultSet);
exports.GetMetadata = GetMetadata;


/*
    GetThumbnail
    Gets a thumbnail for an image.
*/


var GetThumbnail = function(session) {
    /*
        Create a new instance of the GetThumbnail Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/GetThumbnail"
    GetThumbnail.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetThumbnailResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetThumbnailInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetThumbnail
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetThumbnailInputSet = function() {
    GetThumbnailInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((optional, string) The format for the thumbnail image, jpeg (default) or png.)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path of the file to download.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Size input for this Choreo. ((optional, string) The size for the thumbnail image. The default for this union is w64h64.)
        */
        this.set_Size = function(value) {
            this.setInput("Size", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetThumbnail Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetThumbnailResultSet = function(resultStream) {
    GetThumbnailResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetThumbnail, choreography.Choreography);
util.inherits(GetThumbnailInputSet, choreography.InputSet);
util.inherits(GetThumbnailResultSet, choreography.ResultSet);
exports.GetThumbnail = GetThumbnail;


/*
    ListFolder
    Starts returning the contents of a folder.
*/


var ListFolder = function(session) {
    /*
        Create a new instance of the ListFolder Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/ListFolder"
    ListFolder.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListFolderResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListFolderInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListFolder
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListFolderInputSet = function() {
    ListFolderInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the IncludeDeleted input for this Choreo. ((optional, boolean) If true, the results will include entries for files and folders that used to exist but were deleted. The default for this field is false.)
        */
        this.set_IncludeDeleted = function(value) {
            this.setInput("IncludeDeleted", value);
        }

        /*
        Set the value of the IncludeHasExplicitSharedMembers input for this Choreo. ((optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.)
        */
        this.set_IncludeHasExplicitSharedMembers = function(value) {
            this.setInput("IncludeHasExplicitSharedMembers", value);
        }

        /*
        Set the value of the IncludeMediaInfo input for this Choreo. ((optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.)
        */
        this.set_IncludeMediaInfo = function(value) {
            this.setInput("IncludeMediaInfo", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path to the folder you want to see the contents of. This should be empty to list contents at the root level.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Recursive input for this Choreo. ((optional, boolean) If true, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. The default for this field is false.)
        */
        this.set_Recursive = function(value) {
            this.setInput("Recursive", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListFolder Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListFolderResultSet = function(resultStream) {
    ListFolderResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Cursor" output from this Choreo execution. ((string) A cursor used to retrieve the next set of results with ListFolderContinue.)
        */
        this.get_Cursor = function() {
            return this.getResult("Cursor");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListFolder, choreography.Choreography);
util.inherits(ListFolderInputSet, choreography.InputSet);
util.inherits(ListFolderResultSet, choreography.ResultSet);
exports.ListFolder = ListFolder;


/*
    ListFolderContinue
    Once a cursor has been retrieved from ListFolder, use this to paginate through all files and retrieve updates to the folder.
*/


var ListFolderContinue = function(session) {
    /*
        Create a new instance of the ListFolderContinue Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/ListFolderContinue"
    ListFolderContinue.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListFolderContinueResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListFolderContinueInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListFolderContinue
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListFolderContinueInputSet = function() {
    ListFolderContinueInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Cursor input for this Choreo. ((required, string) A cursor used to retrieve the next set of results.)
        */
        this.set_Cursor = function(value) {
            this.setInput("Cursor", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListFolderContinue Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListFolderContinueResultSet = function(resultStream) {
    ListFolderContinueResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "LatestCursor" output from this Choreo execution. ((string) The latest cursor which can be used to retrieve the next set of results.)
        */
        this.get_LatestCursor = function() {
            return this.getResult("LatestCursor");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListFolderContinue, choreography.Choreography);
util.inherits(ListFolderContinueInputSet, choreography.InputSet);
util.inherits(ListFolderContinueResultSet, choreography.ResultSet);
exports.ListFolderContinue = ListFolderContinue;


/*
    ListRevisions
    Returns revisions of a file.
*/


var ListRevisions = function(session) {
    /*
        Create a new instance of the ListRevisions Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/ListRevisions"
    ListRevisions.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListRevisionsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListRevisionsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListRevisions
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListRevisionsInputSet = function() {
    ListRevisionsInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of revisions to return. The default for this field is 10.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((conditional, string) The path to the file you want to see the revisions of.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListRevisions Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListRevisionsResultSet = function(resultStream) {
    ListRevisionsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListRevisions, choreography.Choreography);
util.inherits(ListRevisionsInputSet, choreography.InputSet);
util.inherits(ListRevisionsResultSet, choreography.ResultSet);
exports.ListRevisions = ListRevisions;


/*
    Move
    Moves a file or folder to a different location in the user's Dropbox.
*/


var Move = function(session) {
    /*
        Create a new instance of the Move Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Move"
    Move.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new MoveResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new MoveInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Move
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var MoveInputSet = function() {
    MoveInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AllowSharedFolder input for this Choreo. ((optional, boolean) If true, contents are copied into a shared folder, otherwise an error will be returned if the FromPath contains a shared folder. The default for this field is false.)
        */
        this.set_AllowSharedFolder = function(value) {
            this.setInput("AllowSharedFolder", value);
        }

        /*
        Set the value of the AutoRename input for this Choreo. ((optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.)
        */
        this.set_AutoRename = function(value) {
            this.setInput("AutoRename", value);
        }

        /*
        Set the value of the FromPath input for this Choreo. ((required, string) Path in the user's Dropbox to be copied or moved.)
        */
        this.set_FromPath = function(value) {
            this.setInput("FromPath", value);
        }

        /*
        Set the value of the ToPath input for this Choreo. ((required, string) Path in the user's Dropbox that is the destination.)
        */
        this.set_ToPath = function(value) {
            this.setInput("ToPath", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Move Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var MoveResultSet = function(resultStream) {
    MoveResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Move, choreography.Choreography);
util.inherits(MoveInputSet, choreography.InputSet);
util.inherits(MoveResultSet, choreography.ResultSet);
exports.Move = Move;


/*
    Restore
    Restores a file to a specific revision.
*/


var Restore = function(session) {
    /*
        Create a new instance of the Restore Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Restore"
    Restore.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RestoreResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RestoreInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Restore
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RestoreInputSet = function() {
    RestoreInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((conditional, string) The path to the file you want to see the revisions of.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Revision input for this Choreo. ((required, string) The number of revisions to return. The default for this field is 10.)
        */
        this.set_Revision = function(value) {
            this.setInput("Revision", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Restore Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RestoreResultSet = function(resultStream) {
    RestoreResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Restore, choreography.Choreography);
util.inherits(RestoreInputSet, choreography.InputSet);
util.inherits(RestoreResultSet, choreography.ResultSet);
exports.Restore = Restore;


/*
    Search
    Searches for files and folders.
*/


var Search = function(session) {
    /*
        Create a new instance of the Search Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Search"
    Search.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SearchResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SearchInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Search
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SearchInputSet = function() {
    SearchInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the MaxResults input for this Choreo. ((optional, boolean) The maximum number of search results to return. The default for this field is 100.)
        */
        this.set_MaxResults = function(value) {
            this.setInput("MaxResults", value);
        }

        /*
        Set the value of the Mode input for this Choreo. ((optional, string) The search mode (filename, filename_and_content, or deleted_filename). Note that searching file content is only available for Dropbox Business accounts. The default for this union is filename.)
        */
        this.set_Mode = function(value) {
            this.setInput("Mode", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((conditional, string) Path in the user's Dropbox to search. This should be empty to search at the root level.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Query input for this Choreo. ((optional, boolean) The string to search for. )
        */
        this.set_Query = function(value) {
            this.setInput("Query", value);
        }

        /*
        Set the value of the Start input for this Choreo. ((optional, integer) The starting index within the search results (used for paging). The default for this field is 0.)
        */
        this.set_Start = function(value) {
            this.setInput("Start", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Search Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SearchResultSet = function(resultStream) {
    SearchResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Search, choreography.Choreography);
util.inherits(SearchInputSet, choreography.InputSet);
util.inherits(SearchResultSet, choreography.ResultSet);
exports.Search = Search;


/*
    Upload
    Creates a new file with the contents provided in the request.
*/


var Upload = function(session) {
    /*
        Create a new instance of the Upload Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/Upload"
    Upload.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UploadResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UploadInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Upload
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UploadInputSet = function() {
    UploadInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AutoRename input for this Choreo. ((optional, boolean) If there's a conflict, as determined by mode, have the Dropbox server try to autorename the file to avoid conflict. The default for this field is false.)
        */
        this.set_AutoRename = function(value) {
            this.setInput("AutoRename", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the FileContent input for this Choreo. ((conditional, string) The Base64-encoded file content of the file you want to upload. Required unless uploading a file from a URL using the FileURL input. Encoding is not required when ContentType is set to "text/plain".)
        */
        this.set_FileContent = function(value) {
            this.setInput("FileContent", value);
        }

        /*
        Set the value of the FileURL input for this Choreo. ((optional, string) The public URL for file you want to upload. This can be used as an alternative to uploading Base64 encoded data.)
        */
        this.set_FileURL = function(value) {
            this.setInput("FileURL", value);
        }

        /*
        Set the value of the Mode input for this Choreo. ((optional, string) Selects what to do if the file already exists. Valid values are: add (default), overwrite, and update.)
        */
        this.set_Mode = function(value) {
            this.setInput("Mode", value);
        }

        /*
        Set the value of the Mute input for this Choreo. ((optional, boolean) If true, this tells the clients that this modification shouldn't result in a user notification. The default for this field is false.)
        */
        this.set_Mute = function(value) {
            this.setInput("Mute", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) Path in the user's Dropbox to save the file, including the filename.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Revision input for this Choreo. ((optional, string) The revision identifier. Used only when Mode is set to "update".)
        */
        this.set_Revision = function(value) {
            this.setInput("Revision", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Upload Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UploadResultSet = function(resultStream) {
    UploadResultSet.super_.call(this, resultStream);    
}

util.inherits(Upload, choreography.Choreography);
util.inherits(UploadInputSet, choreography.InputSet);
util.inherits(UploadResultSet, choreography.ResultSet);
exports.Upload = Upload;


/*
    UploadSessionAppend
    Appends more data to an upload session.
*/


var UploadSessionAppend = function(session) {
    /*
        Create a new instance of the UploadSessionAppend Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/UploadSessionAppend"
    UploadSessionAppend.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UploadSessionAppendResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UploadSessionAppendInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UploadSessionAppend
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UploadSessionAppendInputSet = function() {
    UploadSessionAppendInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Close input for this Choreo. ((optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.)
        */
        this.set_Close = function(value) {
            this.setInput("Close", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the FileContent input for this Choreo. ((conditional, string) The next file segment to upload. Binary files should be Base64-encoded. Encoding is not required when ContentType is set to "text/plain".)
        */
        this.set_FileContent = function(value) {
            this.setInput("FileContent", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((required, integer) The amount of data that has been uploaded so far.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the SessionID input for this Choreo. ((conditional, string) The upload session ID returned from UploadSessionStart.)
        */
        this.set_SessionID = function(value) {
            this.setInput("SessionID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UploadSessionAppend Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UploadSessionAppendResultSet = function(resultStream) {
    UploadSessionAppendResultSet.super_.call(this, resultStream);    
}

util.inherits(UploadSessionAppend, choreography.Choreography);
util.inherits(UploadSessionAppendInputSet, choreography.InputSet);
util.inherits(UploadSessionAppendResultSet, choreography.ResultSet);
exports.UploadSessionAppend = UploadSessionAppend;


/*
    UploadSessionFinish
    Finishes an upload session and save the uploaded data to the given file path.
*/


var UploadSessionFinish = function(session) {
    /*
        Create a new instance of the UploadSessionFinish Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/UploadSessionFinish"
    UploadSessionFinish.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UploadSessionFinishResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UploadSessionFinishInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UploadSessionFinish
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UploadSessionFinishInputSet = function() {
    UploadSessionFinishInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AutoRename input for this Choreo. ((optional, boolean) If there's a conflict, as determined by mode, have the Dropbox server try to autorename the file to avoid conflict. The default for this field is false.)
        */
        this.set_AutoRename = function(value) {
            this.setInput("AutoRename", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the FileContent input for this Choreo. ((conditional, string) The remaining file content. Encoding is not required when ContentType is set to "text/plain". This can be left empty if the last file chunk was sent using UploadSessionAppend.)
        */
        this.set_FileContent = function(value) {
            this.setInput("FileContent", value);
        }

        /*
        Set the value of the Mode input for this Choreo. ((optional, string) Selects what to do if the file already exists. Valid values are: add (default), overwrite, and update.)
        */
        this.set_Mode = function(value) {
            this.setInput("Mode", value);
        }

        /*
        Set the value of the Mute input for this Choreo. ((optional, boolean) If true, this tells the clients that this modification shouldn't result in a user notification. The default for this field is false.)
        */
        this.set_Mute = function(value) {
            this.setInput("Mute", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((required, integer) The amount of data that has been uploaded so far.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) Path in the user's Dropbox to save the file.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the Revision input for this Choreo. ((optional, string) The revision identifier. Used only when Mode is set to "update".)
        */
        this.set_Revision = function(value) {
            this.setInput("Revision", value);
        }

        /*
        Set the value of the SessionID input for this Choreo. ((required, string) The upload session ID returned from UploadSessionStart.)
        */
        this.set_SessionID = function(value) {
            this.setInput("SessionID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UploadSessionFinish Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UploadSessionFinishResultSet = function(resultStream) {
    UploadSessionFinishResultSet.super_.call(this, resultStream);    
}

util.inherits(UploadSessionFinish, choreography.Choreography);
util.inherits(UploadSessionFinishInputSet, choreography.InputSet);
util.inherits(UploadSessionFinishResultSet, choreography.ResultSet);
exports.UploadSessionFinish = UploadSessionFinish;


/*
    UploadSessionStart
    Allows you to upload a single file in one or more requests. This call starts a new upload session with the first chunk of data.
*/


var UploadSessionStart = function(session) {
    /*
        Create a new instance of the UploadSessionStart Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Files/UploadSessionStart"
    UploadSessionStart.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UploadSessionStartResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UploadSessionStartInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UploadSessionStart
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UploadSessionStartInputSet = function() {
    UploadSessionStartInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Close input for this Choreo. ((optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.)
        */
        this.set_Close = function(value) {
            this.setInput("Close", value);
        }

        /*
        Set the value of the ContentType input for this Choreo. ((optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.)
        */
        this.set_ContentType = function(value) {
            this.setInput("ContentType", value);
        }

        /*
        Set the value of the FileContent input for this Choreo. ((conditional, string) The first file segment to upload. Binary files should be Base64-encoded. Encoding is not required when ContentType is set to "text/plain".)
        */
        this.set_FileContent = function(value) {
            this.setInput("FileContent", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UploadSessionStart Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UploadSessionStartResultSet = function(resultStream) {
    UploadSessionStartResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "SessionID" output from this Choreo execution. ((string) The upload session ID that can be used to append to the upload or finish the upload.)
        */
        this.get_SessionID = function() {
            return this.getResult("SessionID");
        }
}

util.inherits(UploadSessionStart, choreography.Choreography);
util.inherits(UploadSessionStartInputSet, choreography.InputSet);
util.inherits(UploadSessionStartResultSet, choreography.ResultSet);
exports.UploadSessionStart = UploadSessionStart;

