
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    PostText
    Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource.
*/


var PostText = function(session) {
    /*
        Create a new instance of the PostText Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/Lex/RuntimeService/PostText"
    PostText.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PostTextResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PostTextInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PostText
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PostTextInputSet = function() {
    PostTextInputSet.super_.call(this);
        /*
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        */
        this.set_AWSAccessKeyId = function(value) {
            this.setInput("AWSAccessKeyId", value);
        }

        /*
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        */
        this.set_AWSSecretKeyId = function(value) {
            this.setInput("AWSSecretKeyId", value);
        }

        /*
        Set the value of the InputString input for this Choreo. ((required, string) )
        */
        this.set_InputString = function(value) {
            this.setInput("InputString", value);
        }

        /*
        Set the value of the UserRegion input for this Choreo. ((optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        */
        this.set_UserRegion = function(value) {
            this.setInput("UserRegion", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PostText Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PostTextResultSet = function(resultStream) {
    PostTextResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PostText, choreography.Choreography);
util.inherits(PostTextInputSet, choreography.InputSet);
util.inherits(PostTextResultSet, choreography.ResultSet);
exports.PostText = PostText;

