package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMemberMessages

Retrieves a list of the messages that buyers have posted about your active item listings.
*/
public class GetMemberMessages extends Choreography {

	/**
	Create a new instance of the GetMemberMessages Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMemberMessages(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetMemberMessages"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMemberMessagesInputSet
	*/
	public GetMemberMessagesInputSet newInputSet() {
		return new GetMemberMessagesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMemberMessagesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMemberMessagesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMemberMessages
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMemberMessagesInputSet extends InputSet {
		/** 
		Set the value of the DisplayToPublic input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, only public messages (viewable in the Item listing) are returned.
		*/
		public void set_DisplayToPublic(Boolean value) {
			this.setInput("DisplayToPublic", value);
		}

		/** 
		Set the value of the DisplayToPublic input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, only public messages (viewable in the Item listing) are returned.
		*/
		public void set_DisplayToPublic(String value) {
			this.setInput("DisplayToPublic", value);	
		}
		/** 
		Set the value of the EndCreationTime input for this Choreo. 

		@param String - (optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
		*/
		public void set_EndCreationTime(String value) {
			this.setInput("EndCreationTime", value);
		}


		/** 
		Set the value of the EntriesPerPage input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(Integer value) {
			this.setInput("EntriesPerPage", value);
		}

		/** 
		Set the value of the EntriesPerPage input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of records to return in the result.
		*/
		public void set_EntriesPerPage(String value) {
			this.setInput("EntriesPerPage", value);	
		}
		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (optional, string) The ID of the item the message is about.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the MailMessageType input for this Choreo. 

		@param String - (required, string) The type of message to retrieve. Valid values are: All and AskSellerQuestion. When set to AskSellerQuestion, ItemID or a date range filter must be specified.
		*/
		public void set_MailMessageType(String value) {
			this.setInput("MailMessageType", value);
		}


		/** 
		Set the value of the MemberMessageID input for this Choreo. 

		@param String - (optional, string) An ID that uniquely identifies the message for a given user to be retrieved.
		*/
		public void set_MemberMessageID(String value) {
			this.setInput("MemberMessageID", value);
		}


		/** 
		Set the value of the MessageStatus input for this Choreo. 

		@param String - (optional, string) The status of the message. Valid values are: Answered and Unanswered.
		*/
		public void set_MessageStatus(String value) {
			this.setInput("MessageStatus", value);
		}


		/** 
		Set the value of the PageNumber input for this Choreo. 

		@param Integer - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(Integer value) {
			this.setInput("PageNumber", value);
		}

		/** 
		Set the value of the PageNumber input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the page number of the results to return.
		*/
		public void set_PageNumber(String value) {
			this.setInput("PageNumber", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SenderID input for this Choreo. 

		@param String - (optional, string) The seller's UserID.
		*/
		public void set_SenderID(String value) {
			this.setInput("SenderID", value);
		}


		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the StartCreationTime input for this Choreo. 

		@param String - (optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
		*/
		public void set_StartCreationTime(String value) {
			this.setInput("StartCreationTime", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMemberMessages Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMemberMessagesResultSet extends ResultSet {
		public GetMemberMessagesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
