package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FetchToken

Completes the authentication process by retrieving an eBay user token after they have visited the authorization URL returned by the GetSessionID Choreo and clicked "I agree".
*/
public class FetchToken extends Choreography {

	/**
	Create a new instance of the FetchToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FetchToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/FetchToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FetchTokenInputSet
	*/
	public FetchTokenInputSet newInputSet() {
		return new FetchTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FetchTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FetchTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FetchToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FetchTokenInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The unique identifier for the application.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the CertID input for this Choreo. 

		@param String - (required, string) The certificate that authenticates the application when making API calls.
		*/
		public void set_CertID(String value) {
			this.setInput("CertID", value);
		}


		/** 
		Set the value of the DevID input for this Choreo. 

		@param String - (required, string) The unique identifier for the developer's account.
		*/
		public void set_DevID(String value) {
			this.setInput("DevID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SessionID input for this Choreo. 

		@param String - (required, string) The SessionID returned from PayPal. This gets passed to the FetchToken Choreo after the user authorizes the request.
		*/
		public void set_SessionID(String value) {
			this.setInput("SessionID", value);
		}


		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the Timeout input for this Choreo. 

		@param Integer - (optional, integer) The amount of time (in seconds) to poll eBay to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
		*/
		public void set_Timeout(Integer value) {
			this.setInput("Timeout", value);
		}

		/** 
		Set the value of the Timeout input for this Choreo as a String. 

		@param String - (optional, integer) The amount of time (in seconds) to poll eBay to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
		*/
		public void set_Timeout(String value) {
			this.setInput("Timeout", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FetchToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FetchTokenResultSet extends ResultSet {
		public FetchTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "UserToken" output from this Choreo execution

		@return String - (string) An eBay Auth Token which can be used to make requests the user's behalf.
		*/
		public String get_UserToken() {
			return this.getResultString("UserToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
