package com.temboo.Library.Zendesk.Groups;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateGroup

Updates an existing group.
*/
public class UpdateGroup extends Choreography {

	/**
	Create a new instance of the UpdateGroup Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateGroup(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Groups/UpdateGroup"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateGroupInputSet
	*/
	public UpdateGroupInputSet newInputSet() {
		return new UpdateGroupInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateGroupResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateGroupResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateGroup
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateGroupInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the GroupID input for this Choreo. 

		@param String - (conditional, string) The ID of the Group to be updated.
		*/
		public void set_GroupID(String value) {
			this.setInput("GroupID", value);
		}


		/** 
		Set the value of the GroupName input for this Choreo. 

		@param String - (required, string) New name to update the Group with.
		*/
		public void set_GroupName(String value) {
			this.setInput("GroupName", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateGroup Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateGroupResultSet extends ResultSet {
		public UpdateGroupResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
