package com.temboo.Library.Yahoo.Finance;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetNews

Retrieves the most recent Yahoo Finance Company or Industry news items as an RSS feed.
*/
public class GetNews extends Choreography {

	/**
	Create a new instance of the GetNews Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetNews(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/Finance/GetNews"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetNewsInputSet
	*/
	public GetNewsInputSet newInputSet() {
		return new GetNewsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetNewsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetNewsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetNews
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetNewsInputSet extends InputSet {
		/** 
		Set the value of the Company input for this Choreo. 

		@param String - (required, string) Ticker symbol for one or more companies to search, separated by commas (e.g. YHOO,DIS to include news about Yahoo! and Disney).
		*/
		public void set_Company(String value) {
			this.setInput("Company", value);
		}


		/** 
		Set the value of the NewsType input for this Choreo. 

		@param String - (required, string) Enter the type of news items you want to see in the RSS feed: headline or industry.
		*/
		public void set_NewsType(String value) {
			this.setInput("NewsType", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetNews Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetNewsResultSet extends ResultSet {
		public GetNewsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo Finance.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
