package com.temboo.Library.Utilities.Finding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindSubstring

Finds all occurrences of a specified substring and returns the substring positions as a JSON array.
*/
public class FindSubstring extends Choreography {

	/**
	Create a new instance of the FindSubstring Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindSubstring(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Finding/FindSubstring"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindSubstringInputSet
	*/
	public FindSubstringInputSet newInputSet() {
		return new FindSubstringInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindSubstringResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindSubstringResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindSubstring
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindSubstringInputSet extends InputSet {
		/** 
		Set the value of the CaseSensitive input for this Choreo. 

		@param Boolean - (optional, boolean) When set to true, the search will be case-sensitive. Defaults to false indicating a case-insensitive search.
		*/
		public void set_CaseSensitive(Boolean value) {
			this.setInput("CaseSensitive", value);
		}

		/** 
		Set the value of the CaseSensitive input for this Choreo as a String. 

		@param String - (optional, boolean) When set to true, the search will be case-sensitive. Defaults to false indicating a case-insensitive search.
		*/
		public void set_CaseSensitive(String value) {
			this.setInput("CaseSensitive", value);	
		}
		/** 
		Set the value of the StartNumber input for this Choreo. 

		@param String - (optional, string) The character position at which to begin the search. Defaults to 1.
		*/
		public void set_StartNumber(String value) {
			this.setInput("StartNumber", value);
		}


		/** 
		Set the value of the Substring input for this Choreo. 

		@param String - (required, string) The sub-string to search within the specified text (searching from left to right).
		*/
		public void set_Substring(String value) {
			this.setInput("Substring", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) The text to search for a sub-string.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindSubstring Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindSubstringResultSet extends ResultSet {
		public FindSubstringResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Count" output from this Choreo execution

		@return String - (integer) The count of sub-strings found.
		*/
		public String get_Count() {
			return this.getResultString("Count");
		}
		/** 
		Retrieve the value for the "Positions" output from this Choreo execution

		@return String - (json) The positions of the sub-strings that were found in the search.
		*/
		public String get_Positions() {
			return this.getResultString("Positions");
		}
	}
	
}
