package com.temboo.Library.Utilities.Encoding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Base64Encode

Returns the specified text or file as a Base64 encoded string.
*/
public class Base64Encode extends Choreography {

	/**
	Create a new instance of the Base64Encode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Base64Encode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Encoding/Base64Encode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return Base64EncodeInputSet
	*/
	public Base64EncodeInputSet newInputSet() {
		return new Base64EncodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public Base64EncodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new Base64EncodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Base64Encode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class Base64EncodeInputSet extends InputSet {
		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (conditional, string) The text that should be Base64 encoded. Required unless providing a value for the URL input.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (conditional, string) A URL to a hosted file that should be Base64 encoded. Required unless providing a value for the Text input.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Base64Encode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class Base64EncodeResultSet extends ResultSet {
		public Base64EncodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Base64EncodedText" output from this Choreo execution

		@return String - (string) The Base64 encoded text.
		*/
		public String get_Base64EncodedText() {
			return this.getResultString("Base64EncodedText");
		}
	}
	
}
