package com.temboo.Library.PayPal.AdaptivePayments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PaymentDetails

Retrieves information about a specific payment.
*/
public class PaymentDetails extends Choreography {

	/**
	Create a new instance of the PaymentDetails Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PaymentDetails(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/AdaptivePayments/PaymentDetails"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PaymentDetailsInputSet
	*/
	public PaymentDetailsInputSet newInputSet() {
		return new PaymentDetailsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PaymentDetailsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PaymentDetailsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PaymentDetails
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PaymentDetailsInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) Your PayPal AppID (or the default AppID for the PayPal sandbox).
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PayKey input for this Choreo. 

		@param String - (conditional, string) The pay key that identifies the payment for which you want to retrieve details. This is the pay key returned in the response of the Pay method.
		*/
		public void set_PayKey(String value) {
			this.setInput("PayKey", value);
		}


		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the TrackingID input for this Choreo. 

		@param String - (optional, string) The tracking ID that was specified for this payment in the PayRequest message.
		*/
		public void set_TrackingID(String value) {
			this.setInput("TrackingID", value);
		}


		/** 
		Set the value of the TransactionID input for this Choreo. 

		@param String - (optional, string) The PayPal transaction ID associated with the payment. The Instant Payment Notification message associated with the payment contains the transaction ID.
		*/
		public void set_TransactionID(String value) {
			this.setInput("TransactionID", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PaymentDetails Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PaymentDetailsResultSet extends ResultSet {
		public PaymentDetailsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccountID" output from this Choreo execution

		@return String - (string) The account id of the payment reciever.
		*/
		public String get_AccountID() {
			return this.getResultString("AccountID");
		}
		/** 
		Retrieve the value for the "Amount" output from this Choreo execution

		@return String - (decimal) The payment amount.
		*/
		public String get_Amount() {
			return this.getResultString("Amount");
		}
		/** 
		Retrieve the value for the "CurrencyCode" output from this Choreo execution

		@return String - (string) The currency code for the payment.
		*/
		public String get_CurrencyCode() {
			return this.getResultString("CurrencyCode");
		}
		/** 
		Retrieve the value for the "Email" output from this Choreo execution

		@return String - (string) The receiver email address.
		*/
		public String get_Email() {
			return this.getResultString("Email");
		}
		/** 
		Retrieve the value for the "Status" output from this Choreo execution

		@return String - (string) The status of the payment.
		*/
		public String get_Status() {
			return this.getResultString("Status");
		}
		/** 
		Retrieve the value for the "TransactionStatus" output from this Choreo execution

		@return String - (string) The transaction status of the payment.
		*/
		public String get_TransactionStatus() {
			return this.getResultString("TransactionStatus");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PayPal.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
